/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.parser;

import java.util.function.Function;
import org.apache.drill.exec.store.easy.json.parser.ArrayListener;
import org.apache.drill.exec.store.easy.json.parser.ArrayParser;
import org.apache.drill.exec.store.easy.json.parser.ArrayValueParser;
import org.apache.drill.exec.store.easy.json.parser.DummyValueParser;
import org.apache.drill.exec.store.easy.json.parser.ElementParser;
import org.apache.drill.exec.store.easy.json.parser.JsonStructureParser;
import org.apache.drill.exec.store.easy.json.parser.JsonValueParser;
import org.apache.drill.exec.store.easy.json.parser.ObjectParser;
import org.apache.drill.exec.store.easy.json.parser.ObjectValueParser;
import org.apache.drill.exec.store.easy.json.parser.ScalarValueParser;
import org.apache.drill.exec.store.easy.json.parser.ValueListener;
import org.apache.drill.exec.store.easy.json.parser.ValueParser;

public class FieldParserFactory {
    private final JsonStructureParser structParser;
    private final Function<JsonStructureParser, ObjectParser> parserFactory;

    public FieldParserFactory(JsonStructureParser structParser, Function<JsonStructureParser, ObjectParser> parserFactory) {
        this.structParser = structParser;
        this.parserFactory = parserFactory;
    }

    public ObjectParser rootParser() {
        return this.parserFactory.apply(this.structParser);
    }

    public ElementParser ignoredFieldParser() {
        return DummyValueParser.INSTANCE;
    }

    public ValueParser jsonTextParser(ValueListener fieldListener) {
        return new JsonValueParser(this.structParser, fieldListener);
    }

    public ValueParser simpleValueParser(ValueListener fieldListener) {
        return new ScalarValueParser.SimpleValueParser(this.structParser, fieldListener);
    }

    public ValueParser textValueParser(ValueListener fieldListener) {
        return new ScalarValueParser.TextValueParser(this.structParser, fieldListener);
    }

    public ElementParser scalarArrayValueParser(ArrayListener arrayListener, ElementParser elementParser) {
        return new ArrayValueParser.LenientArrayValueParser(new ArrayParser(this.structParser, arrayListener, elementParser));
    }

    public ElementParser arrayValueParser(ArrayListener arrayListener, ElementParser elementParser) {
        return new ArrayValueParser(new ArrayParser(this.structParser, arrayListener, elementParser));
    }

    public ElementParser objectValueParser(ObjectParser objParser) {
        return new ObjectValueParser(objParser);
    }
}

