/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.parser;

import com.fasterxml.jackson.core.JsonToken;
import org.apache.drill.exec.store.easy.json.parser.AbstractElementParser;
import org.apache.drill.exec.store.easy.json.parser.ArrayListener;
import org.apache.drill.exec.store.easy.json.parser.ElementParser;
import org.apache.drill.exec.store.easy.json.parser.JsonStructureParser;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;

public class ArrayParser
extends AbstractElementParser {
    private final ArrayListener arrayListener;
    private final ElementParser elementParser;

    public ArrayParser(JsonStructureParser structParser, ArrayListener arrayListener, ElementParser elementParser) {
        super(structParser);
        this.arrayListener = arrayListener;
        this.elementParser = elementParser;
    }

    public ElementParser elementParser() {
        return this.elementParser;
    }

    public <T extends ArrayListener> T listener() {
        return (T)this.arrayListener;
    }

    @Override
    public void parse(TokenIterator tokenizer) {
        this.arrayListener.onStart();
        block3: while (true) {
            JsonToken token = tokenizer.requireNext();
            switch (token) {
                case END_ARRAY: {
                    break block3;
                }
                default: {
                    tokenizer.unget(token);
                    this.parseElement(tokenizer);
                    continue block3;
                }
            }
            break;
        }
        this.arrayListener.onEnd();
    }

    private void parseElement(TokenIterator tokenizer) {
        this.arrayListener.onElementStart();
        this.elementParser.parse(tokenizer);
        this.arrayListener.onElementEnd();
    }
}

