/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.loader;

import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.easy.json.loader.FieldDefn;
import org.apache.drill.exec.store.easy.json.loader.FieldFactory;
import org.apache.drill.exec.store.easy.json.loader.JsonLoaderImpl;
import org.apache.drill.exec.store.easy.json.parser.ElementParser;
import org.apache.drill.exec.store.easy.json.parser.JsonStructureParser;
import org.apache.drill.exec.store.easy.json.parser.ObjectParser;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;
import org.apache.drill.exec.vector.accessor.TupleWriter;

public class TupleParser
extends ObjectParser {
    private final JsonLoaderImpl loader;
    private final TupleWriter tupleWriter;
    private final TupleMetadata providedSchema;

    public TupleParser(JsonStructureParser structParser, JsonLoaderImpl loader, TupleWriter tupleWriter, TupleMetadata providedSchema) {
        super(structParser);
        this.loader = loader;
        this.tupleWriter = tupleWriter;
        this.providedSchema = providedSchema;
    }

    public TupleParser(JsonLoaderImpl loader, TupleWriter tupleWriter, TupleMetadata providedSchema) {
        this(loader.parser(), loader, tupleWriter, providedSchema);
    }

    public JsonLoaderImpl loader() {
        return this.loader;
    }

    public TupleWriter writer() {
        return this.tupleWriter;
    }

    protected TupleMetadata providedSchema() {
        return this.providedSchema;
    }

    protected FieldFactory fieldFactory() {
        return this.loader.fieldFactory();
    }

    @Override
    public ElementParser onField(String key, TokenIterator tokenizer) {
        if (this.projectField(key)) {
            return this.fieldParserFor(key, tokenizer);
        }
        return this.fieldFactory().ignoredFieldParser();
    }

    private boolean projectField(String key) {
        if (this.tupleWriter.isProjected(key)) {
            return true;
        }
        return this.loader.listenerColumnMap() != null && this.loader.listenerColumnMap().containsKey(key);
    }

    private ElementParser fieldParserFor(String key, TokenIterator tokenizer) {
        return this.fieldFactory().fieldParser(new FieldDefn(this, key, tokenizer));
    }

    public ElementParser resolveField(String key, TokenIterator tokenizer) {
        return this.replaceFieldParser(key, this.fieldParserFor(key, tokenizer));
    }

    public ElementParser resolveArray(String key, TokenIterator tokenizer) {
        return this.replaceFieldParser(key, this.fieldFactory().fieldParser(new FieldDefn(this, key, tokenizer, true)));
    }

    public void forceNullResolution(String key) {
        this.replaceFieldParser(key, this.fieldFactory().forceNullResolution(new FieldDefn(this, key, null)));
    }

    public void forceEmptyArrayResolution(String key) {
        this.replaceFieldParser(key, this.fieldFactory().forceArrayResolution(new FieldDefn(this, key, null)));
    }
}

