/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.loader;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.MetadataUtils;
import org.apache.drill.exec.record.metadata.VariantColumnMetadata;
import org.apache.drill.exec.store.easy.json.loader.BaseFieldFactory;
import org.apache.drill.exec.store.easy.json.loader.EmptyArrayFieldParser;
import org.apache.drill.exec.store.easy.json.loader.FieldDefn;
import org.apache.drill.exec.store.easy.json.loader.JsonLoaderImpl;
import org.apache.drill.exec.store.easy.json.loader.NullFieldParser;
import org.apache.drill.exec.store.easy.json.parser.ElementParser;
import org.apache.drill.exec.store.easy.json.parser.ValueDef;
import org.apache.drill.exec.store.easy.json.parser.ValueParser;
import org.apache.drill.exec.store.easy.json.values.VarCharListener;
import org.apache.drill.exec.vector.accessor.ScalarWriter;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InferredFieldFactory
extends BaseFieldFactory {
    protected static final Logger logger = LoggerFactory.getLogger(InferredFieldFactory.class);

    public InferredFieldFactory(JsonLoaderImpl loader) {
        super(loader);
    }

    @Override
    public ElementParser fieldParser(FieldDefn fieldDefn) {
        ValueDef valueDef = fieldDefn.lookahead();
        if (valueDef.type().isUnknown()) {
            return this.parserForUnknown(fieldDefn);
        }
        return this.resolveField(fieldDefn);
    }

    private ElementParser parserForUnknown(FieldDefn fieldDefn) {
        ValueDef valueDef = fieldDefn.lookahead();
        if (!valueDef.isArray()) {
            return new NullFieldParser(fieldDefn.tupleParser(), fieldDefn.key());
        }
        if (valueDef.dimensions() > 1) {
            return this.forceRepeatedListResolution(fieldDefn);
        }
        if (valueDef.type() == ValueDef.JsonType.NULL) {
            return this.forceArrayResolution(fieldDefn);
        }
        return new EmptyArrayFieldParser(fieldDefn.tupleParser(), fieldDefn.key());
    }

    private ElementParser forceRepeatedListResolution(FieldDefn fieldDefn) {
        ColumnMetadata innerSchema = this.schemaForUnknown(fieldDefn, true);
        int dims = fieldDefn.lookahead().dimensions();
        ColumnMetadata fieldSchema = this.repeatedListSchemaFor(fieldDefn.key(), dims, innerSchema);
        return this.buildOuterArrays(fieldDefn.fieldWriterFor(fieldSchema), dims, innerWriter -> this.scalarArrayParserFor(this.unknownParserFor(innerWriter.array().scalar())));
    }

    @Override
    public ElementParser forceNullResolution(FieldDefn fieldDefn) {
        logger.warn("Ambiguous type! JSON field {} contains all nulls. Assuming JSON text.", (Object)fieldDefn.key());
        return this.forceResolution(fieldDefn, false);
    }

    @Override
    public ElementParser forceArrayResolution(FieldDefn fieldDefn) {
        logger.warn("Ambiguous type! JSON field {} contains all empty arrays. Assuming array of JSON text.", (Object)fieldDefn.key());
        return this.scalarArrayParserFor(this.forceResolution(fieldDefn, true));
    }

    private ValueParser forceResolution(FieldDefn fieldDefn, boolean isArray) {
        return this.unknownParserFor(fieldDefn.scalarWriterFor(this.schemaForUnknown(fieldDefn, isArray)));
    }

    private ColumnMetadata schemaForUnknown(FieldDefn fieldDefn, boolean isArray) {
        return this.loader.options().unknownsAsJson ? fieldDefn.schemaFor(TypeProtos.MinorType.VARCHAR, isArray, true) : fieldDefn.schemaFor(this.loader.options().nullType, isArray, true);
    }

    private ValueParser unknownParserFor(ScalarWriter writer) {
        return this.loader.options().unknownsAsJson ? this.parserFactory().jsonTextParser(new VarCharListener(this.loader, writer)) : this.parserFactory().simpleValueParser(this.scalarListenerFor(writer));
    }

    private ElementParser resolveField(FieldDefn fieldDefn) {
        ValueDef valueDef = fieldDefn.lookahead();
        Preconditions.checkArgument(!valueDef.type().isUnknown());
        if (!valueDef.isArray()) {
            if (valueDef.type().isObject()) {
                return this.objectParserFor(fieldDefn);
            }
            return this.scalarParserFor(fieldDefn, false);
        }
        if (valueDef.dimensions() == 1) {
            if (valueDef.type().isObject()) {
                return this.objectArrayParserFor(fieldDefn);
            }
            return this.scalarArrayParserFor(this.scalarParserFor(fieldDefn, true));
        }
        if (valueDef.type().isObject()) {
            return this.multiDimObjectArrayParserFor(fieldDefn);
        }
        return this.multiDimScalarArrayParserFor(fieldDefn);
    }

    public ValueParser scalarParserFor(FieldDefn fieldDefn, boolean isArray) {
        if (this.loader.options().allTextMode) {
            return this.parserFactory().textValueParser(new VarCharListener(this.loader, fieldDefn.scalarWriterFor(TypeProtos.MinorType.VARCHAR, isArray)));
        }
        return this.scalarParserFor(fieldDefn, fieldDefn.schemaFor(this.scalarTypeFor(fieldDefn), isArray));
    }

    private ElementParser multiDimScalarArrayParserFor(FieldDefn fieldDefn) {
        ColumnMetadata innerSchema = fieldDefn.schemaFor(this.scalarTypeFor(fieldDefn), true);
        int dims = fieldDefn.lookahead().dimensions();
        ColumnMetadata fieldSchema = this.repeatedListSchemaFor(fieldDefn.key(), dims, innerSchema);
        return this.multiDimScalarArrayFor(fieldDefn.fieldWriterFor(fieldSchema), dims);
    }

    public ElementParser objectArrayParserFor(FieldDefn fieldDefn) {
        return this.objectArrayParserFor(fieldDefn, MetadataUtils.newMapArray(fieldDefn.key()), null);
    }

    private ElementParser multiDimObjectArrayParserFor(FieldDefn fieldDefn) {
        ColumnMetadata innerSchema = MetadataUtils.newMapArray(fieldDefn.key());
        int dims = fieldDefn.lookahead().dimensions();
        ColumnMetadata fieldSchema = this.repeatedListSchemaFor(fieldDefn.key(), dims, innerSchema);
        return this.multiDimObjectArrayFor(fieldDefn.fieldWriterFor(fieldSchema), dims, null);
    }

    private ElementParser repeatedListOfVariantListenerFor(FieldDefn fieldDefn) {
        VariantColumnMetadata innerSchema = MetadataUtils.newVariant(fieldDefn.key(), TypeProtos.DataMode.REPEATED);
        int dims = fieldDefn.lookahead().dimensions();
        ColumnMetadata fieldSchema = this.repeatedListSchemaFor(fieldDefn.key(), dims, innerSchema);
        return this.multiDimVariantArrayParserFor(fieldDefn.fieldWriterFor(fieldSchema), dims);
    }

    private TypeProtos.MinorType scalarTypeFor(FieldDefn fieldDefn) {
        TypeProtos.MinorType colType = this.drillTypeFor(fieldDefn.lookahead().type());
        if (colType == null) {
            throw this.loader().unsupportedJsonTypeException(fieldDefn.key(), fieldDefn.lookahead().type());
        }
        return colType;
    }

    public TypeProtos.MinorType drillTypeFor(ValueDef.JsonType type) {
        if (this.loader().options().allTextMode) {
            return TypeProtos.MinorType.VARCHAR;
        }
        switch (type) {
            case BOOLEAN: {
                return TypeProtos.MinorType.BIT;
            }
            case FLOAT: {
                return TypeProtos.MinorType.FLOAT8;
            }
            case INTEGER: {
                if (this.loader().options().readNumbersAsDouble) {
                    return TypeProtos.MinorType.FLOAT8;
                }
                return TypeProtos.MinorType.BIGINT;
            }
            case STRING: {
                return TypeProtos.MinorType.VARCHAR;
            }
        }
        throw new IllegalStateException(type.name());
    }
}

