/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.loader;

import java.io.InputStream;
import java.util.Iterator;
import org.apache.drill.common.AutoCloseables;

public class ClosingStreamIterator
implements Iterator<InputStream> {
    private InputStream value;
    private InputStream last;

    @Override
    public boolean hasNext() {
        if (this.value == null) {
            AutoCloseables.closeSilently(this.last);
            return false;
        }
        return true;
    }

    @Override
    public InputStream next() {
        this.last = this.value;
        this.value = null;
        return this.last;
    }

    public void setValue(InputStream value) {
        AutoCloseables.closeSilently(this.value);
        this.value = value;
    }
}

