/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.extended;

import com.fasterxml.jackson.core.JsonToken;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.MetadataUtils;
import org.apache.drill.exec.store.easy.json.extended.BaseExtendedValueParser;
import org.apache.drill.exec.store.easy.json.extended.MongoBinaryValueParser;
import org.apache.drill.exec.store.easy.json.extended.MongoDateValueParser;
import org.apache.drill.exec.store.easy.json.extended.SimpleExtendedValueParser;
import org.apache.drill.exec.store.easy.json.loader.BaseFieldFactory;
import org.apache.drill.exec.store.easy.json.loader.FieldDefn;
import org.apache.drill.exec.store.easy.json.loader.FieldFactory;
import org.apache.drill.exec.store.easy.json.loader.JsonLoaderImpl;
import org.apache.drill.exec.store.easy.json.parser.ElementParser;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;
import org.apache.drill.exec.store.easy.json.parser.ValueParser;
import org.apache.drill.exec.store.easy.json.values.BinaryValueListener;
import org.apache.drill.exec.store.easy.json.values.DecimalValueListener;
import org.apache.drill.exec.store.easy.json.values.IntervalValueListener;
import org.apache.drill.exec.store.easy.json.values.StrictBigIntValueListener;
import org.apache.drill.exec.store.easy.json.values.StrictDoubleValueListener;
import org.apache.drill.exec.store.easy.json.values.StrictIntValueListener;
import org.apache.drill.exec.store.easy.json.values.StrictStringValueListener;
import org.apache.drill.exec.store.easy.json.values.TimeValueListener;
import org.apache.drill.exec.store.easy.json.values.UtcDateValueListener;
import org.apache.drill.exec.store.easy.json.values.UtcTimestampValueListener;

public class ExtendedTypeFieldFactory
extends BaseFieldFactory {
    public ExtendedTypeFieldFactory(JsonLoaderImpl loader, FieldFactory child) {
        super(loader, child);
    }

    @Override
    public ElementParser fieldParser(FieldDefn fieldDefn) {
        ElementParser parser = this.buildExtendedTypeParser(fieldDefn);
        if (parser == null) {
            return this.child.fieldParser(fieldDefn);
        }
        return parser;
    }

    private ElementParser buildExtendedTypeParser(FieldDefn fieldDefn) {
        ElementParser parser;
        TokenIterator tokenizer = fieldDefn.tokenizer();
        JsonToken token = tokenizer.requireNext();
        switch (token) {
            case START_OBJECT: {
                parser = this.extendedTypeParserFor(fieldDefn, false);
                break;
            }
            case START_ARRAY: {
                parser = this.arrayParserFor(fieldDefn);
                break;
            }
            default: {
                parser = null;
            }
        }
        tokenizer.unget(token);
        return parser;
    }

    private ElementParser arrayParserFor(FieldDefn fieldDefn) {
        TokenIterator tokenizer = fieldDefn.tokenizer();
        JsonToken token = tokenizer.requireNext();
        if (token != JsonToken.START_OBJECT) {
            tokenizer.unget(token);
            return null;
        }
        BaseExtendedValueParser element = this.extendedTypeParserFor(fieldDefn, true);
        tokenizer.unget(token);
        if (element == null) {
            return null;
        }
        return this.scalarArrayParserFor(element);
    }

    private BaseExtendedValueParser extendedTypeParserFor(FieldDefn fieldDefn, boolean isArray) {
        TokenIterator tokenizer = fieldDefn.tokenizer();
        JsonToken token = tokenizer.peek();
        if (token != JsonToken.FIELD_NAME) {
            return null;
        }
        String key = tokenizer.textValue().trim();
        if (!key.startsWith("$")) {
            return null;
        }
        return this.parserFor(fieldDefn, key, isArray);
    }

    private BaseExtendedValueParser parserFor(FieldDefn fieldDefn, String key, boolean isArray) {
        switch (key) {
            case "$numberLong": {
                return this.numberLongParser(fieldDefn, isArray);
            }
            case "$numberDecimal": {
                return this.numberDecimalParser(fieldDefn, isArray);
            }
            case "$numberDouble": {
                return this.numberDoubleParser(fieldDefn, isArray);
            }
            case "$numberInt": {
                return this.numberIntParser(fieldDefn, isArray);
            }
            case "$date": {
                return this.dateParser(fieldDefn, isArray);
            }
            case "$binary": 
            case "$type": {
                return this.binaryParser(fieldDefn, isArray);
            }
            case "$oid": {
                return this.oidParser(fieldDefn, isArray);
            }
            case "$dateDay": {
                return this.dateDayParser(fieldDefn, isArray);
            }
            case "$time": {
                return this.timeParser(fieldDefn, isArray);
            }
            case "$interval": {
                return this.intervalParser(fieldDefn, isArray);
            }
        }
        return null;
    }

    @Override
    public ValueParser scalarParserFor(FieldDefn fieldDefn, ColumnMetadata colSchema) {
        switch (colSchema.type()) {
            case BIGINT: 
            case UINT8: {
                return this.numberLongParser(fieldDefn, colSchema);
            }
            case DATE: {
                return this.dateDayParser(fieldDefn, colSchema);
            }
            case FLOAT4: 
            case FLOAT8: {
                return this.numberDoubleParser(fieldDefn, colSchema);
            }
            case INT: 
            case SMALLINT: 
            case UINT2: 
            case UINT4: {
                return this.numberIntParser(fieldDefn, colSchema);
            }
            case INTERVAL: 
            case INTERVALDAY: 
            case INTERVALYEAR: {
                return this.intervalParser(fieldDefn, colSchema);
            }
            case TIME: {
                return this.timeParser(fieldDefn, colSchema);
            }
            case TIMESTAMP: {
                return this.dateParser(fieldDefn, colSchema);
            }
            case VARBINARY: {
                return this.binaryParser(fieldDefn, colSchema);
            }
            case VARDECIMAL: {
                return this.numberDecimalParser(fieldDefn, colSchema);
            }
        }
        return this.child.scalarParserFor(fieldDefn, colSchema);
    }

    private BaseExtendedValueParser numberLongParser(FieldDefn fieldDefn, boolean isArray) {
        return this.numberLongParser(fieldDefn, fieldDefn.schemaFor(TypeProtos.MinorType.BIGINT, isArray));
    }

    private BaseExtendedValueParser numberLongParser(FieldDefn fieldDefn, ColumnMetadata colSchema) {
        return new SimpleExtendedValueParser(fieldDefn.parser(), "$numberLong", new StrictBigIntValueListener(this.loader(), fieldDefn.scalarWriterFor(colSchema)));
    }

    private BaseExtendedValueParser numberDecimalParser(FieldDefn fieldDefn, boolean isArray) {
        return this.numberDecimalParser(fieldDefn, MetadataUtils.newDecimal(fieldDefn.key(), fieldDefn.mode(isArray), 38, 10));
    }

    private BaseExtendedValueParser numberDecimalParser(FieldDefn fieldDefn, ColumnMetadata colSchema) {
        return new SimpleExtendedValueParser(fieldDefn.parser(), "$numberDecimal", new DecimalValueListener(this.loader(), fieldDefn.scalarWriterFor(colSchema)));
    }

    private BaseExtendedValueParser numberDoubleParser(FieldDefn fieldDefn, boolean isArray) {
        return this.numberDoubleParser(fieldDefn, fieldDefn.schemaFor(TypeProtos.MinorType.FLOAT8, isArray));
    }

    private BaseExtendedValueParser numberDoubleParser(FieldDefn fieldDefn, ColumnMetadata colSchema) {
        return new SimpleExtendedValueParser(fieldDefn.parser(), "$numberDouble", new StrictDoubleValueListener(this.loader(), fieldDefn.scalarWriterFor(colSchema)));
    }

    private BaseExtendedValueParser numberIntParser(FieldDefn fieldDefn, boolean isArray) {
        return this.numberIntParser(fieldDefn, fieldDefn.schemaFor(TypeProtos.MinorType.INT, isArray));
    }

    private BaseExtendedValueParser numberIntParser(FieldDefn fieldDefn, ColumnMetadata colSchema) {
        return new SimpleExtendedValueParser(fieldDefn.parser(), "$numberInt", new StrictIntValueListener(this.loader(), fieldDefn.scalarWriterFor(colSchema)));
    }

    private BaseExtendedValueParser dateParser(FieldDefn fieldDefn, boolean isArray) {
        return this.dateParser(fieldDefn, fieldDefn.schemaFor(TypeProtos.MinorType.TIMESTAMP, isArray));
    }

    private BaseExtendedValueParser dateParser(FieldDefn fieldDefn, ColumnMetadata colSchema) {
        return new MongoDateValueParser(fieldDefn.parser(), new UtcTimestampValueListener(this.loader(), fieldDefn.scalarWriterFor(colSchema)));
    }

    private BaseExtendedValueParser binaryParser(FieldDefn fieldDefn, boolean isArray) {
        return this.binaryParser(fieldDefn, fieldDefn.schemaFor(TypeProtos.MinorType.VARBINARY, isArray));
    }

    private BaseExtendedValueParser binaryParser(FieldDefn fieldDefn, ColumnMetadata colSchema) {
        return new MongoBinaryValueParser(fieldDefn.parser(), new BinaryValueListener(this.loader(), fieldDefn.scalarWriterFor(colSchema)));
    }

    private BaseExtendedValueParser dateDayParser(FieldDefn fieldDefn, boolean isArray) {
        return this.dateDayParser(fieldDefn, fieldDefn.schemaFor(TypeProtos.MinorType.DATE, isArray));
    }

    private BaseExtendedValueParser dateDayParser(FieldDefn fieldDefn, ColumnMetadata colSchema) {
        return new SimpleExtendedValueParser(fieldDefn.parser(), "$dateDay", new UtcDateValueListener(this.loader(), fieldDefn.scalarWriterFor(colSchema)));
    }

    private BaseExtendedValueParser timeParser(FieldDefn fieldDefn, boolean isArray) {
        return this.timeParser(fieldDefn, fieldDefn.schemaFor(TypeProtos.MinorType.TIME, isArray));
    }

    private BaseExtendedValueParser timeParser(FieldDefn fieldDefn, ColumnMetadata colSchema) {
        return new SimpleExtendedValueParser(fieldDefn.parser(), "$time", new TimeValueListener(this.loader(), fieldDefn.scalarWriterFor(colSchema)));
    }

    private BaseExtendedValueParser intervalParser(FieldDefn fieldDefn, boolean isArray) {
        return this.intervalParser(fieldDefn, fieldDefn.schemaFor(TypeProtos.MinorType.INTERVAL, isArray));
    }

    private BaseExtendedValueParser intervalParser(FieldDefn fieldDefn, ColumnMetadata colSchema) {
        return new SimpleExtendedValueParser(fieldDefn.parser(), "$interval", new IntervalValueListener(this.loader(), fieldDefn.scalarWriterFor(colSchema)));
    }

    private BaseExtendedValueParser oidParser(FieldDefn fieldDefn, boolean isArray) {
        return new SimpleExtendedValueParser(fieldDefn.parser(), "$oid", new StrictStringValueListener(this.loader(), fieldDefn.scalarWriterFor(TypeProtos.MinorType.VARCHAR, isArray)));
    }
}

