/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Objects;
import org.apache.drill.common.PlanStringBuilder;
import org.apache.drill.exec.server.options.OptionSet;
import org.apache.drill.exec.store.easy.json.loader.JsonLoaderOptions;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonDeserialize(builder=JsonConfigOptionsBuilder.class)
public class JsonConfigOptions {
    @JsonProperty
    protected final Boolean allowNanInf;
    @JsonProperty
    protected final Boolean allTextMode;
    @JsonProperty
    protected final Boolean readNumbersAsDouble;
    @JsonProperty
    protected final Boolean enableEscapeAnyChar;
    @JsonProperty
    protected final Boolean skipMalformedRecords;
    @JsonProperty
    protected final Boolean skipMalformedDocument;

    public JsonConfigOptions(Boolean allowNanInf, Boolean allTextMode, Boolean readNumbersAsDouble, Boolean enableEscapeAnyChar, Boolean skipMalformedDocument, Boolean skipMalformedRecords) {
        this.allowNanInf = allowNanInf;
        this.allTextMode = allTextMode;
        this.readNumbersAsDouble = readNumbersAsDouble;
        this.enableEscapeAnyChar = enableEscapeAnyChar;
        this.skipMalformedDocument = skipMalformedDocument;
        this.skipMalformedRecords = skipMalformedRecords;
    }

    JsonConfigOptions(JsonConfigOptionsBuilder builder) {
        this.allowNanInf = builder.allowNanInf;
        this.allTextMode = builder.allTextMode;
        this.readNumbersAsDouble = builder.readNumbersAsDouble;
        this.enableEscapeAnyChar = builder.enableEscapeAnyChar;
        this.skipMalformedRecords = builder.skipMalformedRecords;
        this.skipMalformedDocument = builder.skipMalformedDocument;
    }

    public static JsonConfigOptionsBuilder builder() {
        return new JsonConfigOptionsBuilder();
    }

    @JsonIgnore
    public JsonLoaderOptions getJsonOptions(OptionSet optionSet) {
        JsonLoaderOptions options = new JsonLoaderOptions(optionSet);
        if (this.allowNanInf != null) {
            options.allowNanInf = this.allowNanInf;
        }
        if (this.allTextMode != null) {
            options.allTextMode = this.allTextMode;
        }
        if (this.readNumbersAsDouble != null) {
            options.readNumbersAsDouble = this.readNumbersAsDouble;
        }
        if (this.enableEscapeAnyChar != null) {
            options.enableEscapeAnyChar = this.enableEscapeAnyChar;
        }
        if (this.skipMalformedRecords != null) {
            options.skipMalformedRecords = this.skipMalformedRecords;
        }
        if (this.skipMalformedDocument != null) {
            options.skipMalformedDocument = this.skipMalformedDocument;
        }
        return options;
    }

    @JsonProperty(value="allowNanInf")
    public Boolean allowNanInf() {
        return this.allowNanInf;
    }

    @JsonProperty(value="allTextMode")
    public Boolean allTextMode() {
        return this.allTextMode;
    }

    @JsonProperty(value="readNumbersAsDouble")
    public Boolean readNumbersAsDouble() {
        return this.readNumbersAsDouble;
    }

    @JsonProperty(value="enableEscapeAnyChar")
    public Boolean enableEscapeAnyChar() {
        return this.enableEscapeAnyChar;
    }

    @JsonProperty(value="skipMalformedRecords")
    public Boolean skipMalformedRecords() {
        return this.skipMalformedRecords;
    }

    @JsonProperty(value="skipMalformedDocument")
    public Boolean skipMalformedDocument() {
        return this.skipMalformedDocument;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonConfigOptions that = (JsonConfigOptions)o;
        return Objects.equals(this.allowNanInf, that.allowNanInf) && Objects.equals(this.allTextMode, that.allTextMode) && Objects.equals(this.readNumbersAsDouble, that.readNumbersAsDouble) && Objects.equals(this.enableEscapeAnyChar, that.enableEscapeAnyChar) && Objects.equals(this.skipMalformedDocument, that.skipMalformedDocument) && Objects.equals(this.skipMalformedRecords, that.skipMalformedRecords);
    }

    public int hashCode() {
        return Objects.hash(this.allowNanInf, this.allTextMode, this.readNumbersAsDouble, this.enableEscapeAnyChar, this.skipMalformedDocument, this.skipMalformedRecords);
    }

    public String toString() {
        return new PlanStringBuilder(this).field("allowNanInf", this.allowNanInf).field("allTextMode", this.allTextMode).field("readNumbersAsDouble", this.readNumbersAsDouble).field("enableEscapeAnyChar", this.enableEscapeAnyChar).field("skipMalformedRecords", this.skipMalformedRecords).field("skipMalformedDocument", this.skipMalformedDocument).toString();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class JsonConfigOptionsBuilder {
        public Boolean allowNanInf;
        public Boolean allTextMode;
        public Boolean readNumbersAsDouble;
        public Boolean enableEscapeAnyChar;
        public Boolean skipMalformedRecords;
        public Boolean skipMalformedDocument;

        public JsonConfigOptionsBuilder allowNanInf(Boolean allowNanInf) {
            this.allowNanInf = allowNanInf;
            return this;
        }

        public JsonConfigOptionsBuilder allTextMode(Boolean allTextMode) {
            this.allTextMode = allTextMode;
            return this;
        }

        public JsonConfigOptionsBuilder readNumbersAsDouble(Boolean readNumbersAsDouble) {
            this.readNumbersAsDouble = readNumbersAsDouble;
            return this;
        }

        public JsonConfigOptionsBuilder enableEscapeAnyChar(Boolean enableEscapeAnyChar) {
            this.enableEscapeAnyChar = enableEscapeAnyChar;
            return this;
        }

        public JsonConfigOptionsBuilder skipMalformedRecords(Boolean skipMalformedRecords) {
            this.skipMalformedRecords = skipMalformedRecords;
            return this;
        }

        public JsonConfigOptionsBuilder skipMalformedDocument(Boolean skipMalformedDocument) {
            this.skipMalformedDocument = skipMalformedDocument;
            return this;
        }

        public JsonConfigOptions build() {
            return new JsonConfigOptions(this);
        }
    }
}

