/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json;

import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.planner.common.DrillStatsTable;
import org.apache.drill.exec.store.EventBasedRecordWriter;
import org.apache.drill.exec.store.JSONBaseStatisticsRecordWriter;
import org.apache.drill.exec.vector.complex.reader.FieldReader;

public class StatisticsCollectorImpl
extends JSONBaseStatisticsRecordWriter {
    private final List<DrillStatsTable.ColumnStatistics> columnStatisticsList = new ArrayList<DrillStatsTable.ColumnStatistics>();
    private String nextField = null;
    private DrillStatsTable.ColumnStatistics columnStatistics;
    private LocalDate dirComputedTime = null;
    private boolean errStatus = false;

    @Override
    public void startStatisticsRecord() {
        this.columnStatistics = new DrillStatsTable.ColumnStatistics_v1();
    }

    @Override
    public void endStatisticsRecord() {
        this.columnStatisticsList.add(this.columnStatistics);
    }

    @Override
    public boolean hasStatistics() {
        return !this.columnStatisticsList.isEmpty();
    }

    @Override
    public DrillStatsTable.TableStatistics getStatistics() {
        return DrillStatsTable.generateDirectoryStructure(this.dirComputedTime.toString(), this.columnStatisticsList);
    }

    public boolean hasErrors() {
        return this.errStatus;
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewBigIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new BigIntJsonConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new IntJsonConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewDateConverter(int fieldId, String fieldName, FieldReader reader) {
        return new DateJsonConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewVarCharConverter(int fieldId, String fieldName, FieldReader reader) {
        return new VarCharJsonConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableBigIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableBigIntJsonConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableVarBinaryConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableVarBinaryJsonConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableFloat8Converter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableFloat8JsonConverter(fieldId, fieldName, reader);
    }

    public class BigIntJsonConverter
    extends EventBasedRecordWriter.FieldConverter {
        public BigIntJsonConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
        }

        @Override
        public void startField() throws IOException {
            switch (this.fieldName) {
                case "schema": 
                case "rowcount": 
                case "nonnullrowcount": 
                case "approx_count_distinct": 
                case "avg_width": 
                case "sum": {
                    StatisticsCollectorImpl.this.nextField = this.fieldName;
                }
            }
        }

        @Override
        public void writeField() throws IOException {
            if (StatisticsCollectorImpl.this.nextField == null) {
                StatisticsCollectorImpl.this.errStatus = true;
                throw new IOException("Statistics writer encountered unexpected field");
            }
            DrillStatsTable.ColumnStatistics_v1 columnStatistics = (DrillStatsTable.ColumnStatistics_v1)StatisticsCollectorImpl.this.columnStatistics;
            switch (StatisticsCollectorImpl.this.nextField) {
                case "schema": {
                    columnStatistics.setSchema(this.reader.readLong());
                    break;
                }
                case "rowcount": {
                    columnStatistics.setCount(this.reader.readLong());
                    break;
                }
                case "nonnullrowcount": {
                    columnStatistics.setNonNullCount(this.reader.readLong());
                    break;
                }
                case "approx_count_distinct": {
                    columnStatistics.setNdv(this.reader.readLong());
                    break;
                }
                case "avg_width": {
                    columnStatistics.setAvgWidth(this.reader.readLong().longValue());
                    break;
                }
            }
        }

        @Override
        public void endField() {
            StatisticsCollectorImpl.this.nextField = null;
        }
    }

    public class IntJsonConverter
    extends EventBasedRecordWriter.FieldConverter {
        public IntJsonConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
        }

        @Override
        public void startField() throws IOException {
            if (this.fieldName.equals("majortype")) {
                StatisticsCollectorImpl.this.nextField = this.fieldName;
            }
        }

        @Override
        public void writeField() throws IOException {
            if (StatisticsCollectorImpl.this.nextField == null) {
                StatisticsCollectorImpl.this.errStatus = true;
                throw new IOException("Statistics writer encountered unexpected field");
            }
            if (StatisticsCollectorImpl.this.nextField.equals("majortype")) {
                // empty if block
            }
        }

        @Override
        public void endField() {
            StatisticsCollectorImpl.this.nextField = null;
        }
    }

    public class DateJsonConverter
    extends EventBasedRecordWriter.FieldConverter {
        public DateJsonConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
        }

        @Override
        public void startField() throws IOException {
            if (this.fieldName.equals("computed")) {
                StatisticsCollectorImpl.this.nextField = this.fieldName;
            }
        }

        @Override
        public void writeField() throws IOException {
            if (StatisticsCollectorImpl.this.nextField == null) {
                StatisticsCollectorImpl.this.errStatus = true;
                throw new IOException("Statistics writer encountered unexpected field");
            }
            if (StatisticsCollectorImpl.this.nextField.equals("computed")) {
                LocalDate computedTime = this.reader.readLocalDate();
                if (StatisticsCollectorImpl.this.dirComputedTime == null || computedTime.compareTo(StatisticsCollectorImpl.this.dirComputedTime) > 0) {
                    StatisticsCollectorImpl.this.dirComputedTime = computedTime;
                }
            }
        }

        @Override
        public void endField() {
            StatisticsCollectorImpl.this.nextField = null;
        }
    }

    public class VarCharJsonConverter
    extends EventBasedRecordWriter.FieldConverter {
        public VarCharJsonConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
        }

        @Override
        public void startField() throws IOException {
            switch (this.fieldName) {
                case "column": 
                case "majortype": {
                    StatisticsCollectorImpl.this.nextField = this.fieldName;
                }
            }
        }

        @Override
        public void writeField() throws IOException {
            if (StatisticsCollectorImpl.this.nextField == null) {
                StatisticsCollectorImpl.this.errStatus = true;
                throw new IOException("Statistics writer encountered unexpected field");
            }
            switch (StatisticsCollectorImpl.this.nextField) {
                case "column": {
                    ((DrillStatsTable.ColumnStatistics_v1)StatisticsCollectorImpl.this.columnStatistics).setName(SchemaPath.parseFromString(this.reader.readText().toString()));
                    break;
                }
                case "majortype": {
                    TypeProtos.MajorType fieldType = (TypeProtos.MajorType)DrillStatsTable.getMapper().readValue(this.reader.readText().toString(), TypeProtos.MajorType.class);
                    ((DrillStatsTable.ColumnStatistics_v1)StatisticsCollectorImpl.this.columnStatistics).setType(fieldType);
                }
            }
        }

        @Override
        public void endField() {
            StatisticsCollectorImpl.this.nextField = null;
        }
    }

    public class NullableBigIntJsonConverter
    extends EventBasedRecordWriter.FieldConverter {
        public NullableBigIntJsonConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
        }

        @Override
        public void startField() throws IOException {
            if (!StatisticsCollectorImpl.this.skipNullFields || this.reader.isSet()) {
                switch (this.fieldName) {
                    case "rowcount": 
                    case "nonnullrowcount": 
                    case "approx_count_distinct": 
                    case "sum": {
                        StatisticsCollectorImpl.this.nextField = this.fieldName;
                    }
                }
            }
        }

        @Override
        public void writeField() throws IOException {
            if (!StatisticsCollectorImpl.this.skipNullFields || this.reader.isSet()) {
                if (StatisticsCollectorImpl.this.nextField == null) {
                    StatisticsCollectorImpl.this.errStatus = true;
                    throw new IOException("Statistics writer encountered unexpected field");
                }
                switch (StatisticsCollectorImpl.this.nextField) {
                    case "rowcount": {
                        ((DrillStatsTable.ColumnStatistics_v1)StatisticsCollectorImpl.this.columnStatistics).setCount(this.reader.readLong());
                        break;
                    }
                    case "nonnullrowcount": {
                        ((DrillStatsTable.ColumnStatistics_v1)StatisticsCollectorImpl.this.columnStatistics).setNonNullCount(this.reader.readLong());
                        break;
                    }
                    case "approx_count_distinct": {
                        ((DrillStatsTable.ColumnStatistics_v1)StatisticsCollectorImpl.this.columnStatistics).setNdv(this.reader.readLong());
                        break;
                    }
                }
            }
        }

        @Override
        public void endField() {
            StatisticsCollectorImpl.this.nextField = null;
        }
    }

    public class NullableVarBinaryJsonConverter
    extends EventBasedRecordWriter.FieldConverter {
        public NullableVarBinaryJsonConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
        }

        @Override
        public void startField() throws IOException {
            if (!StatisticsCollectorImpl.this.skipNullFields || this.reader.isSet()) {
                switch (this.fieldName) {
                    case "hll": 
                    case "hll_merge": 
                    case "tdigest_merge": {
                        StatisticsCollectorImpl.this.nextField = this.fieldName;
                    }
                }
            }
        }

        @Override
        public void writeField() throws IOException {
            if (!StatisticsCollectorImpl.this.skipNullFields || this.reader.isSet()) {
                if (StatisticsCollectorImpl.this.nextField == null) {
                    StatisticsCollectorImpl.this.errStatus = true;
                    throw new IOException("Statistics writer encountered unexpected field");
                }
                switch (StatisticsCollectorImpl.this.nextField) {
                    case "hll": 
                    case "hll_merge": {
                        break;
                    }
                    case "tdigest_merge": {
                        byte[] tdigest_bytearray = this.reader.readByteArray();
                        ((DrillStatsTable.ColumnStatistics_v1)StatisticsCollectorImpl.this.columnStatistics).buildHistogram(tdigest_bytearray);
                    }
                }
            }
        }

        @Override
        public void endField() {
            StatisticsCollectorImpl.this.nextField = null;
        }
    }

    public class NullableFloat8JsonConverter
    extends EventBasedRecordWriter.FieldConverter {
        public NullableFloat8JsonConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
        }

        @Override
        public void startField() throws IOException {
            if ((!StatisticsCollectorImpl.this.skipNullFields || this.reader.isSet()) && this.fieldName.equals("avg_width")) {
                StatisticsCollectorImpl.this.nextField = this.fieldName;
            }
        }

        @Override
        public void writeField() throws IOException {
            if (!StatisticsCollectorImpl.this.skipNullFields || this.reader.isSet()) {
                if (StatisticsCollectorImpl.this.nextField == null) {
                    StatisticsCollectorImpl.this.errStatus = true;
                    throw new IOException("Statistics writer encountered unexpected field");
                }
                if (StatisticsCollectorImpl.this.nextField.equals("avg_width")) {
                    ((DrillStatsTable.ColumnStatistics_v1)StatisticsCollectorImpl.this.columnStatistics).setAvgWidth(this.reader.readDouble());
                }
            }
        }

        @Override
        public void endField() {
            StatisticsCollectorImpl.this.nextField = null;
        }
    }
}

