/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json;

import java.io.IOException;
import java.util.Map;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.planner.common.DrillStatsTable;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.store.EventBasedRecordWriter;
import org.apache.drill.exec.store.JSONBaseStatisticsRecordWriter;
import org.apache.drill.exec.store.StatisticsRecordWriter;
import org.apache.drill.exec.store.dfs.FormatPlugin;
import org.apache.drill.exec.store.easy.json.StatisticsCollectorImpl;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonStatisticsRecordWriter
extends JSONBaseStatisticsRecordWriter
implements StatisticsRecordWriter {
    private static final Logger logger = LoggerFactory.getLogger(JsonStatisticsRecordWriter.class);
    private String location;
    private String prefix;
    private String extension;
    private FileSystem fs = null;
    private final Configuration fsConf;
    private final FormatPlugin formatPlugin;
    private Path fileName = null;
    private long recordsWritten = -1L;
    private final StatisticsCollectorImpl statisticsCollector = new StatisticsCollectorImpl();

    public JsonStatisticsRecordWriter(Configuration fsConf, FormatPlugin formatPlugin) {
        this.fsConf = fsConf;
        this.formatPlugin = formatPlugin;
    }

    @Override
    public void init(Map<String, String> writerOptions) {
        this.location = writerOptions.get("location");
        this.prefix = writerOptions.get("prefix");
        this.extension = writerOptions.get("extension");
        this.skipNullFields = Boolean.parseBoolean(writerOptions.get("skipnulls"));
        String queryId = writerOptions.get("queryid");
        this.fs = ImpersonationUtil.createFileSystem(ImpersonationUtil.getProcessUserName(), this.fsConf);
        this.fileName = new Path(this.location, this.prefix + "." + this.extension + ".tmp." + queryId);
        try {
            if (this.fs.exists(this.fileName)) {
                this.fs.delete(this.fileName, false);
            }
        }
        catch (IOException ex) {
            throw UserException.dataWriteError(ex).addContext(String.format("Unable to delete tmp statistics file %s", this.fileName)).build(logger);
        }
        try {
            this.fs.deleteOnExit(this.fileName);
            this.fs.deleteOnExit(new Path(this.location));
            logger.debug("Created file: {}", (Object)this.fileName);
        }
        catch (IOException ex) {
            throw UserException.dataWriteError(ex).addContext(String.format("Unable to create stistics file %s", this.fileName)).build(logger);
        }
    }

    @Override
    public void updateSchema(VectorAccessible batch) {
    }

    @Override
    public boolean isBlockingWriter() {
        return true;
    }

    @Override
    public void checkForNewPartition(int index) {
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewBigIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return this.statisticsCollector.getNewBigIntConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return this.statisticsCollector.getNewIntConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewDateConverter(int fieldId, String fieldName, FieldReader reader) {
        return this.statisticsCollector.getNewDateConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewVarCharConverter(int fieldId, String fieldName, FieldReader reader) {
        return this.statisticsCollector.getNewVarCharConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableBigIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return this.statisticsCollector.getNewNullableBigIntConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableVarBinaryConverter(int fieldId, String fieldName, FieldReader reader) {
        return this.statisticsCollector.getNewNullableVarBinaryConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableFloat8Converter(int fieldId, String fieldName, FieldReader reader) {
        return this.statisticsCollector.getNewNullableFloat8Converter(fieldId, fieldName, reader);
    }

    @Override
    public void startStatisticsRecord() {
        this.statisticsCollector.startStatisticsRecord();
    }

    @Override
    public void endStatisticsRecord() {
        this.statisticsCollector.endStatisticsRecord();
        ++this.recordsWritten;
    }

    @Override
    public boolean hasStatistics() {
        return this.recordsWritten > 0L;
    }

    @Override
    public DrillStatsTable.TableStatistics getStatistics() {
        return this.statisticsCollector.getStatistics();
    }

    @Override
    public void flushBlockingWriter() throws IOException {
        Path permFileName = new Path(this.location, this.prefix + "." + this.extension);
        try {
            if (this.statisticsCollector.hasErrors()) {
                throw new IOException("Statistics writer encountered unexpected field");
            }
            if (this.recordsWritten < 0L) {
                throw new IOException("Statistics writer did not have data");
            }
            if (this.formatPlugin.supportsStatistics()) {
                this.formatPlugin.writeStatistics(this.statisticsCollector.getStatistics(), this.fs, this.fileName);
                this.fs.delete(permFileName, false);
                this.fs.rename(this.fileName, permFileName);
                this.fs.cancelDeleteOnExit(this.fileName);
                this.fs.cancelDeleteOnExit(new Path(this.location));
            }
            logger.debug("Created file: {}", (Object)permFileName);
        }
        catch (IOException ex) {
            logger.error("Unable to create file: " + permFileName, (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public void abort() {
        this.cleanup();
    }

    @Override
    public void cleanup() {
        Path permFileName = new Path(this.location, this.prefix + "." + this.extension);
        try {
            if (this.fs.exists(this.fileName)) {
                this.fs.delete(this.fileName, false);
                logger.debug("Deleted file: {}", (Object)this.fileName);
            }
            if (!this.fs.exists(permFileName)) {
                this.fs.delete(new Path(this.location), false);
                logger.debug("Deleted directory: {}", (Object)this.location);
            }
        }
        catch (IOException ex) {
            logger.warn("Unable to delete tmp satistics file: " + this.fileName, (Throwable)ex);
        }
    }
}

