/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.store.EventBasedRecordWriter;
import org.apache.drill.exec.store.JSONOutputRecordWriter;
import org.apache.drill.exec.store.RecordWriter;
import org.apache.drill.exec.store.StorageStrategy;
import org.apache.drill.exec.vector.complex.fn.BasicJsonOutput;
import org.apache.drill.exec.vector.complex.fn.ExtendedJsonOutput;
import org.apache.drill.exec.vector.complex.fn.JsonWriter;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRecordWriter
extends JSONOutputRecordWriter
implements RecordWriter {
    private static final Logger logger = LoggerFactory.getLogger(JsonRecordWriter.class);
    private static final String LINE_FEED = String.format("%n", new Object[0]);
    private Path cleanUpLocation;
    private String location;
    private String prefix;
    private String extension;
    private boolean useExtendedOutput;
    private int index;
    private FileSystem fs;
    private OutputStream stream;
    private final JsonFactory factory = new JsonFactory();
    private final StorageStrategy storageStrategy;
    private final Configuration fsConf;

    public JsonRecordWriter(StorageStrategy storageStrategy, Configuration fsConf) {
        this.storageStrategy = storageStrategy == null ? StorageStrategy.DEFAULT : storageStrategy;
        this.fsConf = new Configuration(fsConf);
    }

    @Override
    public void init(Map<String, String> writerOptions) throws IOException {
        this.location = writerOptions.get("location");
        this.prefix = writerOptions.get("prefix");
        this.extension = writerOptions.get("extension");
        this.useExtendedOutput = Boolean.parseBoolean(writerOptions.get("extended"));
        this.skipNullFields = Boolean.parseBoolean(writerOptions.get("skipnulls"));
        boolean uglify = Boolean.parseBoolean(writerOptions.get("uglify"));
        this.fs = FileSystem.get((Configuration)this.fsConf);
        Path fileName = new Path(this.location, this.prefix + "_" + this.index + "." + this.extension);
        try {
            this.cleanUpLocation = this.storageStrategy.createFileAndApply(this.fs, fileName);
            this.stream = this.fs.create(fileName);
            this.storageStrategy.applyToFile(this.fs, fileName);
            JsonGenerator generator = this.factory.createGenerator(this.stream).useDefaultPrettyPrinter().configure(JsonGenerator.Feature.QUOTE_NON_NUMERIC_NUMBERS, !Boolean.parseBoolean(writerOptions.get("enableNanInf")));
            if (uglify) {
                generator = generator.setPrettyPrinter((PrettyPrinter)new MinimalPrettyPrinter(LINE_FEED));
            }
            this.gen = this.useExtendedOutput ? new ExtendedJsonOutput(generator) : new BasicJsonOutput(generator);
            logger.debug("Created file: {}", (Object)fileName);
        }
        catch (IOException ex) {
            logger.error("Unable to create file: " + fileName, (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public void updateSchema(VectorAccessible batch) throws IOException {
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewMapConverter(int fieldId, String fieldName, FieldReader reader) {
        return new MapJsonConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewUnionConverter(int fieldId, String fieldName, FieldReader reader) {
        return new UnionJsonConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedMapConverter(int fieldId, String fieldName, FieldReader reader) {
        return new RepeatedMapJsonConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedListConverter(int fieldId, String fieldName, FieldReader reader) {
        return new RepeatedListJsonConverter(fieldId, fieldName, reader);
    }

    @Override
    public void startRecord() throws IOException {
        this.gen.writeStartObject();
    }

    @Override
    public void endRecord() throws IOException {
        this.gen.writeEndObject();
    }

    @Override
    public void abort() throws IOException {
        if (this.cleanUpLocation != null) {
            this.fs.delete(this.cleanUpLocation, true);
            logger.info("Aborting writer. Location [{}] on file system [{}] is deleted.", (Object)this.cleanUpLocation.toUri().getPath(), (Object)this.fs.getUri());
        }
    }

    @Override
    public void cleanup() throws IOException {
        this.gen.flush();
        this.stream.close();
    }

    public class MapJsonConverter
    extends EventBasedRecordWriter.FieldConverter {
        List<EventBasedRecordWriter.FieldConverter> converters;

        public MapJsonConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.converters = Lists.newArrayList();
            int i = 0;
            for (String name : reader) {
                EventBasedRecordWriter.FieldConverter converter = EventBasedRecordWriter.getConverter(JsonRecordWriter.this, i++, name, reader.reader(name));
                this.converters.add(converter);
            }
        }

        @Override
        public void startField() throws IOException {
            JsonRecordWriter.this.gen.writeFieldName(this.fieldName);
        }

        @Override
        public void writeField() throws IOException {
            JsonRecordWriter.this.gen.writeStartObject();
            for (EventBasedRecordWriter.FieldConverter converter : this.converters) {
                converter.startField();
                converter.writeField();
            }
            JsonRecordWriter.this.gen.writeEndObject();
        }
    }

    public class UnionJsonConverter
    extends EventBasedRecordWriter.FieldConverter {
        public UnionJsonConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
        }

        @Override
        public void startField() throws IOException {
            JsonRecordWriter.this.gen.writeFieldName(this.fieldName);
        }

        @Override
        public void writeField() throws IOException {
            JsonWriter writer = new JsonWriter(JsonRecordWriter.this.gen);
            writer.write(this.reader);
        }
    }

    public class RepeatedMapJsonConverter
    extends EventBasedRecordWriter.FieldConverter {
        List<EventBasedRecordWriter.FieldConverter> converters;

        public RepeatedMapJsonConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.converters = Lists.newArrayList();
            int i = 0;
            for (String name : reader) {
                EventBasedRecordWriter.FieldConverter converter = EventBasedRecordWriter.getConverter(JsonRecordWriter.this, i++, name, reader.reader(name));
                this.converters.add(converter);
            }
        }

        @Override
        public void startField() throws IOException {
            JsonRecordWriter.this.gen.writeFieldName(this.fieldName);
        }

        @Override
        public void writeField() throws IOException {
            JsonRecordWriter.this.gen.writeStartArray();
            while (this.reader.next()) {
                JsonRecordWriter.this.gen.writeStartObject();
                for (EventBasedRecordWriter.FieldConverter converter : this.converters) {
                    converter.startField();
                    converter.writeField();
                }
                JsonRecordWriter.this.gen.writeEndObject();
            }
            JsonRecordWriter.this.gen.writeEndArray();
        }
    }

    public class RepeatedListJsonConverter
    extends EventBasedRecordWriter.FieldConverter {
        EventBasedRecordWriter.FieldConverter converter;

        public RepeatedListJsonConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.converter = EventBasedRecordWriter.getConverter(JsonRecordWriter.this, fieldId, fieldName, reader.reader());
        }

        @Override
        public void startField() throws IOException {
            JsonRecordWriter.this.gen.writeFieldName(this.fieldName);
        }

        @Override
        public void writeField() throws IOException {
            JsonRecordWriter.this.gen.writeStartArray();
            while (this.reader.next()) {
                this.converter.writeField();
            }
            JsonRecordWriter.this.gen.writeEndArray();
        }
    }
}

