/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.physical.impl.scan.file.FileScanFramework;
import org.apache.drill.exec.physical.impl.scan.framework.ManagedReader;
import org.apache.drill.exec.planner.common.DrillStatsTable;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.server.options.OptionSet;
import org.apache.drill.exec.store.RecordReader;
import org.apache.drill.exec.store.RecordWriter;
import org.apache.drill.exec.store.StatisticsRecordWriter;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.store.dfs.easy.EasyFormatPlugin;
import org.apache.drill.exec.store.dfs.easy.EasySubScan;
import org.apache.drill.exec.store.dfs.easy.EasyWriter;
import org.apache.drill.exec.store.dfs.easy.FileWork;
import org.apache.drill.exec.store.easy.json.JSONFormatConfig;
import org.apache.drill.exec.store.easy.json.JSONRecordReader;
import org.apache.drill.exec.store.easy.json.JsonBatchReader;
import org.apache.drill.exec.store.easy.json.JsonRecordWriter;
import org.apache.drill.exec.store.easy.json.JsonStatisticsRecordWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONFormatPlugin
extends EasyFormatPlugin<JSONFormatConfig> {
    private static final Logger logger = LoggerFactory.getLogger(JSONFormatPlugin.class);
    public static final String PLUGIN_NAME = "json";
    private static final boolean IS_COMPRESSIBLE = true;
    public static final String READER_OPERATOR_TYPE = "JSON_SUB_SCAN";
    public static final String WRITER_OPERATOR_TYPE = "JSON_WRITER";

    public JSONFormatPlugin(String name, DrillbitContext context, Configuration fsConf, StoragePluginConfig storageConfig) {
        this(name, context, fsConf, storageConfig, new JSONFormatConfig(null, null, null, null, null, null));
    }

    public JSONFormatPlugin(String name, DrillbitContext context, Configuration fsConf, StoragePluginConfig config, JSONFormatConfig formatPluginConfig) {
        super(name, JSONFormatPlugin.easyConfig(fsConf, formatPluginConfig), context, config, formatPluginConfig);
    }

    private static EasyFormatPlugin.EasyFormatConfig easyConfig(Configuration fsConf, JSONFormatConfig pluginConfig) {
        return EasyFormatPlugin.EasyFormatConfig.builder().readable(true).writable(true).blockSplittable(false).compressible(true).supportsProjectPushdown(true).extensions(pluginConfig.getExtensions()).fsConf(fsConf).defaultName(PLUGIN_NAME).readerOperatorType(READER_OPERATOR_TYPE).writerOperatorType(WRITER_OPERATOR_TYPE).scanVersion(EasyFormatPlugin.ScanFrameworkVersion.EVF_V1).supportsLimitPushdown(true).supportsStatistics(true).build();
    }

    @Override
    public RecordReader getRecordReader(FragmentContext context, DrillFileSystem dfs, FileWork fileWork, List<SchemaPath> columns, String userName) {
        return new JSONRecordReader(context, fileWork.getPath(), dfs, columns, (JSONFormatConfig)this.formatConfig);
    }

    @Override
    public boolean isStatisticsRecordWriter(FragmentContext context, EasyWriter writer) {
        return context.getSQLStatementType() == QueryContext.SqlStatementType.ANALYZE;
    }

    @Override
    public StatisticsRecordWriter getStatisticsRecordWriter(FragmentContext context, EasyWriter writer) {
        if (!this.isStatisticsRecordWriter(context, writer)) {
            return null;
        }
        Map<String, String> options = this.setupOptions(context, writer, true);
        JsonStatisticsRecordWriter recordWriter = new JsonStatisticsRecordWriter(this.getFsConf(), this);
        recordWriter.init(options);
        return recordWriter;
    }

    @Override
    public RecordWriter getRecordWriter(FragmentContext context, EasyWriter writer) throws IOException {
        Map<String, String> options = this.setupOptions(context, writer, true);
        JsonRecordWriter recordWriter = new JsonRecordWriter(writer.getStorageStrategy(), this.getFsConf());
        recordWriter.init(options);
        return recordWriter;
    }

    private Map<String, String> setupOptions(FragmentContext context, EasyWriter writer, boolean statsOptions) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("location", writer.getLocation());
        OptionManager optionMgr = context.getOptions();
        ExecProtos.FragmentHandle handle = context.getHandle();
        String fragmentId = String.format("%d_%d", handle.getMajorFragmentId(), handle.getMinorFragmentId());
        options.put("prefix", fragmentId);
        options.put("separator", " ");
        options.put("extension", PLUGIN_NAME);
        options.put("extended", Boolean.toString(optionMgr.getBoolean("store.json.extended_types")));
        options.put("uglify", Boolean.toString(optionMgr.getBoolean("store.json.writer.uglify")));
        options.put("skipnulls", Boolean.toString(optionMgr.getBoolean("store.json.writer.skip_null_fields")));
        options.put("enableNanInf", Boolean.toString(optionMgr.getBoolean("store.json.writer.allow_nan_inf")));
        if (statsOptions) {
            options.put("queryid", context.getQueryIdString());
        }
        return options;
    }

    @Override
    public boolean supportsStatistics() {
        return true;
    }

    @Override
    public DrillStatsTable.TableStatistics readStatistics(FileSystem fs, Path statsTablePath) throws IOException {
        throw new UnsupportedOperationException("unimplemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeStatistics(DrillStatsTable.TableStatistics statistics, FileSystem fs, Path statsTablePath) throws IOException {
        FSDataOutputStream stream = null;
        JsonGenerator generator = null;
        try {
            JsonFactory factory = new JsonFactory();
            stream = fs.create(statsTablePath);
            ObjectMapper mapper = DrillStatsTable.getMapper();
            generator = factory.createGenerator((OutputStream)stream).useDefaultPrettyPrinter().setCodec((ObjectCodec)mapper);
            mapper.writeValue(generator, (Object)statistics);
        }
        catch (JsonGenerationException ex) {
            logger.error("Unable to create file (JSON generation error): " + statsTablePath.getName(), (Throwable)ex);
            throw ex;
        }
        catch (JsonMappingException ex) {
            logger.error("Unable to create file (JSON mapping error): " + statsTablePath.getName(), (Throwable)ex);
            throw ex;
        }
        catch (IOException ex) {
            logger.error("Unable to create file " + statsTablePath.getName(), (Throwable)ex);
        }
        finally {
            if (generator != null) {
                generator.flush();
            }
            if (stream != null) {
                stream.close();
            }
        }
    }

    @Override
    protected EasyFormatPlugin.ScanFrameworkVersion scanVersion(OptionSet options) {
        return options.getBoolean("store.json.enable_v2_reader") ? EasyFormatPlugin.ScanFrameworkVersion.EVF_V1 : EasyFormatPlugin.ScanFrameworkVersion.CLASSIC;
    }

    @Override
    protected FileScanFramework.FileScanBuilder frameworkBuilder(EasySubScan scan, OptionSet options) throws ExecutionSetupException {
        FileScanFramework.FileScanBuilder builder = new FileScanFramework.FileScanBuilder();
        this.initScanBuilder(builder, scan);
        builder.setReaderFactory(new FileScanFramework.FileReaderFactory(){

            @Override
            public ManagedReader<? extends FileScanFramework.FileSchemaNegotiator> newReader() {
                return new JsonBatchReader();
            }
        });
        builder.nullType(Types.optional(TypeProtos.MinorType.VARCHAR));
        return builder;
    }

    @Override
    public String getReaderOperatorType() {
        return READER_OPERATOR_TYPE;
    }

    @Override
    public String getWriterOperatorType() {
        return WRITER_OPERATOR_TYPE;
    }

    @Override
    public boolean supportsPushDown() {
        return true;
    }
}

