/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Objects;
import org.apache.drill.common.PlanStringBuilder;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;

@JsonTypeName(value="json")
public class JSONFormatConfig
implements FormatPluginConfig {
    private static final List<String> DEFAULT_EXTS = ImmutableList.of("json");
    private final List<String> extensions;
    private final Boolean allTextMode;
    private final Boolean readNumbersAsDouble;
    private final Boolean skipMalformedJSONRecords;
    private final Boolean escapeAnyChar;
    private final Boolean nanInf;

    @JsonCreator
    public JSONFormatConfig(@JsonProperty(value="extensions") List<String> extensions, @JsonProperty(value="allTextMode") Boolean allTextMode, @JsonProperty(value="readNumbersAsDouble") Boolean readNumbersAsDouble, @JsonProperty(value="skipMalformedJSONRecords") Boolean skipMalformedJSONRecords, @JsonProperty(value="escapeAnyChar") Boolean escapeAnyChar, @JsonProperty(value="nanInf") Boolean nanInf) {
        this.extensions = extensions == null ? DEFAULT_EXTS : ImmutableList.copyOf(extensions);
        this.allTextMode = allTextMode;
        this.readNumbersAsDouble = readNumbersAsDouble;
        this.skipMalformedJSONRecords = skipMalformedJSONRecords;
        this.escapeAnyChar = escapeAnyChar;
        this.nanInf = nanInf;
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public List<String> getExtensions() {
        return this.extensions;
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public Boolean getAllTextMode() {
        return this.allTextMode;
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public Boolean getReadNumbersAsDouble() {
        return this.readNumbersAsDouble;
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public Boolean getSkipMalformedJSONRecords() {
        return this.skipMalformedJSONRecords;
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public Boolean getEscapeAnyChar() {
        return this.escapeAnyChar;
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public Boolean getNanInf() {
        return this.nanInf;
    }

    public int hashCode() {
        return Objects.hash(this.extensions, this.allTextMode, this.readNumbersAsDouble, this.skipMalformedJSONRecords, this.escapeAnyChar, this.nanInf);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JSONFormatConfig other = (JSONFormatConfig)obj;
        return Objects.deepEquals(this.extensions, other.extensions) && Objects.equals(this.allTextMode, other.allTextMode) && Objects.equals(this.readNumbersAsDouble, other.readNumbersAsDouble) && Objects.equals(this.skipMalformedJSONRecords, other.skipMalformedJSONRecords) && Objects.equals(this.escapeAnyChar, other.escapeAnyChar) && Objects.equals(this.nanInf, other.nanInf);
    }

    public String toString() {
        return new PlanStringBuilder(this).field("extensions", this.extensions).field("allTextMode", this.allTextMode).field("readNumbersAsDouble", this.readNumbersAsDouble).field("skipMalformedRecords", this.skipMalformedJSONRecords).field("escapeAnyChar", this.escapeAnyChar).field("nanInf", this.nanInf).toString();
    }
}

