/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.dfs.easy;

import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.impl.scan.file.FileScanFramework;
import org.apache.drill.exec.physical.impl.scan.framework.ManagedReader;
import org.apache.drill.exec.record.CloseableRecordBatch;
import org.apache.drill.exec.store.dfs.easy.EasyFormatPlugin;
import org.apache.drill.exec.store.dfs.easy.EasySubScan;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EvfV1ScanBuilder {
    private static final Logger logger = LoggerFactory.getLogger(EvfV1ScanBuilder.class);
    private final FragmentContext context;
    private final EasySubScan scan;
    private final EasyFormatPlugin<? extends FormatPluginConfig> plugin;

    public EvfV1ScanBuilder(FragmentContext context, EasySubScan scan, EasyFormatPlugin<? extends FormatPluginConfig> plugin) {
        this.context = context;
        this.scan = scan;
        this.plugin = plugin;
    }

    public CloseableRecordBatch build() throws ExecutionSetupException {
        FileScanFramework.FileScanBuilder builder = this.plugin.frameworkBuilder(this.scan, this.context.getOptions());
        if (builder.readerFactory() == null) {
            builder.setReaderFactory(new EasyReaderFactory(this.plugin, this.scan, this.context));
        }
        return builder.buildScanOperator(this.context, this.scan);
    }

    protected static void initScanBuilder(EasyFormatPlugin<? extends FormatPluginConfig> plugin, FileScanFramework.FileScanBuilder builder, EasySubScan scan) {
        builder.projection(scan.getColumns());
        builder.setUserName(scan.getUserName());
        builder.providedSchema(scan.getSchema());
        builder.setFileSystemConfig(plugin.getFsConf());
        builder.setFiles(scan.getWorkUnits());
        Path selectionRoot = scan.getSelectionRoot();
        if (selectionRoot != null) {
            builder.implicitColumnOptions().setSelectionRoot(selectionRoot);
            builder.implicitColumnOptions().setPartitionDepth(scan.getPartitionDepth());
        }
        builder.errorContext(currentBuilder -> currentBuilder.addContext("Format plugin", plugin.easyConfig().getDefaultName()).addContext("Format plugin", plugin.getClass().getSimpleName()).addContext("Plugin config name", plugin.getName()));
    }

    private static class EasyReaderFactory
    extends FileScanFramework.FileReaderFactory {
        private final EasyFormatPlugin<? extends FormatPluginConfig> plugin;
        private final EasySubScan scan;
        private final FragmentContext context;

        public EasyReaderFactory(EasyFormatPlugin<? extends FormatPluginConfig> plugin, EasySubScan scan, FragmentContext context) {
            this.plugin = plugin;
            this.scan = scan;
            this.context = context;
        }

        @Override
        public ManagedReader<? extends FileScanFramework.FileSchemaNegotiator> newReader() {
            try {
                return this.plugin.newBatchReader(this.scan, this.context.getOptions());
            }
            catch (ExecutionSetupException e) {
                throw UserException.validationError(e).addContext("Reason", "Failed to create a batch reader").addContext(this.errorContext()).build(logger);
            }
        }
    }
}

