/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.dfs.easy;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.base.AbstractWriter;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.StorageStrategy;
import org.apache.drill.exec.store.dfs.easy.EasyFormatPlugin;

@JsonTypeName(value="fs-writer")
public class EasyWriter
extends AbstractWriter {
    private final String location;
    private final List<String> partitionColumns;
    private final EasyFormatPlugin<?> formatPlugin;

    @JsonCreator
    public EasyWriter(@JsonProperty(value="child") PhysicalOperator child, @JsonProperty(value="location") String location, @JsonProperty(value="partitionColumns") List<String> partitionColumns, @JsonProperty(value="storageStrategy") StorageStrategy storageStrategy, @JsonProperty(value="storage") StoragePluginConfig storageConfig, @JsonProperty(value="format") FormatPluginConfig formatConfig, @JacksonInject StoragePluginRegistry engineRegistry) {
        super(child);
        this.formatPlugin = engineRegistry.resolveFormat(storageConfig, formatConfig, EasyFormatPlugin.class);
        this.location = location;
        this.partitionColumns = partitionColumns;
        this.setStorageStrategy(storageStrategy);
    }

    public EasyWriter(PhysicalOperator child, String location, List<String> partitionColumns, EasyFormatPlugin<?> formatPlugin) {
        super(child);
        this.formatPlugin = formatPlugin;
        this.location = location;
        this.partitionColumns = partitionColumns;
    }

    @JsonProperty(value="location")
    public String getLocation() {
        return this.location;
    }

    @JsonProperty(value="storage")
    public StoragePluginConfig getStorageConfig() {
        return this.formatPlugin.getStorageConfig();
    }

    @JsonProperty(value="format")
    public FormatPluginConfig getFormatConfig() {
        return this.formatPlugin.getConfig();
    }

    @JsonIgnore
    public EasyFormatPlugin<?> getFormatPlugin() {
        return this.formatPlugin;
    }

    @Override
    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        EasyWriter writer = new EasyWriter(child, this.location, this.partitionColumns, this.formatPlugin);
        writer.setStorageStrategy(this.getStorageStrategy());
        return writer;
    }

    @Override
    public String getOperatorType() {
        return this.formatPlugin.getWriterOperatorType();
    }

    public String toString() {
        return "EasyWriter[location=" + this.location + ", storageStrategy=" + this.getStorageStrategy() + ", partitionColumns=" + this.partitionColumns + "]";
    }
}

