/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.dfs.easy;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.base.AbstractSubScan;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.dfs.easy.EasyFormatPlugin;
import org.apache.drill.exec.store.schedule.CompleteFileWork;
import org.apache.hadoop.fs.Path;

@JsonTypeName(value="fs-sub-scan")
public class EasySubScan
extends AbstractSubScan {
    private final List<CompleteFileWork.FileWorkImpl> files;
    private final EasyFormatPlugin<?> formatPlugin;
    private final List<SchemaPath> columns;
    private final Path selectionRoot;
    private final int partitionDepth;
    private final TupleMetadata schema;
    private final int limit;

    @JsonCreator
    public EasySubScan(@JsonProperty(value="userName") String userName, @JsonProperty(value="files") List<CompleteFileWork.FileWorkImpl> files, @JsonProperty(value="storage") StoragePluginConfig storageConfig, @JsonProperty(value="format") FormatPluginConfig formatConfig, @JacksonInject StoragePluginRegistry engineRegistry, @JsonProperty(value="columns") List<SchemaPath> columns, @JsonProperty(value="selectionRoot") Path selectionRoot, @JsonProperty(value="partitionDepth") int partitionDepth, @JsonProperty(value="schema") TupleMetadata schema, @JsonProperty(value="limit") int limit) throws ExecutionSetupException {
        super(userName);
        this.formatPlugin = engineRegistry.resolveFormat(storageConfig, formatConfig, EasyFormatPlugin.class);
        this.files = files;
        this.columns = columns;
        this.selectionRoot = selectionRoot;
        this.partitionDepth = partitionDepth;
        this.schema = schema;
        this.limit = limit;
    }

    public EasySubScan(String userName, List<CompleteFileWork.FileWorkImpl> files, EasyFormatPlugin<?> plugin, List<SchemaPath> columns, Path selectionRoot, int partitionDepth, TupleMetadata schema, int limit) {
        super(userName);
        this.formatPlugin = plugin;
        this.files = files;
        this.columns = columns;
        this.selectionRoot = selectionRoot;
        this.partitionDepth = partitionDepth;
        this.schema = schema;
        this.limit = limit;
    }

    @JsonProperty
    public Path getSelectionRoot() {
        return this.selectionRoot;
    }

    @JsonProperty
    public int getPartitionDepth() {
        return this.partitionDepth;
    }

    @JsonIgnore
    public EasyFormatPlugin<?> getFormatPlugin() {
        return this.formatPlugin;
    }

    @JsonProperty(value="files")
    public List<CompleteFileWork.FileWorkImpl> getWorkUnits() {
        return this.files;
    }

    @JsonProperty(value="storage")
    public StoragePluginConfig getStorageConfig() {
        return this.formatPlugin.getStorageConfig();
    }

    @JsonProperty(value="format")
    public FormatPluginConfig getFormatConfig() {
        return this.formatPlugin.getConfig();
    }

    @JsonProperty(value="columns")
    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    @JsonProperty(value="schema")
    public TupleMetadata getSchema() {
        return this.schema;
    }

    @JsonProperty(value="limit")
    public int getLimit() {
        return this.limit;
    }

    @JsonIgnore
    public int getMaxRecords() {
        if (this.limit < 0) {
            return 0;
        }
        if (this.limit == 0) {
            return 1;
        }
        return this.limit;
    }

    @Override
    public String getOperatorType() {
        return this.formatPlugin.getReaderOperatorType();
    }
}

