/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.dfs.easy;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.drill.common.PlanStringBuilder;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.metastore.MetadataProviderManager;
import org.apache.drill.exec.metastore.MetastoreMetadataProviderManager;
import org.apache.drill.exec.metastore.analyze.AnalyzeFileInfoProviderImpl;
import org.apache.drill.exec.metastore.analyze.AnalyzeInfoProvider;
import org.apache.drill.exec.metastore.store.FileSystemMetadataProviderManager;
import org.apache.drill.exec.metastore.store.FileTableMetadataProviderBuilder;
import org.apache.drill.exec.metastore.store.MetastoreFileTableMetadataProvider;
import org.apache.drill.exec.metastore.store.SimpleFileTableMetadataProvider;
import org.apache.drill.exec.physical.EndpointAffinity;
import org.apache.drill.exec.physical.base.AbstractGroupScanWithMetadata;
import org.apache.drill.exec.physical.base.FileGroupScan;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.ColumnExplorer;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.store.dfs.FileSelection;
import org.apache.drill.exec.store.dfs.easy.EasyFormatPlugin;
import org.apache.drill.exec.store.dfs.easy.EasySubScan;
import org.apache.drill.exec.store.schedule.AffinityCreator;
import org.apache.drill.exec.store.schedule.AssignmentCreator;
import org.apache.drill.exec.store.schedule.BlockMapBuilder;
import org.apache.drill.exec.store.schedule.CompleteFileWork;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.drill.metastore.metadata.FileMetadata;
import org.apache.drill.metastore.metadata.LocationProvider;
import org.apache.drill.metastore.metadata.TableMetadataProvider;
import org.apache.drill.metastore.util.TableMetadataUtils;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.Iterators;
import org.apache.drill.shaded.guava.com.google.common.collect.ListMultimap;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="fs-scan")
public class EasyGroupScan
extends AbstractGroupScanWithMetadata<TableMetadataProvider> {
    private static final Logger logger = LoggerFactory.getLogger(EasyGroupScan.class);
    private final EasyFormatPlugin<?> formatPlugin;
    private FileSelection selection;
    private int partitionDepth = -1;
    private int maxWidth;
    private int minWidth = 1;
    private ListMultimap<Integer, CompleteFileWork> mappings;
    private List<CompleteFileWork> chunks;
    private List<EndpointAffinity> endpointAffinities;
    private final Path selectionRoot;

    @JsonCreator
    public EasyGroupScan(@JsonProperty(value="userName") String userName, @JsonProperty(value="files") List<Path> files, @JsonProperty(value="storage") StoragePluginConfig storageConfig, @JsonProperty(value="format") FormatPluginConfig formatConfig, @JacksonInject StoragePluginRegistry engineRegistry, @JsonProperty(value="columns") List<SchemaPath> columns, @JsonProperty(value="selectionRoot") Path selectionRoot, @JsonProperty(value="schema") TupleMetadata schema, @JsonProperty(value="limit") int limit) throws IOException {
        super(ImpersonationUtil.resolveUserName(userName), columns, ValueExpressions.BooleanExpression.TRUE);
        this.selection = FileSelection.create(null, files, selectionRoot);
        this.formatPlugin = engineRegistry.resolveFormat(storageConfig, formatConfig, EasyFormatPlugin.class);
        this.columns = columns == null ? ALL_COLUMNS : columns;
        this.selectionRoot = selectionRoot;
        this.limit = limit;
        this.metadataProvider = this.defaultTableMetadataProviderBuilder(new FileSystemMetadataProviderManager()).withSelection(this.selection).withSchema(schema).build();
        this.initFromSelection(this.selection, this.formatPlugin);
    }

    public EasyGroupScan(String userName, FileSelection selection, EasyFormatPlugin<?> formatPlugin, List<SchemaPath> columns, Path selectionRoot, MetadataProviderManager metadataProviderManager) throws IOException {
        super(userName, columns, ValueExpressions.BooleanExpression.TRUE);
        this.selection = Preconditions.checkNotNull(selection);
        this.formatPlugin = Preconditions.checkNotNull(formatPlugin, "Unable to load format plugin for provided format config.");
        this.columns = columns == null ? ALL_COLUMNS : columns;
        this.selectionRoot = selectionRoot;
        if (metadataProviderManager == null) {
            metadataProviderManager = new FileSystemMetadataProviderManager();
        }
        DrillFileSystem fs = ImpersonationUtil.createFileSystem(ImpersonationUtil.resolveUserName(userName), formatPlugin.getFsConf());
        this.metadataProvider = this.tableMetadataProviderBuilder(metadataProviderManager).withSelection(selection).withFileSystem(fs).build();
        this.usedMetastore = metadataProviderManager.usesMetastore();
        this.initFromSelection(selection, formatPlugin);
        this.checkMetadataConsistency(selection, formatPlugin.getFsConf());
    }

    public EasyGroupScan(String userName, FileSelection selection, EasyFormatPlugin<?> formatPlugin, List<SchemaPath> columns, Path selectionRoot, int minWidth, MetadataProviderManager metadataProvider) throws IOException {
        this(userName, selection, formatPlugin, columns, selectionRoot, metadataProvider);
        this.minWidth = Math.max(1, Math.min(minWidth, this.maxWidth));
        this.partitionDepth = ColumnExplorer.getPartitionDepth(selection);
    }

    private EasyGroupScan(EasyGroupScan that) {
        super(that);
        this.selection = that.selection;
        this.formatPlugin = that.formatPlugin;
        this.columns = that.columns;
        this.selectionRoot = that.selectionRoot;
        this.chunks = that.chunks;
        this.endpointAffinities = that.endpointAffinities;
        this.maxWidth = that.maxWidth;
        this.minWidth = that.minWidth;
        this.mappings = that.mappings;
        this.partitionDepth = that.partitionDepth;
        this.metadataProvider = that.metadataProvider;
    }

    @JsonIgnore
    public Iterable<CompleteFileWork> getWorkIterable() {
        return () -> Iterators.unmodifiableIterator(this.chunks.iterator());
    }

    private void initFromSelection(FileSelection selection, EasyFormatPlugin<?> formatPlugin) throws IOException {
        DrillFileSystem dfs = ImpersonationUtil.createFileSystem(this.getUserName(), formatPlugin.getFsConf());
        this.selection = selection;
        BlockMapBuilder b = new BlockMapBuilder(dfs, formatPlugin.getContext().getBits());
        this.chunks = b.generateFileWork(selection.getStatuses(dfs), formatPlugin.isBlockSplittable());
        this.maxWidth = this.chunks.size();
        this.endpointAffinities = AffinityCreator.getAffinityMap(this.chunks);
    }

    @Override
    public Path getSelectionRoot() {
        return this.selectionRoot;
    }

    @Override
    @JsonIgnore
    public int getMinParallelizationWidth() {
        return this.minWidth;
    }

    @Override
    public int getMaxParallelizationWidth() {
        return this.maxWidth;
    }

    @Override
    public ScanStats getScanStats(PlannerSettings settings) {
        return this.formatPlugin.getScanStats(settings, this);
    }

    @Override
    public boolean hasFiles() {
        return true;
    }

    @JsonProperty(value="files")
    public List<Path> getFiles() {
        return this.selection.getFiles();
    }

    @JsonIgnore
    public FileSelection getFileSelection() {
        return this.selection;
    }

    @Override
    public void modifyFileSelection(FileSelection selection) {
        this.selection = selection;
    }

    @Override
    protected boolean supportsFileImplicitColumns() {
        return this.formatPlugin.supportsFileImplicitColumns();
    }

    @Override
    public boolean supportsFilterPushDown() {
        return this.usedMetastore();
    }

    @Override
    protected List<String> getPartitionValues(LocationProvider locationProvider) {
        return ColumnExplorer.listPartitionValues(locationProvider.getPath(), this.selectionRoot, false);
    }

    @Override
    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        assert (children == null || children.isEmpty());
        return new EasyGroupScan(this);
    }

    @Override
    public List<EndpointAffinity> getOperatorAffinity() {
        if (this.endpointAffinities == null) {
            logger.debug("Chunks size: {}", (Object)this.chunks.size());
            this.endpointAffinities = AffinityCreator.getAffinityMap(this.chunks);
        }
        return this.endpointAffinities;
    }

    @Override
    public void applyAssignments(List<CoordinationProtos.DrillbitEndpoint> incomingEndpoints) {
        this.mappings = AssignmentCreator.getMappings(incomingEndpoints, this.chunks);
    }

    private void createMappings(List<EndpointAffinity> affinities) {
        ArrayList<CoordinationProtos.DrillbitEndpoint> endpoints = Lists.newArrayList();
        for (EndpointAffinity e : affinities) {
            endpoints.add(e.getEndpoint());
        }
        this.applyAssignments(endpoints);
    }

    @Override
    public EasySubScan getSpecificScan(int minorFragmentId) {
        if (this.mappings == null) {
            this.createMappings(this.endpointAffinities);
        }
        assert (minorFragmentId < this.mappings.size()) : String.format("Mappings length [%d] should be longer than minor fragment id [%d] but it isn't.", this.mappings.size(), minorFragmentId);
        Collection filesForMinor = this.mappings.get((Object)minorFragmentId);
        Preconditions.checkArgument(!filesForMinor.isEmpty(), String.format("MinorFragmentId %d has no read entries assigned", minorFragmentId));
        EasySubScan subScan = new EasySubScan(this.getUserName(), this.convert((List<CompleteFileWork>)filesForMinor), this.formatPlugin, this.columns, this.selectionRoot, this.partitionDepth, this.getSchema(), this.limit);
        subScan.setOperatorId(this.getOperatorId());
        return subScan;
    }

    private List<CompleteFileWork.FileWorkImpl> convert(List<CompleteFileWork> list) {
        ArrayList<CompleteFileWork.FileWorkImpl> newList = Lists.newArrayList();
        for (CompleteFileWork f : list) {
            newList.add(f.getAsFileWork());
        }
        return newList;
    }

    @JsonProperty(value="storage")
    public StoragePluginConfig getStorageConfig() {
        return this.formatPlugin.getStorageConfig();
    }

    @JsonProperty(value="format")
    public FormatPluginConfig getFormatConfig() {
        return this.formatPlugin.getConfig();
    }

    public String toString() {
        return new PlanStringBuilder(this).field("selectionRoot", this.selectionRoot).field("numFiles", this.getFiles().size()).field("columns", this.columns).field("files", this.getFiles()).field("schema", this.getSchema()).field("usedMetastore", this.usedMetastore()).field("limit", this.limit).field("formatConfig", this.getFormatConfig()).toString();
    }

    @Override
    public GroupScan clone(List<SchemaPath> columns) {
        if (!this.formatPlugin.supportsPushDown()) {
            throw new IllegalStateException(String.format("%s doesn't support push down.", this.getClass().getSimpleName()));
        }
        EasyGroupScan newScan = new EasyGroupScan(this);
        newScan.columns = columns;
        return newScan;
    }

    @Override
    public FileGroupScan clone(FileSelection selection) throws IOException {
        EasyGroupScan newScan = new EasyGroupScan(this);
        newScan.initFromSelection(selection, this.formatPlugin);
        newScan.mappings = null;
        return newScan;
    }

    @Override
    @JsonIgnore
    public boolean canPushdownProjects(List<SchemaPath> columns) {
        return this.formatPlugin.supportsPushDown();
    }

    @Override
    public TupleMetadata getSchema() {
        return this.getTableMetadata().getSchema();
    }

    @Override
    public AnalyzeInfoProvider getAnalyzeInfoProvider() {
        return new AnalyzeFileInfoProviderImpl(this.formatPlugin.getName());
    }

    @Override
    protected AbstractGroupScanWithMetadata.GroupScanWithMetadataFilterer<?> getFilterer() {
        return new EasyGroupScanFilterer(this);
    }

    @Override
    protected FileTableMetadataProviderBuilder<?> tableMetadataProviderBuilder(MetadataProviderManager source) {
        if (source.usesMetastore()) {
            return new MetastoreFileTableMetadataProvider.Builder((MetastoreMetadataProviderManager)source);
        }
        return this.defaultTableMetadataProviderBuilder(source);
    }

    @Override
    protected FileTableMetadataProviderBuilder<?> defaultTableMetadataProviderBuilder(MetadataProviderManager source) {
        return new SimpleFileTableMetadataProvider.Builder(source);
    }

    private static class EasyGroupScanFilterer
    extends AbstractGroupScanWithMetadata.GroupScanWithMetadataFilterer<EasyGroupScanFilterer> {
        EasyGroupScanFilterer(EasyGroupScan source) {
            super(source);
        }

        @Override
        public AbstractGroupScanWithMetadata<?> build() {
            EasyGroupScan newScan = new EasyGroupScan((EasyGroupScan)this.source);
            newScan.tableMetadata = this.tableMetadata;
            if (newScan.getTableMetadata() != null && MapUtils.isNotEmpty((Map)this.files) && newScan.getFilesMetadata().size() != this.files.size()) {
                newScan.tableMetadata = TableMetadataUtils.updateRowCount(newScan.getTableMetadata(), this.files.values());
            }
            newScan.partitions = this.partitions;
            newScan.segments = this.segments;
            newScan.files = this.files;
            newScan.matchAllMetadata = this.matchAllMetadata;
            newScan.nonInterestingColumnsMetadata = this.nonInterestingColumnsMetadata;
            newScan.limit = this.limit;
            Map<Path, FileMetadata> filesMetadata = newScan.getFilesMetadata();
            if (MapUtils.isNotEmpty(filesMetadata)) {
                newScan.fileSet = filesMetadata.keySet();
                newScan.selection = FileSelection.create(null, new ArrayList<Path>(newScan.fileSet), newScan.selectionRoot);
            }
            try {
                newScan.initFromSelection(newScan.selection, newScan.formatPlugin);
            }
            catch (IOException e) {
                throw new DrillRuntimeException("Failed to initialize scan from the selection.", e);
            }
            return newScan;
        }

        @Override
        protected EasyGroupScanFilterer self() {
            return this;
        }
    }
}

