/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.dfs.easy;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.metastore.MetadataProviderManager;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.physical.base.AbstractWriter;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.physical.impl.StatisticsWriterRecordBatch;
import org.apache.drill.exec.physical.impl.WriterRecordBatch;
import org.apache.drill.exec.physical.impl.scan.file.FileScanFramework;
import org.apache.drill.exec.physical.impl.scan.framework.ManagedReader;
import org.apache.drill.exec.physical.impl.scan.v3.file.FileScanLifecycleBuilder;
import org.apache.drill.exec.planner.common.DrillStatsTable;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.record.CloseableRecordBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.options.OptionSet;
import org.apache.drill.exec.store.RecordReader;
import org.apache.drill.exec.store.RecordWriter;
import org.apache.drill.exec.store.StatisticsRecordWriter;
import org.apache.drill.exec.store.StoragePluginOptimizerRule;
import org.apache.drill.exec.store.dfs.BasicFormatMatcher;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.store.dfs.FileSelection;
import org.apache.drill.exec.store.dfs.FormatMatcher;
import org.apache.drill.exec.store.dfs.FormatPlugin;
import org.apache.drill.exec.store.dfs.easy.ClassicScanBuilder;
import org.apache.drill.exec.store.dfs.easy.EasyFileScanBuilder;
import org.apache.drill.exec.store.dfs.easy.EasyGroupScan;
import org.apache.drill.exec.store.dfs.easy.EasySubScan;
import org.apache.drill.exec.store.dfs.easy.EasyWriter;
import org.apache.drill.exec.store.dfs.easy.EvfV1ScanBuilder;
import org.apache.drill.exec.store.dfs.easy.FileWork;
import org.apache.drill.exec.store.schedule.CompleteFileWork;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public abstract class EasyFormatPlugin<T extends FormatPluginConfig>
implements FormatPlugin {
    private final String name;
    private final EasyFormatConfig easyConfig;
    private final DrillbitContext context;
    private final StoragePluginConfig storageConfig;
    protected final T formatConfig;

    protected EasyFormatPlugin(String name, DrillbitContext context, Configuration fsConf, StoragePluginConfig storageConfig, T formatConfig, boolean readable, boolean writable, boolean blockSplittable, boolean compressible, List<String> extensions, String defaultName) {
        this.name = name == null ? defaultName : name;
        this.easyConfig = EasyFormatConfig.builder().matcher(new BasicFormatMatcher(this, fsConf, extensions, compressible)).readable(readable).writable(writable).blockSplittable(blockSplittable).compressible(compressible).fsConf(fsConf).defaultName(defaultName).build();
        this.context = context;
        this.storageConfig = storageConfig;
        this.formatConfig = formatConfig;
    }

    protected EasyFormatPlugin(String name, EasyFormatConfig config, DrillbitContext context, StoragePluginConfig storageConfig, T formatConfig) {
        this.name = name;
        this.easyConfig = config;
        this.context = context;
        this.storageConfig = storageConfig;
        this.formatConfig = formatConfig;
        if (this.easyConfig.matcher == null) {
            this.easyConfig.matcher = new BasicFormatMatcher(this, this.easyConfig.fsConf, this.easyConfig.extensions, this.easyConfig.compressible);
        }
    }

    @Override
    public Configuration getFsConf() {
        return this.easyConfig.getFsConf();
    }

    @Override
    public DrillbitContext getContext() {
        return this.context;
    }

    public EasyFormatConfig easyConfig() {
        return this.easyConfig;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean supportsLimitPushdown() {
        return this.easyConfig.supportsLimitPushdown();
    }

    public boolean supportsPushDown() {
        return this.easyConfig.supportsProjectPushdown();
    }

    public boolean supportsFileImplicitColumns() {
        return this.easyConfig.supportsFileImplicitColumns();
    }

    public boolean isBlockSplittable() {
        return this.easyConfig.isBlockSplittable();
    }

    public boolean isCompressible() {
        return this.easyConfig.isCompressible();
    }

    public RecordReader getRecordReader(FragmentContext context, DrillFileSystem dfs, FileWork fileWork, List<SchemaPath> columns, String userName) throws ExecutionSetupException {
        throw new ExecutionSetupException("Must implement getRecordReader() if using the legacy scanner.");
    }

    protected CloseableRecordBatch getReaderBatch(FragmentContext context, EasySubScan scan) throws ExecutionSetupException {
        try {
            switch (this.scanVersion(context.getOptions())) {
                case CLASSIC: {
                    return this.buildScanBatch(context, scan);
                }
                case EVF_V1: {
                    return this.buildScan(context, scan);
                }
                case EVF_V2: {
                    return this.buildScanV3(context, scan);
                }
            }
            throw new IllegalStateException("Unknown scan version");
        }
        catch (UserException e) {
            throw e;
        }
        catch (ExecutionSetupException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ExecutionSetupException(e);
        }
    }

    protected ScanFrameworkVersion scanVersion(OptionSet options) {
        return this.easyConfig.scanVersion;
    }

    private CloseableRecordBatch buildScanBatch(FragmentContext context, EasySubScan scan) throws ExecutionSetupException {
        return new ClassicScanBuilder(context, scan, this).build();
    }

    private CloseableRecordBatch buildScan(FragmentContext context, EasySubScan scan) throws ExecutionSetupException {
        return new EvfV1ScanBuilder(context, scan, this).build();
    }

    protected void initScanBuilder(FileScanFramework.FileScanBuilder builder, EasySubScan scan) {
        EvfV1ScanBuilder.initScanBuilder(this, builder, scan);
    }

    public ManagedReader<? extends FileScanFramework.FileSchemaNegotiator> newBatchReader(EasySubScan scan, OptionSet options) throws ExecutionSetupException {
        throw new ExecutionSetupException("Must implement newBatchReader() if using the enhanced framework.");
    }

    protected FileScanFramework.FileScanBuilder frameworkBuilder(EasySubScan scan, OptionSet options) throws ExecutionSetupException {
        throw new ExecutionSetupException("Must implement frameworkBuilder() if using the enhanced framework.");
    }

    private CloseableRecordBatch buildScanV3(FragmentContext context, EasySubScan scan) throws ExecutionSetupException {
        EasyFileScanBuilder builder = new EasyFileScanBuilder(context, scan, this);
        this.configureScan(builder, scan);
        return builder.buildScanOperator(context, scan);
    }

    protected void configureScan(FileScanLifecycleBuilder builder, EasySubScan scan) {
        throw new UnsupportedOperationException("Implement this method if you use EVF V2");
    }

    public boolean isStatisticsRecordWriter(FragmentContext context, EasyWriter writer) {
        return false;
    }

    public RecordWriter getRecordWriter(FragmentContext context, EasyWriter writer) throws IOException {
        throw new UnsupportedOperationException("unimplemented");
    }

    public StatisticsRecordWriter getStatisticsRecordWriter(FragmentContext context, EasyWriter writer) throws IOException {
        return null;
    }

    public CloseableRecordBatch getWriterBatch(FragmentContext context, RecordBatch incoming, EasyWriter writer) throws ExecutionSetupException {
        try {
            if (this.isStatisticsRecordWriter(context, writer)) {
                return new StatisticsWriterRecordBatch(writer, incoming, context, this.getStatisticsRecordWriter(context, writer));
            }
            return new WriterRecordBatch(writer, incoming, context, this.getRecordWriter(context, writer));
        }
        catch (IOException e) {
            throw new ExecutionSetupException(String.format("Failed to create the WriterRecordBatch. %s", e.getMessage()), e);
        }
    }

    protected ScanStats getScanStats(PlannerSettings settings, EasyGroupScan scan) {
        long data = 0L;
        for (CompleteFileWork work : scan.getWorkIterable()) {
            data += work.getTotalBytes();
        }
        long estRowCount = data / 1024L;
        return new ScanStats(ScanStats.GroupScanProperty.NO_EXACT_ROW_COUNT, estRowCount, 1.0, data);
    }

    @Override
    public AbstractWriter getWriter(PhysicalOperator child, String location, List<String> partitionColumns) {
        return new EasyWriter(child, location, partitionColumns, this);
    }

    @Override
    public AbstractGroupScan getGroupScan(String userName, FileSelection selection, List<SchemaPath> columns) throws IOException {
        return new EasyGroupScan(userName, selection, this, columns, selection.selectionRoot, null);
    }

    @Override
    public AbstractGroupScan getGroupScan(String userName, FileSelection selection, List<SchemaPath> columns, MetadataProviderManager metadataProviderManager) throws IOException {
        return new EasyGroupScan(userName, selection, this, columns, selection.selectionRoot, metadataProviderManager);
    }

    public T getConfig() {
        return this.formatConfig;
    }

    @Override
    public StoragePluginConfig getStorageConfig() {
        return this.storageConfig;
    }

    @Override
    public boolean supportsRead() {
        return this.easyConfig.isReadable();
    }

    @Override
    public boolean supportsWrite() {
        return this.easyConfig.isWritable();
    }

    @Override
    public boolean supportsAutoPartitioning() {
        return this.easyConfig.supportsAutoPartitioning();
    }

    @Override
    public FormatMatcher getMatcher() {
        return this.easyConfig.getMatcher();
    }

    public Set<StoragePluginOptimizerRule> getOptimizerRules() {
        return ImmutableSet.of();
    }

    public String getReaderOperatorType() {
        return this.easyConfig.getReaderOperatorType();
    }

    public String getWriterOperatorType() {
        return this.easyConfig.getWriterOperatorType();
    }

    @Override
    public boolean supportsStatistics() {
        return this.easyConfig.supportsStatistics();
    }

    @Override
    public DrillStatsTable.TableStatistics readStatistics(FileSystem fs, Path statsTablePath) throws IOException {
        throw new UnsupportedOperationException("unimplemented");
    }

    @Override
    public void writeStatistics(DrillStatsTable.TableStatistics statistics, FileSystem fs, Path statsTablePath) throws IOException {
        throw new UnsupportedOperationException("unimplemented");
    }

    public static class EasyFormatConfig {
        private BasicFormatMatcher matcher;
        private final boolean readable;
        private final boolean writable;
        private final boolean blockSplittable;
        private final boolean compressible;
        private final Configuration fsConf;
        private final List<String> extensions;
        private final String defaultName;
        private final boolean supportsLimitPushdown;
        private final boolean supportsProjectPushdown;
        private final boolean supportsFileImplicitColumns;
        private final boolean supportsAutoPartitioning;
        private final boolean supportsStatistics;
        private final String readerOperatorType;
        private final String writerOperatorType;
        private final ScanFrameworkVersion scanVersion;

        public EasyFormatConfig(EasyFormatConfigBuilder builder) {
            this.matcher = builder.matcher;
            this.readable = builder.readable;
            this.writable = builder.writable;
            this.blockSplittable = builder.blockSplittable;
            this.compressible = builder.compressible;
            this.fsConf = builder.fsConf;
            this.extensions = builder.extensions;
            this.defaultName = builder.defaultName;
            this.supportsLimitPushdown = builder.supportsLimitPushdown;
            this.supportsProjectPushdown = builder.supportsProjectPushdown;
            this.supportsFileImplicitColumns = builder.supportsFileImplicitColumns;
            this.supportsAutoPartitioning = builder.supportsAutoPartitioning;
            this.supportsStatistics = builder.supportsStatistics;
            this.readerOperatorType = builder.readerOperatorType;
            this.writerOperatorType = builder.writerOperatorType;
            this.scanVersion = builder.scanVersion;
        }

        public BasicFormatMatcher getMatcher() {
            return this.matcher;
        }

        public boolean isReadable() {
            return this.readable;
        }

        public boolean isWritable() {
            return this.writable;
        }

        public boolean isBlockSplittable() {
            return this.blockSplittable;
        }

        public boolean isCompressible() {
            return this.compressible;
        }

        public Configuration getFsConf() {
            return this.fsConf;
        }

        public List<String> getExtensions() {
            return this.extensions;
        }

        public String getDefaultName() {
            return this.defaultName;
        }

        public boolean supportsLimitPushdown() {
            return this.supportsLimitPushdown;
        }

        public boolean supportsProjectPushdown() {
            return this.supportsProjectPushdown;
        }

        public boolean supportsFileImplicitColumns() {
            return this.supportsFileImplicitColumns;
        }

        public boolean supportsAutoPartitioning() {
            return this.supportsAutoPartitioning;
        }

        public boolean supportsStatistics() {
            return this.supportsStatistics;
        }

        public String getReaderOperatorType() {
            return this.readerOperatorType;
        }

        public String getWriterOperatorType() {
            return this.writerOperatorType;
        }

        public ScanFrameworkVersion scanVersion() {
            return this.scanVersion;
        }

        public static EasyFormatConfigBuilder builder() {
            return new EasyFormatConfigBuilder();
        }

        public EasyFormatConfigBuilder toBuilder() {
            return EasyFormatConfig.builder().matcher(this.matcher).readable(this.readable).writable(this.writable).blockSplittable(this.blockSplittable).compressible(this.compressible).fsConf(this.fsConf).extensions(this.extensions).defaultName(this.defaultName).supportsLimitPushdown(this.supportsLimitPushdown).supportsProjectPushdown(this.supportsProjectPushdown).supportsFileImplicitColumns(this.supportsFileImplicitColumns).supportsAutoPartitioning(this.supportsAutoPartitioning).supportsStatistics(this.supportsStatistics).readerOperatorType(this.readerOperatorType).writerOperatorType(this.writerOperatorType).scanVersion(this.scanVersion);
        }
    }

    public static class EasyFormatConfigBuilder {
        private BasicFormatMatcher matcher;
        private boolean readable = true;
        private boolean writable;
        private boolean blockSplittable;
        private boolean compressible;
        private Configuration fsConf;
        private List<String> extensions;
        private String defaultName;
        private boolean supportsLimitPushdown;
        private boolean supportsProjectPushdown;
        private boolean supportsFileImplicitColumns = true;
        private boolean supportsAutoPartitioning;
        private boolean supportsStatistics;
        private String readerOperatorType;
        private String writerOperatorType = "";
        private ScanFrameworkVersion scanVersion = ScanFrameworkVersion.CLASSIC;

        public EasyFormatConfigBuilder matcher(BasicFormatMatcher matcher) {
            this.matcher = matcher;
            return this;
        }

        public EasyFormatConfigBuilder readable(boolean readable) {
            this.readable = readable;
            return this;
        }

        public EasyFormatConfigBuilder writable(boolean writable) {
            this.writable = writable;
            return this;
        }

        public EasyFormatConfigBuilder blockSplittable(boolean blockSplittable) {
            this.blockSplittable = blockSplittable;
            return this;
        }

        public EasyFormatConfigBuilder compressible(boolean compressible) {
            this.compressible = compressible;
            return this;
        }

        public EasyFormatConfigBuilder fsConf(Configuration fsConf) {
            this.fsConf = fsConf;
            return this;
        }

        public EasyFormatConfigBuilder extensions(List<String> extensions) {
            this.extensions = extensions;
            return this;
        }

        public EasyFormatConfigBuilder extensions(String ... extensions) {
            this.extensions = Arrays.asList(extensions);
            return this;
        }

        public EasyFormatConfigBuilder defaultName(String defaultName) {
            this.defaultName = defaultName;
            return this;
        }

        public EasyFormatConfigBuilder supportsLimitPushdown(boolean supportsLimitPushdown) {
            this.supportsLimitPushdown = supportsLimitPushdown;
            return this;
        }

        public EasyFormatConfigBuilder supportsProjectPushdown(boolean supportsProjectPushdown) {
            this.supportsProjectPushdown = supportsProjectPushdown;
            return this;
        }

        public EasyFormatConfigBuilder supportsFileImplicitColumns(boolean supportsFileImplicitColumns) {
            this.supportsFileImplicitColumns = supportsFileImplicitColumns;
            return this;
        }

        public EasyFormatConfigBuilder supportsAutoPartitioning(boolean supportsAutoPartitioning) {
            this.supportsAutoPartitioning = supportsAutoPartitioning;
            return this;
        }

        public EasyFormatConfigBuilder supportsStatistics(boolean supportsStatistics) {
            this.supportsStatistics = supportsStatistics;
            return this;
        }

        public EasyFormatConfigBuilder readerOperatorType(String readerOperatorType) {
            this.readerOperatorType = readerOperatorType;
            return this;
        }

        public EasyFormatConfigBuilder writerOperatorType(String writerOperatorType) {
            this.writerOperatorType = writerOperatorType;
            return this;
        }

        public EasyFormatConfigBuilder scanVersion(ScanFrameworkVersion scanVersion) {
            this.scanVersion = scanVersion;
            return this;
        }

        public EasyFormatConfig build() {
            Objects.requireNonNull(this.defaultName, "defaultName is not set");
            this.readerOperatorType = this.readerOperatorType == null ? this.defaultName.toUpperCase(Locale.ROOT) + "_SUB_SCAN" : this.readerOperatorType;
            return new EasyFormatConfig(this);
        }
    }

    public static enum ScanFrameworkVersion {
        CLASSIC,
        EVF_V1,
        EVF_V2;

    }
}

