/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.dfs.easy;

import org.apache.drill.common.exceptions.CustomErrorContext;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.impl.scan.v3.file.FileScanLifecycleBuilder;
import org.apache.drill.exec.store.dfs.easy.EasyFormatPlugin;
import org.apache.drill.exec.store.dfs.easy.EasySubScan;

public class EasyFileScanBuilder
extends FileScanLifecycleBuilder {
    public EasyFileScanBuilder(FragmentContext context, EasySubScan scan, EasyFormatPlugin<? extends FormatPluginConfig> plugin) {
        this.options(context.getOptions());
        this.projection(scan.getColumns());
        this.userName(scan.getUserName());
        this.providedSchema(scan.getSchema());
        this.fileSystemConfig(plugin.getFsConf());
        this.fileSplitImpls(scan.getWorkUnits());
        this.rootDir(scan.getSelectionRoot());
        this.maxPartitionDepth(scan.getPartitionDepth());
        this.compressible(plugin.easyConfig().isCompressible());
        this.limit(scan.getLimit());
        this.errorContext(new EvfErrorContext(scan, plugin));
    }

    public static class EvfErrorContext
    implements CustomErrorContext {
        private final EasySubScan scan;
        private final EasyFormatPlugin<? extends FormatPluginConfig> plugin;

        public EvfErrorContext(EasySubScan scan, EasyFormatPlugin<? extends FormatPluginConfig> plugin) {
            this.scan = scan;
            this.plugin = plugin;
        }

        @Override
        public void addContext(UserException.Builder builder) {
            builder.addContext("Format plugin type", this.plugin.easyConfig().getDefaultName()).addContext("Format plugin class", this.plugin.getClass().getSimpleName()).addContext("Plugin config name", this.plugin.getName());
            if (this.scan.getSelectionRoot() != null) {
                builder.addContext("Table directory", this.scan.getSelectionRoot().toString());
            }
        }
    }
}

