/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.dfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.DefaultCodec;

public class ZipCodec
extends DefaultCodec {
    private static final String EXTENSION = ".zip";

    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return new ZipCompressionOutputStream(new ResetableZipOutputStream(out));
    }

    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return new ZipCompressionInputStream(new ZipInputStream(in));
    }

    public String getDefaultExtension() {
        return EXTENSION;
    }

    private static class ZipCompressionOutputStream
    extends CompressionOutputStream {
        private static final String DEFAULT_ENTRY_NAME = "entry.out";

        ZipCompressionOutputStream(ResetableZipOutputStream out) throws IOException {
            super((OutputStream)out);
            ZipEntry zipEntry = new ZipEntry(DEFAULT_ENTRY_NAME);
            out.putNextEntry(zipEntry);
        }

        public void write(int b) throws IOException {
            this.out.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        public void finish() throws IOException {
            ((ResetableZipOutputStream)this.out).closeEntry();
        }

        public void resetState() {
            ((ResetableZipOutputStream)this.out).resetState();
        }
    }

    private static class ResetableZipOutputStream
    extends ZipOutputStream {
        ResetableZipOutputStream(OutputStream out) {
            super(out);
        }

        void resetState() {
            this.def.reset();
        }
    }

    private static class ZipCompressionInputStream
    extends CompressionInputStream {
        ZipCompressionInputStream(ZipInputStream in) throws IOException {
            super((InputStream)in);
            in.getNextEntry();
        }

        public int read() throws IOException {
            return this.in.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.in.read(b, off, len);
        }

        public void resetState() throws IOException {
            this.in.reset();
        }

        public void close() throws IOException {
            try {
                ((ZipInputStream)this.in).closeEntry();
            }
            finally {
                super.close();
            }
        }
    }
}

