/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.dfs;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Table;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.common.scanner.persistence.ScanResult;
import org.apache.drill.common.util.DrillStringUtils;
import org.apache.drill.exec.dotdrill.DotDrillFile;
import org.apache.drill.exec.dotdrill.DotDrillType;
import org.apache.drill.exec.dotdrill.DotDrillUtil;
import org.apache.drill.exec.dotdrill.View;
import org.apache.drill.exec.metastore.MetadataProviderManager;
import org.apache.drill.exec.metastore.MetastoreMetadataProviderManager;
import org.apache.drill.exec.metastore.store.FileSystemMetadataProviderManager;
import org.apache.drill.exec.planner.common.DrillStatsTable;
import org.apache.drill.exec.planner.logical.CreateTableEntry;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.logical.DrillTableSelection;
import org.apache.drill.exec.planner.logical.DrillViewTable;
import org.apache.drill.exec.planner.logical.DynamicDrillTable;
import org.apache.drill.exec.planner.logical.FileSystemCreateTableEntry;
import org.apache.drill.exec.planner.sql.ExpandingConcurrentMap;
import org.apache.drill.exec.planner.sql.SchemaUtilities;
import org.apache.drill.exec.record.metadata.schema.FsMetastoreSchemaProvider;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.PartitionNotFoundException;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.StorageStrategy;
import org.apache.drill.exec.store.dfs.BasicFormatMatcher;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.store.dfs.FileSelection;
import org.apache.drill.exec.store.dfs.FileSystemConfig;
import org.apache.drill.exec.store.dfs.FileSystemPlugin;
import org.apache.drill.exec.store.dfs.FormatLocationTransformer;
import org.apache.drill.exec.store.dfs.FormatMatcher;
import org.apache.drill.exec.store.dfs.FormatPlugin;
import org.apache.drill.exec.store.dfs.FormatPluginOptionExtractor;
import org.apache.drill.exec.store.dfs.FormatSelection;
import org.apache.drill.exec.store.dfs.SubDirectoryList;
import org.apache.drill.exec.store.dfs.WorkspaceConfig;
import org.apache.drill.exec.store.table.function.TableParamDef;
import org.apache.drill.exec.store.table.function.TableSignature;
import org.apache.drill.exec.store.table.function.WithOptionsTableMacro;
import org.apache.drill.exec.util.DrillFileSystemUtil;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.drill.metastore.MetastoreRegistry;
import org.apache.drill.metastore.components.tables.MetastoreTableInfo;
import org.apache.drill.metastore.exceptions.MetastoreException;
import org.apache.drill.metastore.metadata.TableInfo;
import org.apache.drill.shaded.guava.com.google.common.base.Joiner;
import org.apache.drill.shaded.guava.com.google.common.base.Strings;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.AccessControlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceSchemaFactory {
    private static final Logger logger = LoggerFactory.getLogger(WorkspaceSchemaFactory.class);
    private final List<FormatMatcher> fileMatchers;
    private final List<FormatMatcher> dropFileMatchers;
    private final List<FormatMatcher> dirMatchers;
    private final List<FormatLocationTransformer> formatLocationTransformers;
    private final WorkspaceConfig config;
    private final Configuration fsConf;
    private final String storageEngineName;
    private final String schemaName;
    private final FileSystemPlugin plugin;
    private final ObjectMapper mapper;
    private final Path wsPath;
    private final FormatPluginOptionExtractor optionExtractor;

    public WorkspaceSchemaFactory(FileSystemPlugin plugin, String schemaName, String storageEngineName, WorkspaceConfig config, List<FormatMatcher> formatMatchers, ObjectMapper mapper, ScanResult scanResult) throws ExecutionSetupException {
        this.mapper = mapper;
        this.fsConf = plugin.getFsConf();
        this.plugin = plugin;
        this.config = config;
        this.fileMatchers = new ArrayList<FormatMatcher>();
        this.dirMatchers = new ArrayList<FormatMatcher>();
        this.formatLocationTransformers = new ArrayList<FormatLocationTransformer>();
        this.storageEngineName = storageEngineName;
        this.schemaName = schemaName;
        this.wsPath = new Path(config.getLocation());
        this.optionExtractor = new FormatPluginOptionExtractor(scanResult);
        for (FormatMatcher m : formatMatchers) {
            if (m.supportDirectoryReads()) {
                this.dirMatchers.add(m);
            }
            this.fileMatchers.add(m);
            FormatLocationTransformer transformer = m.getFormatLocationTransformer();
            if (transformer == null) continue;
            this.formatLocationTransformers.add(transformer);
        }
        String defaultInputFormat = config.getDefaultInputFormat();
        if (!Strings.isNullOrEmpty(defaultInputFormat)) {
            FormatPlugin formatPlugin = plugin.getFormatPlugin(defaultInputFormat);
            if (formatPlugin == null) {
                String message = String.format("Unable to find default input format[%s] for workspace[%s.%s]", defaultInputFormat, storageEngineName, schemaName);
                throw new ExecutionSetupException(message);
            }
            BasicFormatMatcher fallbackMatcher = new BasicFormatMatcher(formatPlugin, ImmutableList.of(Pattern.compile(".*")), ImmutableList.of());
            this.fileMatchers.add(fallbackMatcher);
            this.dropFileMatchers = this.fileMatchers.subList(0, this.fileMatchers.size() - 1);
        } else {
            this.dropFileMatchers = this.fileMatchers.subList(0, this.fileMatchers.size());
        }
    }

    public boolean accessible(String userName) throws IOException {
        DrillFileSystem fs = ImpersonationUtil.createFileSystem(userName, this.fsConf);
        return this.accessible(fs);
    }

    public boolean accessible(DrillFileSystem fs) throws IOException {
        try {
            if (SystemUtils.IS_OS_WINDOWS && fs.getUri().getScheme().equalsIgnoreCase("file")) {
                fs.listStatus(this.wsPath);
            } else {
                fs.access(this.wsPath, FsAction.READ);
            }
        }
        catch (UnsupportedOperationException e) {
            logger.trace("The filesystem for this workspace does not support this operation.", (Throwable)e);
        }
        catch (FileNotFoundException | AccessControlException e) {
            return false;
        }
        return true;
    }

    private Path getViewPath(String name) {
        return DotDrillType.VIEW.getPath(this.config.getLocation(), name);
    }

    public WorkspaceSchema createSchema(List<String> parentSchemaPath, SchemaConfig schemaConfig, DrillFileSystem fs) throws IOException {
        if (!this.accessible(fs)) {
            return null;
        }
        return new WorkspaceSchema(parentSchemaPath, this.schemaName, schemaConfig, fs, this.config);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public FileSystemPlugin getPlugin() {
        return this.plugin;
    }

    private static void ensureNotStatsTable(String tableName) {
        if (tableName.toLowerCase().endsWith(DotDrillType.STATS.getEnding())) {
            throw UserException.validationError().message("Given table [%s] is already a stats table. Cannot perform stats operations on a stats table.", tableName).build(logger);
        }
    }

    private static Object[] array(Object ... objects) {
        return objects;
    }

    public class WorkspaceSchema
    extends AbstractSchema
    implements ExpandingConcurrentMap.MapValueFactory<TableInstance, DrillTable> {
        private final ExpandingConcurrentMap<TableInstance, DrillTable> tables;
        private final SchemaConfig schemaConfig;
        private final DrillFileSystem fs;
        private final DrillFileSystem dpsFs;
        private final WorkspaceConfig wsConfig;

        public WorkspaceSchema(List<String> parentSchemaPath, String wsName, SchemaConfig schemaConfig, DrillFileSystem fs, WorkspaceConfig config) {
            super(parentSchemaPath, wsName);
            this.tables = new ExpandingConcurrentMap<TableInstance, DrillTable>(this);
            this.schemaConfig = schemaConfig;
            this.fs = fs;
            this.dpsFs = ImpersonationUtil.createFileSystem(ImpersonationUtil.getProcessUserName(), WorkspaceSchemaFactory.this.fsConf);
            this.wsConfig = config;
        }

        DrillTable getDrillTable(TableInstance key) {
            return this.tables.get(key);
        }

        @Override
        public boolean createView(View view) throws IOException {
            Path viewPath = WorkspaceSchemaFactory.this.getViewPath(view.getName());
            boolean replaced = this.getFS().exists(viewPath);
            FsPermission viewPerms = new FsPermission(this.schemaConfig.getOption((String)"new_view_default_permissions").string_val);
            try (FSDataOutputStream stream = DrillFileSystem.create((FileSystem)this.getFS(), (Path)viewPath, (FsPermission)viewPerms);){
                WorkspaceSchemaFactory.this.mapper.writeValue((OutputStream)stream, (Object)view);
            }
            return replaced;
        }

        @Override
        public Iterable<String> getSubPartitions(String table, List<String> partitionColumns, List<String> partitionValues) throws PartitionNotFoundException {
            List<FileStatus> fileStatuses;
            try {
                fileStatuses = DrillFileSystemUtil.listDirectories(this.getFS(), new Path(this.getDefaultLocation(), table), false, new PathFilter[0]);
            }
            catch (IOException e) {
                throw new PartitionNotFoundException("Error finding partitions for table " + table, e);
            }
            return new SubDirectoryList(fileStatuses);
        }

        @Override
        public void dropView(String viewName) throws IOException {
            this.getFS().delete(WorkspaceSchemaFactory.this.getViewPath(viewName), false);
        }

        private Set<String> getViews() {
            HashSet<String> viewSet = Sets.newHashSet();
            try {
                List<DotDrillFile> files = DotDrillUtil.getDotDrills(this.getFS(), new Path(WorkspaceSchemaFactory.this.config.getLocation()), DotDrillType.VIEW);
                for (DotDrillFile f : files) {
                    viewSet.add(f.getBaseName());
                }
            }
            catch (UnsupportedOperationException e) {
                logger.debug("The filesystem for this workspace does not support this operation.", (Throwable)e);
            }
            catch (AccessControlException e) {
                if (!this.schemaConfig.getIgnoreAuthErrors()) {
                    logger.debug(e.getMessage());
                    throw UserException.permissionError(e).message("Not authorized to list view tables in schema [%s]", this.getFullSchemaName()).build(logger);
                }
            }
            catch (Exception e) {
                logger.warn("Failure while trying to list .view.drill files in workspace [{}]", (Object)this.getFullSchemaName(), (Object)e);
            }
            return viewSet;
        }

        private Set<String> rawTableNames() {
            return this.tables.keySet().stream().map(input -> input.sig.getName()).collect(Collectors.toSet());
        }

        @Override
        public Set<String> getTableNames() {
            return Sets.union(this.rawTableNames(), this.getViews());
        }

        @Override
        public Set<String> getFunctionNames() {
            return this.rawTableNames();
        }

        public List<Function> getFunctions(String name) {
            ArrayList<Function> functions = new ArrayList<Function>(super.getFunctions(name));
            List<TableParamDef> tableParameters = this.getFunctionParameters();
            List<TableSignature> signatures = WorkspaceSchemaFactory.this.optionExtractor.getTableSignatures(name, tableParameters);
            signatures.stream().map(signature -> new WithOptionsTableMacro((TableSignature)signature, params -> this.getDrillTable(new TableInstance((TableSignature)signature, (List<Object>)params)))).forEach(functions::add);
            return functions;
        }

        private View getView(DotDrillFile f) throws IOException {
            assert (f.getType() == DotDrillType.VIEW);
            return f.getView(WorkspaceSchemaFactory.this.mapper);
        }

        private String getTemporaryName(String name) {
            if (this.isTemporaryWorkspace()) {
                String tableName = DrillStringUtils.removeLeadingSlash(name);
                return this.schemaConfig.getTemporaryTableName(tableName);
            }
            return null;
        }

        private boolean isTemporaryWorkspace() {
            return SchemaUtilities.getSchemaPath(this.schemaPath).equals(this.schemaConfig.getTemporaryWorkspace());
        }

        @Override
        public Table getTable(String tableName) {
            TableInstance tableKey;
            String temporaryName = this.getTemporaryName(tableName);
            if (temporaryName != null) {
                tableName = temporaryName;
            }
            if (this.tables.alreadyContainsKey(tableKey = new TableInstance(TableSignature.of(tableName), ImmutableList.of()))) {
                return this.tables.get(tableKey);
            }
            List<Object> files = Collections.emptyList();
            try {
                try {
                    files = DotDrillUtil.getDotDrills(this.getFS(), new Path(WorkspaceSchemaFactory.this.config.getLocation()), DrillStringUtils.removeLeadingSlash(tableName), DotDrillType.VIEW);
                }
                catch (AccessControlException e) {
                    if (!this.schemaConfig.getIgnoreAuthErrors()) {
                        logger.debug(e.getMessage());
                        throw UserException.permissionError(e).message("Not authorized to list or query tables in schema [%s]", this.getFullSchemaName()).build(logger);
                    }
                }
                catch (IOException e) {
                    logger.warn("Failure while trying to list view tables in workspace [{}]", (Object)this.getFullSchemaName(), (Object)e);
                }
                block11: for (DotDrillFile f : files) {
                    switch (f.getType()) {
                        case VIEW: {
                            try {
                                return new DrillViewTable(this.getView(f), f.getOwner(), this.schemaConfig.getViewExpansionContext());
                            }
                            catch (AccessControlException e) {
                                if (this.schemaConfig.getIgnoreAuthErrors()) continue block11;
                                logger.debug(e.getMessage());
                                throw UserException.permissionError(e).message("Not authorized to read view [%s] in schema [%s]", tableName, this.getFullSchemaName()).build(logger);
                            }
                            catch (IOException e) {
                                logger.warn("Failure while trying to load {}.view.drill file in workspace [{}]", new Object[]{tableName, this.getFullSchemaName(), e});
                            }
                        }
                    }
                }
            }
            catch (UnsupportedOperationException e) {
                logger.debug("The filesystem for this workspace does not support this operation.", (Throwable)e);
            }
            DrillTable table = this.tables.get(tableKey);
            this.setMetadataProviderManager(table, tableName);
            return table;
        }

        private void setSchema(MetadataProviderManager providerManager, String tableName) {
            if (this.schemaConfig.getOption((String)"store.table.use_schema_file").bool_val.booleanValue()) {
                try {
                    FsMetastoreSchemaProvider schemaProvider = new FsMetastoreSchemaProvider(this, tableName);
                    providerManager.setSchemaProvider(schemaProvider);
                }
                catch (IOException e) {
                    logger.debug("Unable to init schema provider for table [{}]", (Object)tableName, (Object)e);
                }
            }
        }

        private void setMetadataTable(MetadataProviderManager metadataProviderManager, DrillTable table, String tableName) {
            if (tableName.toLowerCase().endsWith(DotDrillType.STATS.getEnding())) {
                return;
            }
            try {
                String statsTableName = this.getStatsTableName(tableName);
                Path statsTableFilePath = this.getStatsTableFilePath(tableName);
                metadataProviderManager.setStatsProvider(new DrillStatsTable(table, this.getFullSchemaName(), statsTableName, statsTableFilePath, this.fs));
            }
            catch (Exception e) {
                logger.warn("Failed to find the stats table for table [{}] in schema [{}]", (Object)tableName, (Object)this.getFullSchemaName());
            }
        }

        private String getStatsTableName(String tableName) {
            Path tablePath = new Path(WorkspaceSchemaFactory.this.config.getLocation(), tableName);
            try {
                String name;
                if (this.dpsFs.isDirectory(tablePath) ? this.dpsFs.isDirectory(new Path(name = tableName + "/" + DotDrillType.STATS.getEnding())) : this.dpsFs.isFile(new Path(name = tableName + DotDrillType.STATS.getEnding()))) {
                    return name;
                }
                return name;
            }
            catch (Exception e) {
                throw new DrillRuntimeException(String.format("Failed to find the stats for table [%s] in schema [%s]", tableName, this.getFullSchemaName()));
            }
        }

        private Path getStatsTableFilePath(String tableName) {
            Path tablePath = new Path(WorkspaceSchemaFactory.this.config.getLocation(), tableName);
            try {
                Path stFPath = null;
                if (this.dpsFs.isDirectory(tablePath) && this.dpsFs.isFile(stFPath = new Path(tablePath, DotDrillType.STATS.getEnding() + "/" + "0_0.json"))) {
                    return stFPath;
                }
                return stFPath;
            }
            catch (Exception e) {
                throw new DrillRuntimeException(String.format("Failed to find the the stats for table [%s] in schema [%s]", tableName, this.getFullSchemaName()));
            }
        }

        @Override
        public boolean isMutable() {
            return WorkspaceSchemaFactory.this.config.isWritable();
        }

        public DrillFileSystem getFS() {
            return this.fs;
        }

        public String getDefaultLocation() {
            return WorkspaceSchemaFactory.this.config.getLocation();
        }

        @Override
        public CreateTableEntry createNewTable(String tableName, List<String> partitionColumns, StorageStrategy storageStrategy) {
            String storage = this.schemaConfig.getOption((String)"store.format").string_val;
            FormatPlugin formatPlugin = WorkspaceSchemaFactory.this.plugin.getFormatPlugin(storage);
            return this.createOrAppendToTable(tableName, formatPlugin, partitionColumns, storageStrategy);
        }

        @Override
        public CreateTableEntry createStatsTable(String tableName) {
            WorkspaceSchemaFactory.ensureNotStatsTable(tableName);
            String statsTableName = this.getStatsTableName(tableName);
            FormatPlugin formatPlugin = WorkspaceSchemaFactory.this.plugin.getFormatPlugin("json");
            return this.createOrAppendToTable(statsTableName, formatPlugin, Collections.emptyList(), StorageStrategy.DEFAULT);
        }

        @Override
        public CreateTableEntry appendToStatsTable(String tableName) {
            WorkspaceSchemaFactory.ensureNotStatsTable(tableName);
            String statsTableName = this.getStatsTableName(tableName);
            FormatPlugin formatPlugin = WorkspaceSchemaFactory.this.plugin.getFormatPlugin("json");
            return this.createOrAppendToTable(statsTableName, formatPlugin, Collections.emptyList(), StorageStrategy.DEFAULT);
        }

        @Override
        public Table getStatsTable(String tableName) {
            return this.getTable(this.getStatsTableName(tableName));
        }

        private CreateTableEntry createOrAppendToTable(String tableName, FormatPlugin formatPlugin, List<String> partitionColumns, StorageStrategy storageStrategy) {
            if (formatPlugin == null) {
                throw new UnsupportedOperationException(String.format("Unsupported format '%s' in workspace '%s'", WorkspaceSchemaFactory.this.config.getDefaultInputFormat(), Joiner.on(".").join(this.getSchemaPath())));
            }
            return new FileSystemCreateTableEntry((FileSystemConfig)WorkspaceSchemaFactory.this.plugin.getConfig(), formatPlugin, WorkspaceSchemaFactory.this.config.getLocation() + "/" + tableName, partitionColumns, storageStrategy);
        }

        @Override
        public String getTypeName() {
            return "file";
        }

        @Override
        public DrillTable create(TableInstance key) {
            try {
                FileSelectionInspector inspector = new FileSelectionInspector(key);
                if (inspector.fileSelection == null) {
                    return null;
                }
                DrillTable table = inspector.matchFormat();
                if (key.sig.getParams().size() == 0) {
                    return table;
                }
                return this.parseTableFunction(key, inspector, table);
            }
            catch (AccessControlException e) {
                if (!this.schemaConfig.getIgnoreAuthErrors()) {
                    logger.debug(e.getMessage());
                    throw UserException.permissionError(e).message("Not authorized to read table [%s] in schema [%s]", key, this.getFullSchemaName()).build(logger);
                }
            }
            catch (IOException e) {
                logger.debug("Failed to create DrillTable with root {} and name {}", new Object[]{WorkspaceSchemaFactory.this.config.getLocation(), key, e});
            }
            return null;
        }

        private DrillTable parseTableFunction(TableInstance key, FileSelectionInspector inspector, DrillTable table) {
            FileSelection newSelection = inspector.selection();
            if (newSelection.isEmptyDirectory()) {
                return new DynamicDrillTable(WorkspaceSchemaFactory.this.plugin, WorkspaceSchemaFactory.this.storageEngineName, this.schemaConfig.getUserName(), (DrillTableSelection)inspector.fileSelection);
            }
            FormatPluginConfig baseConfig = inspector.formatMatch == null ? null : inspector.formatMatch.getFormatPlugin().getConfig();
            FormatPluginConfig formatConfig = WorkspaceSchemaFactory.this.optionExtractor.createConfigForTable(key, WorkspaceSchemaFactory.this.mapper, baseConfig);
            FormatSelection selection = new FormatSelection(formatConfig, newSelection);
            DynamicDrillTable drillTable = new DynamicDrillTable(WorkspaceSchemaFactory.this.plugin, WorkspaceSchemaFactory.this.storageEngineName, this.schemaConfig.getUserName(), (DrillTableSelection)selection);
            this.setMetadataProviderManager(drillTable, key.sig.getName());
            List<TableParamDef> commonParams = key.sig.getCommonParams();
            if (commonParams.isEmpty()) {
                return drillTable;
            }
            List<Object> paramValues = key.params.subList(key.params.size() - commonParams.size(), key.params.size());
            return this.applyFunctionParameters(drillTable, commonParams, paramValues);
        }

        private FileSelection expandSelection(FileSelection fileSelection, boolean hasDirectories) throws IOException {
            FileSelection newSelection = hasDirectories ? (this.schemaConfig.getOption((String)"planner.enable_file_listing_limit0_optimization").bool_val != false ? fileSelection.selectAnyFile(this.getFS()) : fileSelection.minusDirectories(this.getFS())) : fileSelection;
            if (newSelection == null) {
                fileSelection.setEmptyDirectoryStatus();
                return fileSelection;
            }
            return newSelection;
        }

        private FormatMatcher findMatcher(FileStatus file) {
            try {
                for (FormatMatcher m : WorkspaceSchemaFactory.this.dropFileMatchers) {
                    if (!m.isFileReadable(this.getFS(), file)) continue;
                    return m;
                }
            }
            catch (IOException e) {
                logger.debug("Failed to find format matcher for file: {}", (Object)file, (Object)e);
            }
            return null;
        }

        private void setMetadataProviderManager(DrillTable table, String tableName) {
            if (table != null) {
                MetadataProviderManager providerManager = null;
                if (this.schemaConfig.getOption((String)"metastore.enabled").bool_val.booleanValue()) {
                    try {
                        MetastoreRegistry metastoreRegistry = WorkspaceSchemaFactory.this.plugin.getContext().getMetastoreRegistry();
                        TableInfo tableInfo = TableInfo.builder().storagePlugin(WorkspaceSchemaFactory.this.plugin.getName()).workspace(WorkspaceSchemaFactory.this.schemaName).name(tableName).build();
                        MetastoreTableInfo metastoreTableInfo = metastoreRegistry.get().tables().basicRequests().metastoreTableInfo(tableInfo);
                        if (metastoreTableInfo.isExists()) {
                            providerManager = new MetastoreMetadataProviderManager(metastoreRegistry, tableInfo, new MetastoreMetadataProviderManager.MetastoreMetadataProviderConfig(this.schemaConfig.getOption((String)"metastore.metadata.use_schema").bool_val, this.schemaConfig.getOption((String)"metastore.metadata.use_statistics").bool_val, this.schemaConfig.getOption((String)"metastore.metadata.fallback_to_file_metadata").bool_val));
                        }
                    }
                    catch (MetastoreException e) {
                        logger.warn("Exception happened during obtaining Metastore instance. File system metadata provider will be used.", (Throwable)e);
                    }
                }
                if (providerManager == null) {
                    providerManager = FileSystemMetadataProviderManager.init();
                }
                this.setMetadataTable(providerManager, table, tableName);
                this.setSchema(providerManager, tableName);
                table.setTableMetadataProviderManager(providerManager);
            }
        }

        @Override
        public void destroy(DrillTable value) {
        }

        private boolean isHomogeneous(String tableName) throws IOException {
            FileSelection fileSelection = FileSelection.create(this.getFS(), WorkspaceSchemaFactory.this.config.getLocation(), tableName, WorkspaceSchemaFactory.this.config.allowAccessOutsideWorkspace());
            if (fileSelection == null) {
                throw UserException.validationError().message(String.format("Table [%s] not found", tableName), new Object[0]).build(logger);
            }
            FormatMatcher matcher = null;
            LinkedList<FileStatus> listOfFiles = new LinkedList<FileStatus>(fileSelection.getStatuses(this.getFS()));
            while (!listOfFiles.isEmpty()) {
                FileStatus currentFile = (FileStatus)listOfFiles.poll();
                if (currentFile.isDirectory()) {
                    listOfFiles.addAll(DrillFileSystemUtil.listFiles(this.getFS(), currentFile.getPath(), true, new PathFilter[0]));
                    continue;
                }
                if (!(matcher != null ? !matcher.isFileReadable(this.getFS(), currentFile) : (matcher = this.findMatcher(currentFile)) == null)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void dropTable(String table) {
            DrillFileSystem fs = this.getFS();
            String defaultLocation = this.getDefaultLocation();
            try {
                if (!this.isHomogeneous(table)) {
                    throw UserException.validationError().message("Table contains different file formats. \nDrop Table is only supported for directories that contain homogeneous file formats consumable by Drill", new Object[0]).build(logger);
                }
                StringBuilder tableRenameBuilder = new StringBuilder();
                int lastSlashIndex = table.lastIndexOf("/");
                if (lastSlashIndex != -1) {
                    tableRenameBuilder.append(table, 0, lastSlashIndex + 1);
                }
                ThreadLocalRandom r = ThreadLocalRandom.current();
                long time = System.currentTimeMillis() / 1000L;
                long p1 = (Integer.MAX_VALUE - time << 32) + (long)r.nextInt();
                long p2 = r.nextLong();
                String fileNameDelimiter = "_";
                String[] pathSplit = table.split("/");
                tableRenameBuilder.append("_").append(pathSplit[pathSplit.length - 1]).append("_").append(p1).append("_").append(p2);
                String tableRename = tableRenameBuilder.toString();
                fs.rename(new Path(defaultLocation, table), new Path(defaultLocation, tableRename));
                fs.delete(new Path(defaultLocation, tableRename), true);
            }
            catch (AccessControlException e) {
                throw UserException.permissionError(e).message("Unauthorized to drop table", new Object[0]).build(logger);
            }
            catch (IOException e) {
                throw UserException.dataWriteError(e).message("Failed to drop table: " + e.getMessage(), new Object[0]).build(logger);
            }
        }

        public List<Map.Entry<String, Schema.TableType>> getTableNamesAndTypes() {
            return Stream.concat(this.tables.entrySet().stream().map(kv -> Pair.of((Object)((TableInstance)kv.getKey()).sig.getName(), (Object)((DrillTable)kv.getValue()).getJdbcTableType())), this.getViews().stream().map(viewName -> Pair.of((Object)viewName, (Object)Schema.TableType.VIEW))).collect(Collectors.toList());
        }

        private class FileSelectionInspector {
            private final TableInstance key;
            private final DrillFileSystem fs;
            public final FileSelection fileSelection;
            public final boolean hasDirectories;
            private FileSelection newSelection;
            public FormatMatcher formatMatch;

            public FileSelectionInspector(TableInstance key) throws IOException {
                this.key = key;
                this.fs = WorkspaceSchema.this.getFS();
                String path = key.sig.getName();
                FileSelection fileSelection = this.getFileSelection(path);
                if (fileSelection == null) {
                    fileSelection = WorkspaceSchemaFactory.this.formatLocationTransformers.stream().filter(t -> t.canTransform(path)).map(t -> t.transform(path, this::getFileSelection)).findFirst().orElse(null);
                }
                this.fileSelection = fileSelection;
                this.hasDirectories = fileSelection != null && fileSelection.containsDirectories(this.fs);
            }

            private FileSelection getFileSelection(String path) throws IOException {
                return FileSelection.create(this.fs, WorkspaceSchemaFactory.this.config.getLocation(), path, WorkspaceSchemaFactory.this.config.allowAccessOutsideWorkspace());
            }

            protected DrillTable matchFormat() throws IOException {
                DrillTable table;
                if (this.hasDirectories) {
                    for (FormatMatcher matcher : WorkspaceSchemaFactory.this.dirMatchers) {
                        try {
                            table = matcher.isReadable(WorkspaceSchema.this.getFS(), this.fileSelection, WorkspaceSchemaFactory.this.plugin, WorkspaceSchemaFactory.this.storageEngineName, WorkspaceSchema.this.schemaConfig);
                            if (table == null) continue;
                            this.formatMatch = matcher;
                            WorkspaceSchema.this.setMetadataProviderManager(table, this.key.sig.getName());
                            return table;
                        }
                        catch (IOException e) {
                            logger.debug("File read failed.", (Throwable)e);
                        }
                    }
                }
                this.newSelection = WorkspaceSchema.this.expandSelection(this.fileSelection, this.hasDirectories);
                if (this.newSelection.isEmptyDirectory()) {
                    if (WorkspaceSchema.this.wsConfig.getDefaultInputFormat() == null) {
                        throw UserException.validationError().message("No files were found and no default format is set on the queried workspace.", new Object[0]).addContext("workspace", Joiner.on(".").join(WorkspaceSchema.this.getSchemaPath())).addContext("table", this.key.sig.getName()).build(logger);
                    }
                    return new DynamicDrillTable(WorkspaceSchemaFactory.this.plugin, WorkspaceSchemaFactory.this.storageEngineName, WorkspaceSchema.this.schemaConfig.getUserName(), (DrillTableSelection)this.fileSelection);
                }
                for (FormatMatcher matcher : WorkspaceSchemaFactory.this.fileMatchers) {
                    table = matcher.isReadable(WorkspaceSchema.this.getFS(), this.newSelection, WorkspaceSchemaFactory.this.plugin, WorkspaceSchemaFactory.this.storageEngineName, WorkspaceSchema.this.schemaConfig);
                    if (table == null) continue;
                    this.formatMatch = matcher;
                    WorkspaceSchema.this.setMetadataProviderManager(table, this.key.sig.getName());
                    return table;
                }
                return null;
            }

            public FileSelection selection() {
                return this.newSelection != null ? this.newSelection : this.fileSelection;
            }
        }
    }

    public static final class TableInstance {
        final TableSignature sig;
        final List<Object> params;

        public TableInstance(TableSignature sig, List<Object> params) {
            if (params.size() != sig.getParams().size()) {
                throw UserException.parseError().message("should have as many params (%d) as signature (%d)", params.size(), sig.getParams().size()).addContext("table", sig.getName()).build(logger);
            }
            this.sig = sig;
            this.params = Collections.unmodifiableList(params);
        }

        String presentParams() {
            StringBuilder sb = new StringBuilder("(");
            boolean first = true;
            for (int i = 0; i < this.params.size(); ++i) {
                Object param = this.params.get(i);
                if (param == null) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                TableParamDef paramDef = this.sig.getParams().get(i);
                sb.append(paramDef.getName()).append(": ").append(paramDef.getType().getSimpleName()).append(" => ").append(param);
            }
            sb.append(")");
            return sb.toString();
        }

        private Object[] toArray() {
            return WorkspaceSchemaFactory.array(new Object[]{this.sig, this.params});
        }

        public int hashCode() {
            return Arrays.hashCode(this.toArray());
        }

        public boolean equals(Object obj) {
            if (obj instanceof TableInstance) {
                return Arrays.equals(this.toArray(), ((TableInstance)obj).toArray());
            }
            return false;
        }

        public String toString() {
            return this.sig.getName() + (this.params.size() == 0 ? "" : this.presentParams());
        }
    }
}

