/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.dfs;

import org.apache.commons.lang3.StringUtils;
import org.apache.drill.common.logical.OAuthConfig;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.exec.oauth.PersistentTokenTable;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OAuthEnabledFileSystem
extends FileSystem {
    private static final Logger logger = LoggerFactory.getLogger(OAuthEnabledFileSystem.class);
    private StoragePluginConfig pluginConfig;
    private PersistentTokenTable tokenTable;
    private CredentialsProvider credentialsProvider;
    private OAuthConfig oAuthConfig;

    public StoragePluginConfig getPluginConfig() {
        return this.pluginConfig;
    }

    public void setPluginConfig(StoragePluginConfig pluginConfig) {
        this.pluginConfig = pluginConfig;
        this.credentialsProvider = pluginConfig.getCredentialsProvider();
    }

    public StoragePluginConfig.AuthMode getAuthMode() {
        if (this.pluginConfig != null) {
            return this.pluginConfig.getAuthMode();
        }
        return null;
    }

    public void setTokenTable(PersistentTokenTable tokenTable) {
        this.tokenTable = tokenTable;
    }

    public PersistentTokenTable getTokenTable() {
        return this.tokenTable;
    }

    public void setoAuthConfig(OAuthConfig oAuthConfig) {
        this.oAuthConfig = oAuthConfig;
    }

    public OAuthConfig getoAuthConfig() {
        return this.oAuthConfig;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public void updateTokens(String accessToken, String refreshToken) {
        if (StringUtils.isNotEmpty((CharSequence)accessToken) && !accessToken.contentEquals(this.tokenTable.getAccessToken())) {
            logger.debug("Updating access token for OAuth File System");
            this.tokenTable.setAccessToken(accessToken);
        }
        if (StringUtils.isNotEmpty((CharSequence)refreshToken) && !refreshToken.contentEquals(this.tokenTable.getRefreshToken())) {
            logger.debug("Updating refresh token for OAuth File System");
            this.tokenTable.setRefreshToken(refreshToken);
        }
    }

    public void updateTokens(String accessToken, String refreshToken, String expiresAt) {
        this.updateTokens(accessToken, refreshToken);
        if (StringUtils.isNotEmpty((CharSequence)expiresAt)) {
            logger.debug("Updating expires at for OAuth File System.");
            this.tokenTable.setExpiresIn(expiresAt);
        }
    }
}

