/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.dfs;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.exec.planner.logical.DrillTableSelection;
import org.apache.drill.exec.store.dfs.FileSelection;
import org.apache.hadoop.fs.Path;

public class FormatSelection
implements DrillTableSelection {
    private FormatPluginConfig format;
    private FileSelection selection;

    public FormatSelection() {
    }

    @JsonCreator
    public FormatSelection(@JsonProperty(value="format") FormatPluginConfig format, @JsonProperty(value="files") List<Path> files) {
        this.format = format;
        this.selection = FileSelection.create(null, files, null);
    }

    public FormatSelection(FormatPluginConfig format, FileSelection selection) {
        this.format = format;
        this.selection = selection;
    }

    @JsonProperty(value="format")
    public FormatPluginConfig getFormat() {
        return this.format;
    }

    @JsonProperty(value="files")
    public List<Path> getAsFiles() {
        return this.selection.getFiles();
    }

    @JsonIgnore
    public FileSelection getSelection() {
        return this.selection;
    }

    @JsonIgnore
    public boolean supportsDirPruning() {
        return this.selection.supportsDirPruning();
    }

    @Override
    public String digest() {
        return this.toString();
    }

    public String toString() {
        return String.format("fileSelection=%s,formatConfig=%s", this.selection, this.format);
    }
}

