/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.dfs;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.drill.common.config.LogicalPlanPersistence;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.common.scanner.persistence.ScanResult;
import org.apache.drill.exec.store.dfs.FormatPluginOptionsDescriptor;
import org.apache.drill.exec.store.dfs.WorkspaceSchemaFactory;
import org.apache.drill.exec.store.table.function.TableParamDef;
import org.apache.drill.exec.store.table.function.TableSignature;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FormatPluginOptionExtractor {
    private static final Logger logger = LoggerFactory.getLogger(FormatPluginOptionExtractor.class);
    private final Map<String, FormatPluginOptionsDescriptor> optionsByTypeName;

    FormatPluginOptionExtractor(ScanResult scanResult) {
        HashMap<String, FormatPluginOptionsDescriptor> result = new HashMap<String, FormatPluginOptionsDescriptor>();
        Set<Class<FormatPluginConfig>> pluginConfigClasses = LogicalPlanPersistence.getSubTypes(scanResult, FormatPluginConfig.class);
        for (Class<FormatPluginConfig> pluginConfigClass : pluginConfigClasses) {
            FormatPluginOptionsDescriptor optionsDescriptor = new FormatPluginOptionsDescriptor(pluginConfigClass);
            result.put(optionsDescriptor.getTypeName().toLowerCase(), optionsDescriptor);
        }
        this.optionsByTypeName = Collections.unmodifiableMap(result);
    }

    @VisibleForTesting
    Collection<FormatPluginOptionsDescriptor> getOptions() {
        return this.optionsByTypeName.values();
    }

    List<TableSignature> getTableSignatures(String tableName, List<TableParamDef> tableParameters) {
        ArrayList<TableSignature> result = new ArrayList<TableSignature>();
        for (FormatPluginOptionsDescriptor optionsDescriptor : this.optionsByTypeName.values()) {
            TableSignature sig = optionsDescriptor.getTableSignature(tableName, tableParameters);
            result.add(sig);
        }
        return Collections.unmodifiableList(result);
    }

    FormatPluginConfig createConfigForTable(WorkspaceSchemaFactory.TableInstance t, ObjectMapper mapper, FormatPluginConfig baseConfig) {
        if (!t.sig.getSpecificParams().get(0).getName().equals("type")) {
            throw UserException.parseError().message("unknown first param for %s", t.sig).addContext("table", t.sig.getName()).build(logger);
        }
        String type = (String)t.params.get(0);
        if (type == null) {
            throw UserException.parseError().message("type param must be present but was missing", new Object[0]).addContext("table", t.sig.getName()).build(logger);
        }
        FormatPluginOptionsDescriptor optionsDescriptor = this.optionsByTypeName.get(type.toLowerCase());
        if (optionsDescriptor == null) {
            throw UserException.parseError().message("unknown type %s, expected one of %s", type, this.optionsByTypeName.keySet()).addContext("table", t.sig.getName()).build(logger);
        }
        return optionsDescriptor.createConfigForTable(t, mapper, baseConfig);
    }
}

