/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.dfs;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.drill.common.logical.OAuthConfig;
import org.apache.drill.exec.planner.logical.CreateTableEntry;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.AbstractSchemaFactory;
import org.apache.drill.exec.store.PartitionNotFoundException;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.StorageStrategy;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.store.dfs.FileSystemPlugin;
import org.apache.drill.exec.store.dfs.OAuthEnabledFileSystem;
import org.apache.drill.exec.store.dfs.SubDirectoryList;
import org.apache.drill.exec.store.dfs.WorkspaceSchemaFactory;
import org.apache.drill.exec.util.DrillFileSystemUtil;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;

public class FileSystemSchemaFactory
extends AbstractSchemaFactory {
    public static final String LOCAL_FS_SCHEME = "file";
    private List<WorkspaceSchemaFactory> factories;
    protected FileSystemPlugin plugin;

    public FileSystemSchemaFactory(String schemaName, List<WorkspaceSchemaFactory> factories) {
        super(schemaName);
        if (factories.size() > 0) {
            this.plugin = factories.get(0).getPlugin();
        }
        this.factories = factories;
    }

    public FileSystemSchemaFactory(FileSystemPlugin plugin, String schemaName, List<WorkspaceSchemaFactory> factories) {
        super(schemaName);
        this.plugin = plugin;
        this.factories = factories;
    }

    @Override
    public void registerSchemas(SchemaConfig schemaConfig, SchemaPlus parent) throws IOException {
        FileSystemSchema schema = new FileSystemSchema(this.getName(), schemaConfig);
        SchemaPlus plusOfThis = parent.add(schema.getName(), (Schema)schema);
        schema.setPlus(plusOfThis);
    }

    public class FileSystemSchema
    extends AbstractSchema {
        private final WorkspaceSchemaFactory.WorkspaceSchema defaultSchema;
        private final Map<String, WorkspaceSchemaFactory.WorkspaceSchema> schemaMap;

        public FileSystemSchema(String name, SchemaConfig schemaConfig) throws IOException {
            super(Collections.emptyList(), name);
            this.schemaMap = new HashMap<String, WorkspaceSchemaFactory.WorkspaceSchema>();
            DrillFileSystem fs = ImpersonationUtil.createFileSystem(schemaConfig.getUserName(), FileSystemSchemaFactory.this.plugin.getFsConf());
            OAuthConfig oAuthConfig = FileSystemSchemaFactory.this.plugin.getConfig().oAuthConfig();
            if (oAuthConfig != null) {
                OAuthEnabledFileSystem underlyingFileSystem = (OAuthEnabledFileSystem)fs.getUnderlyingFs();
                underlyingFileSystem.setPluginConfig(FileSystemSchemaFactory.this.plugin.getConfig());
                underlyingFileSystem.setTokenTable(FileSystemSchemaFactory.this.plugin.getTokenTable());
                underlyingFileSystem.setoAuthConfig(FileSystemSchemaFactory.this.plugin.getConfig().oAuthConfig());
            }
            for (WorkspaceSchemaFactory f : FileSystemSchemaFactory.this.factories) {
                WorkspaceSchemaFactory.WorkspaceSchema s = f.createSchema(this.getSchemaPath(), schemaConfig, fs);
                if (s == null) continue;
                this.schemaMap.put(s.getName(), s);
            }
            this.defaultSchema = this.schemaMap.get("default");
        }

        void setPlus(SchemaPlus plusOfThis) {
            for (WorkspaceSchemaFactory.WorkspaceSchema s : this.schemaMap.values()) {
                plusOfThis.add(s.getName(), (Schema)s);
            }
        }

        @Override
        public Iterable<String> getSubPartitions(String table, List<String> partitionColumns, List<String> partitionValues) throws PartitionNotFoundException {
            List<FileStatus> fileStatuses;
            try {
                fileStatuses = DrillFileSystemUtil.listDirectories(this.defaultSchema.getFS(), new Path(this.defaultSchema.getDefaultLocation(), table), false, new PathFilter[0]);
            }
            catch (IOException e) {
                throw new PartitionNotFoundException("Error finding partitions for table " + table, e);
            }
            return new SubDirectoryList(fileStatuses);
        }

        @Override
        public boolean showInInformationSchema() {
            return false;
        }

        @Override
        public String getTypeName() {
            return FileSystemSchemaFactory.LOCAL_FS_SCHEME;
        }

        @Override
        public Table getTable(String name) {
            return this.defaultSchema.getTable(name);
        }

        @Override
        public Collection<Function> getFunctions(String name) {
            return this.defaultSchema.getFunctions(name);
        }

        @Override
        public Set<String> getFunctionNames() {
            return this.defaultSchema.getFunctionNames();
        }

        @Override
        public AbstractSchema getSubSchema(String name) {
            return this.schemaMap.get(name);
        }

        @Override
        public Set<String> getSubSchemaNames() {
            return this.schemaMap.keySet();
        }

        @Override
        public Set<String> getTableNames() {
            return this.defaultSchema.getTableNames();
        }

        @Override
        public boolean isMutable() {
            return this.defaultSchema.isMutable();
        }

        @Override
        public CreateTableEntry createNewTable(String tableName, List<String> partitionColumns, StorageStrategy storageStrategy) {
            return this.defaultSchema.createNewTable(tableName, partitionColumns, storageStrategy);
        }

        @Override
        public CreateTableEntry createStatsTable(String tableName) {
            return this.defaultSchema.createStatsTable(tableName);
        }

        @Override
        public CreateTableEntry appendToStatsTable(String tableName) {
            return this.defaultSchema.appendToStatsTable(tableName);
        }

        @Override
        public Table getStatsTable(String tableName) {
            return this.defaultSchema.getStatsTable(tableName);
        }

        @Override
        public AbstractSchema getDefaultSchema() {
            return this.defaultSchema;
        }
    }
}

