/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.dfs;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.drill.common.PlanStringBuilder;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.common.logical.OAuthConfig;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.common.logical.security.PlainCredentialsProvider;
import org.apache.drill.common.map.CaseInsensitiveMap;
import org.apache.drill.exec.store.dfs.WorkspaceConfig;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;

@JsonTypeName(value="file")
public class FileSystemConfig
extends StoragePluginConfig {
    private static final List<String> FS_CREDENTIAL_KEYS = Arrays.asList("hadoop.security.credential.provider.path", "fs.s3a.access.key", "fs.s3a.secret.key");
    public static final String NAME = "file";
    private final String connection;
    private final List<String> mountCommand;
    private final List<String> unmountCommand;
    private final Map<String, String> config;
    private final Map<String, WorkspaceConfig> workspaces;
    private final Map<String, FormatPluginConfig> formats;
    private final OAuthConfig oAuthConfig;

    public FileSystemConfig(String connection, Map<String, String> config, Map<String, WorkspaceConfig> workspaces, Map<String, FormatPluginConfig> formats, OAuthConfig oAuthConfig, CredentialsProvider credentialsProvider) {
        this(connection, null, null, config, workspaces, formats, oAuthConfig, null, credentialsProvider);
    }

    public FileSystemConfig(String connection, Map<String, String> config, Map<String, WorkspaceConfig> workspaces, Map<String, FormatPluginConfig> formats, CredentialsProvider credentialsProvider) {
        this(connection, null, null, config, workspaces, formats, null, null, credentialsProvider);
    }

    @JsonCreator
    public FileSystemConfig(@JsonProperty(value="connection") String connection, @JsonProperty(value="mountCommand") List<String> mountCommand, @JsonProperty(value="unmountCommand") List<String> unmountCommand, @JsonProperty(value="config") Map<String, String> config, @JsonProperty(value="workspaces") Map<String, WorkspaceConfig> workspaces, @JsonProperty(value="formats") Map<String, FormatPluginConfig> formats, @JsonProperty(value="oAuthConfig") OAuthConfig oAuthConfig, @JsonProperty(value="authMode") String authMode, @JsonProperty(value="credentialsProvider") CredentialsProvider credentialsProvider) {
        super(credentialsProvider, credentialsProvider == null, StoragePluginConfig.AuthMode.parseOrDefault(authMode, StoragePluginConfig.AuthMode.SHARED_USER), oAuthConfig);
        this.connection = connection;
        this.mountCommand = mountCommand;
        this.unmountCommand = unmountCommand;
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        if (config != null) {
            builder.putAll(config);
        }
        this.config = builder.build();
        CaseInsensitiveMap<WorkspaceConfig> caseInsensitiveWorkspaces = CaseInsensitiveMap.newHashMap();
        Optional.ofNullable(workspaces).ifPresent(caseInsensitiveWorkspaces::putAll);
        this.workspaces = caseInsensitiveWorkspaces;
        this.oAuthConfig = oAuthConfig;
        this.formats = formats != null ? formats : new LinkedHashMap();
    }

    @JsonProperty
    public String getConnection() {
        return this.connection;
    }

    @JsonProperty
    public List<String> getMountCommand() {
        return this.mountCommand;
    }

    @JsonProperty
    public List<String> getUnmountCommand() {
        return this.unmountCommand;
    }

    @JsonProperty
    public Map<String, String> getConfig() {
        return this.config;
    }

    @JsonProperty
    public Map<String, WorkspaceConfig> getWorkspaces() {
        return this.workspaces;
    }

    @JsonProperty
    public Map<String, FormatPluginConfig> getFormats() {
        return this.formats;
    }

    @Override
    public String getValue(String key) {
        return this.config == null ? null : this.config.get(key);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.connection, this.config, this.formats, this.workspaces);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FileSystemConfig other = (FileSystemConfig)obj;
        return Objects.equals(this.connection, other.connection) && Objects.equals(this.mountCommand, other.mountCommand) && Objects.equals(this.unmountCommand, other.unmountCommand) && Objects.equals(this.config, other.config) && Objects.equals(this.formats, other.formats) && Objects.equals(this.workspaces, other.workspaces);
    }

    public String toString() {
        return new PlanStringBuilder(this).field("connection", this.connection).field("mountCommand", this.mountCommand).field("unmountCommand", this.unmountCommand).field("config", this.config).field("formats", this.formats).field("workspaces", this.workspaces).toString();
    }

    public FileSystemConfig copy() {
        return this.copyWithFormats(null);
    }

    public FileSystemConfig copyWithFormats(Map<String, FormatPluginConfig> newFormats) {
        LinkedHashMap<String, FormatPluginConfig> formatsCopy;
        HashMap<String, String> configCopy = this.config == null ? null : new HashMap<String, String>(this.config);
        LinkedHashMap<String, FormatPluginConfig> linkedHashMap = formatsCopy = this.formats == null ? null : new LinkedHashMap<String, FormatPluginConfig>(this.formats);
        if (newFormats != null) {
            formatsCopy = formatsCopy == null ? new LinkedHashMap<String, FormatPluginConfig>() : formatsCopy;
            formatsCopy.putAll(newFormats);
        }
        FileSystemConfig newConfig = new FileSystemConfig(this.connection, this.mountCommand, this.unmountCommand, configCopy, this.workspaces, formatsCopy, this.oAuthConfig, this.authMode.name(), this.credentialsProvider);
        newConfig.setEnabled(this.isEnabled());
        return newConfig;
    }

    private static CredentialsProvider getCredentialsProvider(Map<String, String> config, CredentialsProvider credentialsProvider) {
        if (credentialsProvider != null) {
            return credentialsProvider;
        }
        if (config != null) {
            Map<String, String> credentials = FS_CREDENTIAL_KEYS.stream().filter(config::containsKey).collect(Collectors.toMap(fsCredentialKey -> fsCredentialKey, config::get));
            return new PlainCredentialsProvider(credentials);
        }
        return PlainCredentialsProvider.EMPTY_CREDENTIALS_PROVIDER;
    }
}

