/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.dfs;

import com.dropbox.core.DbxDownloader;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.oauth.DbxCredential;
import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.FolderMetadata;
import com.dropbox.core.v2.files.ListFolderResult;
import com.dropbox.core.v2.files.Metadata;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.exec.oauth.PersistentTokenTable;
import org.apache.drill.exec.store.dfs.OAuthEnabledFileSystem;
import org.apache.drill.exec.store.security.oauth.OAuthTokenCredentials;
import org.apache.drill.exec.vector.complex.fn.SeekableBAIS;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropboxFileSystem
extends OAuthEnabledFileSystem {
    private static final Logger logger = LoggerFactory.getLogger(DropboxFileSystem.class);
    private static final String ERROR_MSG = "Dropbox is read only.";
    private static final String APP_IDENTIFIER = "Apache/Drill";
    private Path workingDirectory;
    private DbxClientV2 client;
    private DbxCredential dbxCredential;
    private DbxRequestConfig config;
    private FileStatus[] fileStatuses;
    private final Map<String, FileStatus> fileStatusCache = new HashMap<String, FileStatus>();
    private boolean usesDeveloperToken;

    public URI getUri() {
        try {
            return new URI("dropbox:///");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        FSDataInputStream fsDataInputStream;
        String filename = this.getFileName(path);
        this.client = this.getClient();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (DbxDownloader downloader = this.client.files().download(filename);){
            downloader.download((OutputStream)out);
            this.updateTokens();
            fsDataInputStream = new FSDataInputStream((InputStream)new SeekableBAIS(out.toByteArray()));
        }
        catch (DbxException e) {
            throw new IOException(e.getMessage());
        }
        return fsDataInputStream;
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        throw new IOException(ERROR_MSG);
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new IOException(ERROR_MSG);
    }

    public boolean rename(Path src, Path dst) throws IOException {
        return false;
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        throw new IOException(ERROR_MSG);
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        this.client = this.getClient();
        ArrayList<FileStatus> fileStatusList = new ArrayList<FileStatus>();
        try {
            String pathString = path.isRoot() ? "" : path.toString().replace("dropbox:", "");
            ListFolderResult result = this.client.files().listFolder(pathString);
            this.updateTokens();
            while (true) {
                for (Metadata metadata : result.getEntries()) {
                    fileStatusList.add(this.getFileInformation(metadata));
                }
                if (result.getHasMore()) {
                    result = this.client.files().listFolderContinue(result.getCursor());
                    this.updateTokens();
                    continue;
                }
                break;
            }
        }
        catch (DbxException e) {
            throw new IOException(e.getMessage());
        }
        this.fileStatuses = new FileStatus[fileStatusList.size()];
        for (int i = 0; i < fileStatusList.size(); ++i) {
            this.fileStatuses[i] = (FileStatus)fileStatusList.get(i);
        }
        return this.fileStatuses;
    }

    public void setWorkingDirectory(Path new_dir) {
        logger.debug("Setting working directory to: " + new_dir.getName());
        this.workingDirectory = new_dir;
    }

    public Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        throw new IOException(ERROR_MSG);
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        String filePath = Path.getPathWithoutSchemeAndAuthority((Path)path).toString();
        if (filePath.equalsIgnoreCase("/")) {
            return new FileStatus(0L, true, 1, 0L, 0L, new Path("/"));
        }
        this.client = this.getClient();
        try {
            Metadata metadata = this.client.files().getMetadata(filePath);
            this.updateTokens();
            return this.getFileInformation(metadata);
        }
        catch (Exception e) {
            throw new IOException("Error accessing file " + filePath + "\n" + e.getMessage());
        }
    }

    private FileStatus getFileInformation(Metadata metadata) {
        FileStatus result;
        if (this.fileStatusCache.containsKey(metadata.getPathLower())) {
            return this.fileStatusCache.get(metadata.getPathLower());
        }
        if (this.isDirectory(metadata)) {
            result = new FileStatus(0L, true, 1, 0L, 0L, new Path(metadata.getPathLower()));
        } else {
            FileMetadata fileMetadata = (FileMetadata)metadata;
            result = new FileStatus(fileMetadata.getSize(), false, 1, 0L, fileMetadata.getClientModified().getTime(), new Path(metadata.getPathLower()));
        }
        this.fileStatusCache.put(metadata.getPathLower(), result);
        return result;
    }

    private DbxClientV2 getClient() {
        if (this.client != null) {
            return this.client;
        }
        String clientIdentifier = this.getConf().get("clientIdentifier", APP_IDENTIFIER);
        logger.info("Creating dropbox client with client identifier: {}", (Object)clientIdentifier);
        this.config = DbxRequestConfig.newBuilder((String)clientIdentifier).withAutoRetryEnabled(5).build();
        logger.info("Reading dropbox access token from configuration or credentials provider");
        String accessToken = this.getConf().get("dropboxAccessToken", "");
        if (StringUtils.isNotEmpty((CharSequence)accessToken)) {
            this.client = new DbxClientV2(this.config, accessToken);
            this.usesDeveloperToken = true;
        } else {
            CredentialsProvider credentialsProvider = this.getCredentialsProvider();
            PersistentTokenTable tokenTable = this.getTokenTable();
            OAuthTokenCredentials credentials = new OAuthTokenCredentials.Builder().setCredentialsProvider(credentialsProvider).setTokenTable(tokenTable).build().get();
            long expiresIn = 0L;
            if (StringUtils.isNotEmpty((CharSequence)credentials.getExpiresIn())) {
                expiresIn = Long.parseLong(credentials.getExpiresIn());
            }
            this.dbxCredential = new DbxCredential(credentials.getAccessToken(), Long.valueOf(expiresIn), credentials.getRefreshToken(), credentials.getClientID(), credentials.getClientSecret());
            this.client = new DbxClientV2(this.config, this.dbxCredential);
            this.usesDeveloperToken = false;
        }
        return this.client;
    }

    private void updateTokens() {
        if (this.client == null || this.usesDeveloperToken) {
            return;
        }
        if (this.dbxCredential.aboutToExpire()) {
            try {
                this.dbxCredential.refresh(this.config);
            }
            catch (DbxException e) {
                throw UserException.connectionError(e).message("Error refreshing Dropbox OAuth tokens: " + e.getMessage(), new Object[0]).build(logger);
            }
            this.updateTokens(this.dbxCredential.getAccessToken(), this.dbxCredential.getRefreshToken(), String.valueOf(this.dbxCredential.getExpiresAt()));
        }
    }

    private boolean isDirectory(Metadata metadata) {
        return metadata instanceof FolderMetadata;
    }

    private String getFileName(Path path) {
        return path.toUri().getPath();
    }
}

