/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.dfs;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import org.apache.drill.exec.ops.OperatorStats;
import org.apache.drill.exec.store.dfs.OpenFileTracker;
import org.apache.drill.shaded.guava.com.google.common.io.ByteStreams;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.ReadOption;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.ByteBufferPool;

public class DrillFSDataInputStream
extends FSDataInputStream {
    private final FSDataInputStream underlyingIs;
    private final OpenFileTracker openFileTracker;
    private final OperatorStats operatorStats;

    public DrillFSDataInputStream(FSDataInputStream in, OperatorStats operatorStats) {
        this(in, operatorStats, null);
    }

    public DrillFSDataInputStream(FSDataInputStream in, OperatorStats operatorStats, OpenFileTracker openFileTracker) {
        super((InputStream)new WrappedInputStream(in, operatorStats));
        this.underlyingIs = in;
        this.openFileTracker = openFileTracker;
        this.operatorStats = operatorStats;
    }

    public synchronized void seek(long desired) throws IOException {
        this.underlyingIs.seek(desired);
    }

    public long getPos() throws IOException {
        return this.underlyingIs.getPos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        this.operatorStats.startWait();
        try {
            int n = this.underlyingIs.read(position, buffer, offset, length);
            return n;
        }
        finally {
            this.operatorStats.stopWait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        this.operatorStats.startWait();
        try {
            this.underlyingIs.readFully(position, buffer, offset, length);
        }
        finally {
            this.operatorStats.stopWait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFully(long position, byte[] buffer) throws IOException {
        this.operatorStats.startWait();
        try {
            this.underlyingIs.readFully(position, buffer);
        }
        finally {
            this.operatorStats.stopWait();
        }
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        return this.underlyingIs.seekToNewSource(targetPos);
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS"})
    public InputStream getWrappedStream() {
        return this.underlyingIs.getWrappedStream();
    }

    public int read(ByteBuffer buf) throws IOException {
        this.operatorStats.startWait();
        try {
            int n = this.underlyingIs.read(buf);
            return n;
        }
        finally {
            this.operatorStats.stopWait();
        }
    }

    public FileDescriptor getFileDescriptor() throws IOException {
        return this.underlyingIs.getFileDescriptor();
    }

    public void setReadahead(Long readahead) throws IOException, UnsupportedOperationException {
        this.underlyingIs.setReadahead(readahead);
    }

    public void setDropBehind(Boolean dropBehind) throws IOException, UnsupportedOperationException {
        this.underlyingIs.setDropBehind(dropBehind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer read(ByteBufferPool bufferPool, int maxLength, EnumSet<ReadOption> opts) throws IOException, UnsupportedOperationException {
        this.operatorStats.startWait();
        try {
            ByteBuffer byteBuffer = this.underlyingIs.read(bufferPool, maxLength, opts);
            return byteBuffer;
        }
        finally {
            this.operatorStats.stopWait();
        }
    }

    public void releaseBuffer(ByteBuffer buffer) {
        this.underlyingIs.releaseBuffer(buffer);
    }

    public int read() throws IOException {
        return this.underlyingIs.read();
    }

    public long skip(long n) throws IOException {
        return this.underlyingIs.skip(n);
    }

    public int available() throws IOException {
        return this.underlyingIs.available();
    }

    public void close() throws IOException {
        if (this.openFileTracker != null) {
            this.openFileTracker.fileClosed(this);
        }
        this.underlyingIs.close();
    }

    public void mark(int readlimit) {
        this.underlyingIs.mark(readlimit);
    }

    public void reset() throws IOException {
        this.underlyingIs.reset();
    }

    public boolean markSupported() {
        return this.underlyingIs.markSupported();
    }

    public void unbuffer() {
        this.underlyingIs.unbuffer();
    }

    private static class WrappedInputStream
    extends InputStream
    implements Seekable,
    PositionedReadable {
        final FSDataInputStream is;
        final OperatorStats operatorStats;

        WrappedInputStream(FSDataInputStream is, OperatorStats operatorStats) {
            this.is = is;
            this.operatorStats = operatorStats;
        }

        @Override
        public int read() throws IOException {
            return this.is.read();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.operatorStats.startWait();
            try {
                int n = this.readBytes(b, off, len);
                return n;
            }
            finally {
                this.operatorStats.stopWait();
            }
        }

        @Override
        public int read(byte[] b) throws IOException {
            this.operatorStats.startWait();
            try {
                int n = this.readBytes(b, 0, b.length);
                return n;
            }
            finally {
                this.operatorStats.stopWait();
            }
        }

        private int readBytes(byte[] b, int off, int len) throws IOException {
            int read = ByteStreams.read((InputStream)this.is, b, off, len);
            if (read == 0 && len > 0) {
                return -1;
            }
            return read;
        }

        @Override
        public long skip(long n) throws IOException {
            return this.is.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.is.available();
        }

        @Override
        public void close() throws IOException {
            this.is.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.is.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.is.reset();
        }

        @Override
        public boolean markSupported() {
            return this.is.markSupported();
        }

        public int read(long position, byte[] buffer, int offset, int length) throws IOException {
            return this.is.read(position, buffer, offset, length);
        }

        public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
            this.is.readFully(position, buffer, offset, length);
        }

        public void readFully(long position, byte[] buffer) throws IOException {
            this.is.readFully(position, buffer);
        }

        public void seek(long pos) throws IOException {
            this.is.seek(pos);
        }

        public long getPos() throws IOException {
            return this.is.getPos();
        }

        public boolean seekToNewSource(long targetPos) throws IOException {
            return this.is.seekToNewSource(targetPos);
        }
    }
}

