/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.dfs;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxItem;
import com.box.sdk.BoxSearch;
import com.box.sdk.BoxSearchParameters;
import com.box.sdk.PartialCollection;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.exec.oauth.PersistentTokenTable;
import org.apache.drill.exec.store.dfs.OAuthEnabledFileSystem;
import org.apache.drill.exec.store.dfs.SeekableByteArrayInputStream;
import org.apache.drill.exec.store.security.oauth.OAuthTokenCredentials;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoxFileSystem
extends OAuthEnabledFileSystem {
    private static final Logger logger = LoggerFactory.getLogger(BoxFileSystem.class);
    private static final String TIMEOUT_DEFAULT = "5000";
    private static final List<String> SEARCH_CONTENT_TYPES = new ArrayList<String>(Collections.singletonList("name"));
    private Path workingDirectory;
    private BoxAPIConnection client;
    private String workingDirectoryID;
    private BoxFolder rootFolder;
    private boolean usesDeveloperToken;
    private final List<String> ancestorFolderIDs = new ArrayList<String>();
    private final Map<Path, BoxItem> itemCache = new HashMap<Path, BoxItem>();

    public URI getUri() {
        try {
            return new URI("box:///");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public FSDataInputStream open(Path inputPath, int bufferSize) throws IOException {
        this.client = this.getClient();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BoxItem item = this.getItem(inputPath);
        if (item instanceof BoxFile) {
            BoxFile file = (BoxFile)item;
            this.updateTokens();
            file.download((OutputStream)out);
            this.updateTokens();
            FSDataInputStream fsDataInputStream = new FSDataInputStream((InputStream)new SeekableByteArrayInputStream(out.toByteArray()));
            out.close();
            return fsDataInputStream;
        }
        throw new IOException("Attempted to read " + inputPath + " which is not a file.  Only files can be read by Box.");
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        throw new UnsupportedOperationException("Box is read only.");
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new UnsupportedOperationException("Box does not support append.");
    }

    public boolean rename(Path src, Path dst) throws IOException {
        throw new UnsupportedOperationException("Box does not support rename.");
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        return false;
    }

    public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
        BoxItem incoming = this.getItem(f);
        if (incoming instanceof BoxFolder) {
            BoxFolder folder = (BoxFolder)incoming;
            int itemCount = 0;
            ArrayList<FileStatus> fileStatusList = new ArrayList<FileStatus>();
            for (BoxItem.Info childInfo : folder.getChildren()) {
                FileStatus status;
                Path newPath = new Path(f + childInfo.getName());
                if (childInfo instanceof BoxFolder.Info) {
                    status = new FileStatus(childInfo.getSize(), true, 1, 0L, this.getModifiedMillis(childInfo), newPath);
                    fileStatusList.add(status);
                    ++itemCount;
                    continue;
                }
                if (!(childInfo instanceof BoxFile.Info)) continue;
                status = new FileStatus(childInfo.getSize(), false, 1, 0L, this.getModifiedMillis(childInfo), newPath);
                fileStatusList.add(status);
                ++itemCount;
            }
            return fileStatusList.toArray(new FileStatus[itemCount]);
        }
        if (incoming instanceof BoxFile) {
            BoxFile infile = (BoxFile)incoming;
            FileStatus[] results = new FileStatus[]{new FileStatus(infile.getInfo().getSize(), false, 1, 0L, this.getModifiedMillis((BoxItem)infile), f)};
            return results;
        }
        return new FileStatus[0];
    }

    public void setWorkingDirectory(Path new_dir) {
        logger.debug("Setting working directory to: " + new_dir.getName());
        this.workingDirectory = new_dir;
        this.ancestorFolderIDs.clear();
        if (StringUtils.isEmpty((CharSequence)this.workingDirectoryID) || new_dir.toString().contentEquals("/")) {
            this.workingDirectoryID = "0";
            this.ancestorFolderIDs.add("0");
        } else {
            ArrayList<String> pathParts = new ArrayList<String>(Arrays.asList(new_dir.toString().split("/")));
            for (String pathPart : pathParts) {
                BoxSearch search = new BoxSearch(this.client);
                this.updateTokens();
                BoxSearchParameters searchParams = new BoxSearchParameters();
                searchParams.setQuery(pathPart);
                searchParams.setContentTypes(SEARCH_CONTENT_TYPES);
                searchParams.setType("folder");
                searchParams.setAncestorFolderIds(this.ancestorFolderIDs);
                PartialCollection searchResults = search.searchRange(1L, 3L, searchParams);
                this.updateTokens();
                Iterator iterator = searchResults.iterator();
                if (!iterator.hasNext()) continue;
                BoxItem.Info result = (BoxItem.Info)iterator.next();
                String id = result.getID();
                this.ancestorFolderIDs.add(id);
            }
        }
    }

    public Path getWorkingDirectory() {
        if (StringUtils.isEmpty((CharSequence)this.workingDirectoryID)) {
            this.workingDirectory = new Path("/");
            this.workingDirectoryID = "0";
        }
        return this.workingDirectory;
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        return false;
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        this.client = this.getClient();
        BoxItem pathItem = this.getItem(f);
        if (pathItem instanceof BoxFolder) {
            BoxFolder folder = (BoxFolder)pathItem;
            this.updateTokens();
            BoxFolder.Info folderInfo = folder.getInfo();
            long size = folderInfo.getSize();
            return new FileStatus(size, true, 1, 0L, this.getModifiedMillis(pathItem), f);
        }
        if (pathItem instanceof BoxFile) {
            BoxFile boxFile = (BoxFile)pathItem;
            BoxFile.Info fileInfo = boxFile.getInfo();
            long fileSize = fileInfo.getSize();
            return new FileStatus(fileSize, false, 1, 0L, this.getModifiedMillis(pathItem), f);
        }
        return new FileStatus();
    }

    private BoxItem getItem(Path path) {
        if (this.itemCache.containsKey(path)) {
            return this.itemCache.get(path);
        }
        this.client = this.getClient();
        if (path.isRoot()) {
            if (this.rootFolder == null) {
                this.rootFolder = BoxFolder.getRootFolder((BoxAPIConnection)this.client);
                this.updateTokens();
                this.itemCache.put(path, (BoxItem)this.rootFolder);
            }
            return this.rootFolder;
        }
        long offsetValue = 0L;
        long limitValue = 100L;
        BoxSearch search = new BoxSearch(this.client);
        this.updateTokens();
        BoxSearchParameters searchParams = new BoxSearchParameters();
        searchParams.setQuery(path.getName());
        searchParams.setContentTypes(SEARCH_CONTENT_TYPES);
        String fileExtension = FilenameUtils.getExtension((String)path.getName());
        if (StringUtils.isEmpty((CharSequence)fileExtension)) {
            searchParams.setType("folder");
        } else {
            searchParams.setType("file");
            searchParams.setFileExtensions(Collections.singletonList(fileExtension));
        }
        if (this.ancestorFolderIDs.size() > 0) {
            searchParams.setAncestorFolderIds(this.ancestorFolderIDs);
        }
        PartialCollection searchResults = search.searchRange(offsetValue, limitValue, searchParams);
        this.updateTokens();
        for (BoxItem.Info resultInfo : searchResults) {
            String id = resultInfo.getID();
            if (resultInfo.getType().contentEquals("file")) {
                BoxFile file = new BoxFile(this.client, id);
                this.updateTokens();
                this.itemCache.put(path, (BoxItem)file);
                return file;
            }
            if (!resultInfo.getType().contentEquals("folder")) continue;
            BoxFolder folder = new BoxFolder(this.client, id);
            this.updateTokens();
            this.itemCache.put(path, (BoxItem)folder);
            return folder;
        }
        return null;
    }

    private void updateTokens() {
        if (this.client == null || this.usesDeveloperToken) {
            return;
        }
        if (this.client.canRefresh() && this.client.needsRefresh()) {
            if (!this.client.canRefresh()) {
                throw UserException.connectionError().message("Box file system missing refresh token. Please reauthenticate to obtain a refresh token.", new Object[0]).build(logger);
            }
            super.updateTokens(this.client.getAccessToken(), this.client.getRefreshToken(), String.valueOf(this.client.getExpires()));
        }
    }

    private BoxAPIConnection getClient() {
        if (this.client != null) {
            return this.client;
        }
        int connectionTimeout = Integer.parseInt(this.getConf().get("boxConnectionTimeout", TIMEOUT_DEFAULT));
        int readTimeout = Integer.parseInt(this.getConf().get("boxReadTimeout", TIMEOUT_DEFAULT));
        String developerToken = this.getConf().get("boxAccessToken", "");
        if (StringUtils.isNotEmpty((CharSequence)developerToken)) {
            BoxAPIConnection client = new BoxAPIConnection(developerToken);
            client.setConnectTimeout(connectionTimeout);
            client.setReadTimeout(readTimeout);
            this.usesDeveloperToken = true;
            return client;
        }
        CredentialsProvider credentialsProvider = this.getCredentialsProvider();
        PersistentTokenTable tokenTable = this.getTokenTable();
        OAuthTokenCredentials credentials = new OAuthTokenCredentials.Builder().setCredentialsProvider(credentialsProvider).setTokenTable(tokenTable).build().get();
        BoxAPIConnection newClient = new BoxAPIConnection(credentials.getClientID(), credentials.getClientSecret(), tokenTable.getAccessToken(), tokenTable.getRefreshToken());
        newClient.setConnectTimeout(connectionTimeout);
        newClient.setReadTimeout(readTimeout);
        return newClient;
    }

    private long getModifiedMillis(BoxItem item) {
        return this.getModifiedMillis(item.getInfo());
    }

    private long getModifiedMillis(BoxItem.Info info) {
        Date modifiedDate = info.getModifiedAt();
        if (modifiedDate == null) {
            return 0L;
        }
        return modifiedDate.getTime();
    }
}

