/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.dfs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.logical.DrillTableSelection;
import org.apache.drill.exec.planner.logical.DynamicDrillTable;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.store.dfs.FileSelection;
import org.apache.drill.exec.store.dfs.FileSystemPlugin;
import org.apache.drill.exec.store.dfs.FormatMatcher;
import org.apache.drill.exec.store.dfs.FormatPlugin;
import org.apache.drill.exec.store.dfs.FormatSelection;
import org.apache.drill.exec.store.dfs.MagicString;
import org.apache.drill.shaded.guava.com.google.common.collect.Range;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;

public class BasicFormatMatcher
extends FormatMatcher {
    protected final FormatPlugin plugin;
    private final boolean compressible;
    private final CompressionCodecFactory codecFactory;
    private final List<Pattern> patterns;
    private final MagicStringMatcher matcher;

    public BasicFormatMatcher(FormatPlugin plugin, List<Pattern> patterns, List<MagicString> magicStrings) {
        this.patterns = new ArrayList<Pattern>(patterns);
        this.matcher = new MagicStringMatcher(magicStrings);
        this.plugin = plugin;
        this.compressible = false;
        this.codecFactory = null;
    }

    public BasicFormatMatcher(FormatPlugin plugin, Configuration fsConf, List<String> extensions, boolean compressible) {
        this.patterns = extensions.stream().map(extension -> Pattern.compile(".*\\." + extension)).collect(Collectors.toList());
        this.matcher = new MagicStringMatcher(new ArrayList<MagicString>());
        this.plugin = plugin;
        this.compressible = compressible;
        this.codecFactory = new CompressionCodecFactory(fsConf);
    }

    @Override
    public boolean supportDirectoryReads() {
        return false;
    }

    @Override
    public DrillTable isReadable(DrillFileSystem fs, FileSelection selection, FileSystemPlugin fsPlugin, String storageEngineName, SchemaConfig schemaConfig) throws IOException {
        if (this.isFileReadable(fs, selection.getFirstPath(fs))) {
            return new DynamicDrillTable(fsPlugin, storageEngineName, schemaConfig.getUserName(), (DrillTableSelection)new FormatSelection(this.plugin.getConfig(), selection));
        }
        return null;
    }

    @Override
    public boolean isFileReadable(DrillFileSystem fs, FileStatus status) throws IOException {
        CompressionCodec codec = null;
        if (this.compressible) {
            codec = this.codecFactory.getCodec(status.getPath());
        }
        String fileName = status.getPath().toString();
        String fileNameHacked = null;
        if (codec != null) {
            fileNameHacked = fileName.substring(0, fileName.lastIndexOf(46));
        }
        for (Pattern p : this.patterns) {
            if (p.matcher(fileName).matches()) {
                return true;
            }
            if (fileNameHacked == null || !p.matcher(fileNameHacked).matches()) continue;
            return true;
        }
        return this.matcher.matches(fs, status);
    }

    @Override
    @JsonIgnore
    public FormatPlugin getFormatPlugin() {
        return this.plugin;
    }

    private static class MagicStringMatcher {
        private final List<RangeMagics> ranges;

        MagicStringMatcher(List<MagicString> magicStrings) {
            this.ranges = magicStrings.stream().map(RangeMagics::new).collect(Collectors.toList());
        }

        public boolean matches(DrillFileSystem fs, FileStatus status) throws IOException {
            if (this.ranges.isEmpty() || status.isDirectory()) {
                return false;
            }
            FileStatus current = status;
            while (current.isSymlink()) {
                current = fs.getFileStatus(status.getSymlink());
            }
            if (!current.isFile()) {
                return false;
            }
            Range<Long> fileRange = Range.closedOpen(0L, status.getLen());
            try (FSDataInputStream is = fs.open(status.getPath());){
                for (RangeMagics rMagic : this.ranges) {
                    Range r = rMagic.range;
                    if (!fileRange.encloses(r)) continue;
                    int len = (int)((Long)r.upperEndpoint() - (Long)r.lowerEndpoint());
                    byte[] bytes = new byte[len];
                    is.readFully(((Long)r.lowerEndpoint()).longValue(), bytes);
                    for (byte[] magic : rMagic.magics) {
                        if (!Arrays.equals(magic, bytes)) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            return false;
        }

        private static class RangeMagics {
            private final Range<Long> range;
            private final byte[][] magics;

            RangeMagics(MagicString ms) {
                this.range = Range.closedOpen(ms.getOffset(), Long.valueOf(ms.getBytes().length));
                this.magics = new byte[][]{ms.getBytes()};
            }
        }
    }
}

