/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.base.filter;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.util.Pair;
import org.apache.drill.common.expression.BooleanOperator;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.expression.visitors.AbstractExprVisitor;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.planner.PlannerPhase;
import org.apache.drill.exec.store.base.filter.ConstantHolder;
import org.apache.drill.exec.store.base.filter.ExprNode;
import org.apache.drill.exec.store.base.filter.RelOp;

public class FilterPushDownUtils {
    private static final ConstantExtractor CONSTANT_EXTRACTOR = new ConstantExtractor();
    private static final ColRefExtractor COL_REF_EXTRACTOR = new ColRefExtractor();
    public static final RelOpExtractor REL_OP_EXTRACTOR = new RelOpExtractor();

    public static boolean isFilterPushDownPhase(PlannerPhase phase) {
        switch (phase) {
            case LOGICAL_PRUNE_AND_JOIN: 
            case PARTITION_PRUNING: 
            case LOGICAL_PRUNE: {
                return true;
            }
        }
        return false;
    }

    private static class ConstantExtractor
    extends AbstractExprVisitor<ConstantHolder, Void, RuntimeException> {
        private ConstantExtractor() {
        }

        @Override
        public ConstantHolder visitIntConstant(ValueExpressions.IntExpression expr, Void value) throws RuntimeException {
            return new ConstantHolder(TypeProtos.MinorType.INT, expr.getInt());
        }

        @Override
        public ConstantHolder visitLongConstant(ValueExpressions.LongExpression expr, Void value) throws RuntimeException {
            return new ConstantHolder(TypeProtos.MinorType.BIGINT, expr.getLong());
        }

        @Override
        public ConstantHolder visitBooleanConstant(ValueExpressions.BooleanExpression expr, Void value) throws RuntimeException {
            return new ConstantHolder(TypeProtos.MinorType.BIT, expr.getBoolean());
        }

        @Override
        public ConstantHolder visitQuotedStringConstant(ValueExpressions.QuotedString expr, Void value) throws RuntimeException {
            return new ConstantHolder(TypeProtos.MinorType.VARCHAR, expr.getString());
        }

        @Override
        public ConstantHolder visitFloatConstant(ValueExpressions.FloatExpression expr, Void value) throws RuntimeException {
            return new ConstantHolder(TypeProtos.MinorType.FLOAT8, expr.getFloat());
        }

        @Override
        public ConstantHolder visitDoubleConstant(ValueExpressions.DoubleExpression expr, Void value) throws RuntimeException {
            return new ConstantHolder(TypeProtos.MinorType.FLOAT8, expr.getDouble());
        }

        @Override
        public ConstantHolder visitVarDecimalConstant(ValueExpressions.VarDecimalExpression expr, Void value) throws RuntimeException {
            return new ConstantHolder(TypeProtos.MinorType.VARDECIMAL, expr.getBigDecimal());
        }

        @Override
        public ConstantHolder visitDateConstant(ValueExpressions.DateExpression expr, Void value) throws RuntimeException {
            return new ConstantHolder(TypeProtos.MinorType.DATE, expr.getDate());
        }

        @Override
        public ConstantHolder visitTimeConstant(ValueExpressions.TimeExpression expr, Void value) throws RuntimeException {
            return new ConstantHolder(TypeProtos.MinorType.TIME, expr.getTime());
        }

        @Override
        public ConstantHolder visitTimeStampConstant(ValueExpressions.TimeStampExpression expr, Void value) throws RuntimeException {
            return new ConstantHolder(TypeProtos.MinorType.TIMESTAMP, expr.getTimeStamp());
        }

        @Override
        public ConstantHolder visitIntervalYearConstant(ValueExpressions.IntervalYearExpression expr, Void value) throws RuntimeException {
            return new ConstantHolder(TypeProtos.MinorType.INTERVALYEAR, expr.getIntervalYear());
        }

        @Override
        public ConstantHolder visitIntervalDayConstant(ValueExpressions.IntervalDayExpression expr, Void value) throws RuntimeException {
            return new ConstantHolder(TypeProtos.MinorType.INTERVALDAY, Pair.of((Object)expr.getIntervalDay(), (Object)expr.getIntervalMillis()));
        }

        @Override
        public ConstantHolder visitUnknown(LogicalExpression e, Void valueArg) throws RuntimeException {
            return null;
        }
    }

    private static class ColRefExtractor
    extends AbstractExprVisitor<String, Void, RuntimeException> {
        private ColRefExtractor() {
        }

        @Override
        public String visitSchemaPath(SchemaPath path, Void value) throws RuntimeException {
            if (!path.isLeaf()) {
                return null;
            }
            return path.getRootSegmentPath();
        }

        @Override
        public String visitUnknown(LogicalExpression e, Void valueArg) throws RuntimeException {
            return null;
        }
    }

    private static class RelOpExtractor
    extends AbstractExprVisitor<ExprNode, Void, RuntimeException> {
        private RelOpExtractor() {
        }

        @Override
        public ExprNode visitBooleanOperator(BooleanOperator op, Void value) throws RuntimeException {
            switch (op.getName()) {
                case "booleanOr": {
                    break;
                }
                case "booleanAnd": {
                    break;
                }
                default: {
                    return null;
                }
            }
            List<ExprNode> args = op.args().stream().map(a -> a.accept(this, null)).collect(Collectors.toList());
            switch (op.getName()) {
                case "booleanOr": {
                    return new ExprNode.OrNode(args);
                }
                case "booleanAnd": {
                    return new ExprNode.AndNode(args);
                }
            }
            return null;
        }

        @Override
        public ExprNode visitFunctionCall(FunctionCall call, Void value) throws RuntimeException {
            RelOp op;
            switch (call.getName()) {
                case "equal": {
                    op = RelOp.EQ;
                    break;
                }
                case "not_equal": {
                    op = RelOp.NE;
                    break;
                }
                case "less_than": {
                    op = RelOp.LT;
                    break;
                }
                case "less_than_or_equal_to": {
                    op = RelOp.LE;
                    break;
                }
                case "greater_than": {
                    op = RelOp.GT;
                    break;
                }
                case "greater_than_or_equal_to": {
                    op = RelOp.GE;
                    break;
                }
                case "isnull": {
                    op = RelOp.IS_NULL;
                    break;
                }
                case "isnotnull": {
                    op = RelOp.IS_NOT_NULL;
                    break;
                }
                default: {
                    return null;
                }
            }
            if (op.argCount() == 1) {
                return this.checkCol(op, call);
            }
            ExprNode relOpNode = this.checkColOpConst(op, call);
            if (relOpNode == null) {
                relOpNode = this.checkConstOpCol(op, call);
            }
            return relOpNode;
        }

        private ExprNode checkCol(RelOp op, FunctionCall call) {
            String colName = call.arg(0).accept(COL_REF_EXTRACTOR, null);
            if (colName == null) {
                return null;
            }
            return new ExprNode.ColRelOpConstNode(colName, op, null);
        }

        private ExprNode checkColOpConst(RelOp op, FunctionCall call) {
            String colName = call.arg(0).accept(COL_REF_EXTRACTOR, null);
            if (colName == null) {
                return null;
            }
            ConstantHolder constArg = call.arg(1).accept(CONSTANT_EXTRACTOR, null);
            if (constArg == null) {
                return null;
            }
            return new ExprNode.ColRelOpConstNode(colName, op, constArg);
        }

        private ExprNode checkConstOpCol(RelOp op, FunctionCall call) {
            ConstantHolder constArg = call.arg(0).accept(CONSTANT_EXTRACTOR, null);
            if (constArg == null) {
                return null;
            }
            String colName = call.arg(1).accept(COL_REF_EXTRACTOR, null);
            if (colName == null) {
                return null;
            }
            return new ExprNode.ColRelOpConstNode(colName, op.invert(), constArg);
        }

        @Override
        public ExprNode visitUnknown(LogicalExpression e, Void value) throws RuntimeException {
            return null;
        }
    }
}

