/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.base.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.util.Pair;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.planner.common.DrillRelOptUtil;
import org.apache.drill.exec.planner.logical.DrillFilterRel;
import org.apache.drill.exec.planner.logical.DrillOptiq;
import org.apache.drill.exec.planner.logical.DrillParseContext;
import org.apache.drill.exec.planner.logical.DrillProjectRel;
import org.apache.drill.exec.planner.logical.DrillScanRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.FilterPrel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.store.StoragePluginOptimizerRule;
import org.apache.drill.exec.store.base.filter.ExprNode;
import org.apache.drill.exec.store.base.filter.FilterPushDownListener;
import org.apache.drill.exec.store.base.filter.FilterPushDownUtils;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableSet;

public class FilterPushDownStrategy {
    private static final Collection<String> BANNED_OPERATORS = Collections.singletonList("flatten");
    private final FilterPushDownListener listener;

    public FilterPushDownStrategy(FilterPushDownListener listener) {
        this.listener = listener;
    }

    public Set<StoragePluginOptimizerRule> rules() {
        return ImmutableSet.of(new ProjectAndFilterRule(this), new FilterWithoutProjectRule(this));
    }

    public static Set<StoragePluginOptimizerRule> rulesFor(FilterPushDownListener listener) {
        return new FilterPushDownStrategy(listener).rules();
    }

    private String namePrefix() {
        return this.listener.prefix();
    }

    private boolean isTargetScan(DrillScanRel scan) {
        return this.listener.isTargetScan(scan.getGroupScan());
    }

    public void onMatch(RelOptRuleCall call, DrillFilterRel filter, DrillProjectRel project, DrillScanRel scan) {
        FilterPushDownListener.ScanPushDownListener scanListener = this.listener.builderFor(scan.getGroupScan());
        if (scanListener != null) {
            new FilterPushDownBuilder(call, filter, project, scan, scanListener).apply();
        }
    }

    private static class ProjectAndFilterRule
    extends AbstractFilterPushDownRule {
        private ProjectAndFilterRule(FilterPushDownStrategy strategy) {
            super(RelOptHelper.some(FilterPrel.class, RelOptHelper.some(DrillProjectRel.class, RelOptHelper.any(DrillScanRel.class), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), strategy.namePrefix() + "PushDownFilter:Filter_On_Project", strategy);
        }

        public boolean matches(RelOptRuleCall call) {
            if (!super.matches(call)) {
                return false;
            }
            DrillScanRel scan = (DrillScanRel)call.rel(2);
            return this.strategy.isTargetScan(scan);
        }

        public void onMatch(RelOptRuleCall call) {
            DrillFilterRel filterRel = (DrillFilterRel)call.rel(0);
            DrillProjectRel projectRel = (DrillProjectRel)call.rel(1);
            DrillScanRel scanRel = (DrillScanRel)call.rel(2);
            this.strategy.onMatch(call, filterRel, projectRel, scanRel);
        }
    }

    private static class FilterWithoutProjectRule
    extends AbstractFilterPushDownRule {
        private FilterWithoutProjectRule(FilterPushDownStrategy strategy) {
            super(RelOptHelper.some(DrillFilterRel.class, RelOptHelper.any(DrillScanRel.class), new RelOptRuleOperand[0]), strategy.namePrefix() + "PushDownFilter:Filter_On_Scan", strategy);
        }

        public boolean matches(RelOptRuleCall call) {
            if (!super.matches(call)) {
                return false;
            }
            DrillScanRel scan = (DrillScanRel)call.rel(1);
            return this.strategy.isTargetScan(scan);
        }

        public void onMatch(RelOptRuleCall call) {
            DrillFilterRel filterRel = (DrillFilterRel)call.rel(0);
            DrillScanRel scanRel = (DrillScanRel)call.rel(1);
            this.strategy.onMatch(call, filterRel, null, scanRel);
        }
    }

    private static class FilterPushDownBuilder {
        private final RelOptRuleCall call;
        private final DrillFilterRel filter;
        private final DrillProjectRel project;
        private final DrillScanRel scan;
        private final FilterPushDownListener.ScanPushDownListener scanListener;
        List<RexNode> nonConvertedPreds = new ArrayList<RexNode>();

        protected FilterPushDownBuilder(RelOptRuleCall call, DrillFilterRel filter, DrillProjectRel project, DrillScanRel scan, FilterPushDownListener.ScanPushDownListener scanListener) {
            this.call = call;
            this.filter = filter;
            this.project = project;
            this.scan = scan;
            this.scanListener = scanListener;
        }

        void apply() {
            ExprNode.AndNode cnfNode = this.sortPredicates();
            if (cnfNode == null) {
                return;
            }
            Pair<GroupScan, List<RexNode>> translated = this.scanListener.transform(cnfNode);
            if (translated == null) {
                return;
            }
            GroupScan newGroupScan = (GroupScan)translated.left;
            if (newGroupScan == null) {
                return;
            }
            ArrayList<RexNode> remainingPreds = new ArrayList<RexNode>();
            remainingPreds.addAll(this.nonConvertedPreds);
            if (translated.right != null) {
                remainingPreds.addAll((Collection)translated.right);
            }
            this.call.transformTo(this.rebuildTree(newGroupScan, remainingPreds));
        }

        private ExprNode.AndNode sortPredicates() {
            RexNode condition = this.project == null ? this.filter.getCondition() : RelOptUtil.pushPastProject((RexNode)this.filter.getCondition(), (Project)this.project);
            if (condition == null || condition.isAlwaysTrue() || condition.isAlwaysFalse()) {
                return null;
            }
            List filterPreds = RelOptUtil.conjunctions((RexNode)RexUtil.toCnf((RexBuilder)this.filter.getCluster().getRexBuilder(), (RexNode)condition));
            DrillParseContext parseContext = new DrillParseContext(PrelUtil.getPlannerSettings(this.call.getPlanner()));
            ArrayList<ExprNode> conjuncts = new ArrayList<ExprNode>();
            for (RexNode pred : filterPreds) {
                ExprNode conjunct = this.identifyCandidate(parseContext, this.scan, pred);
                if (conjunct == null) {
                    this.nonConvertedPreds.add(pred);
                    continue;
                }
                conjunct.tag(pred);
                conjuncts.add(conjunct);
            }
            return conjuncts.isEmpty() ? null : new ExprNode.AndNode(conjuncts);
        }

        public ExprNode identifyCandidate(DrillParseContext parseContext, DrillScanRel scan, RexNode pred) {
            if (DrillRelOptUtil.findOperators(pred, Collections.emptyList(), BANNED_OPERATORS) != null) {
                return null;
            }
            LogicalExpression drillPredicate = DrillOptiq.toDrill(parseContext, scan, pred);
            ExprNode expr = drillPredicate.accept(FilterPushDownUtils.REL_OP_EXTRACTOR, null);
            if (expr == null) {
                return null;
            }
            return this.scanListener.accept(expr);
        }

        private RelNode rebuildTree(GroupScan newGroupScan, List<RexNode> remainingPreds) {
            DrillScanRel newNode = newGroupScan == null ? this.scan : new DrillScanRel(this.scan.getCluster(), this.scan.getTraitSet(), this.scan.getTable(), newGroupScan, this.scan.getRowType(), this.scan.getColumns());
            if (this.project != null) {
                newNode = this.project.copy(this.project.getTraitSet(), Collections.singletonList(newNode));
            }
            if (!remainingPreds.isEmpty()) {
                newNode = this.filter.copy(this.filter.getTraitSet(), newNode, RexUtil.composeConjunction((RexBuilder)this.filter.getCluster().getRexBuilder(), remainingPreds, (boolean)true));
            }
            return newNode;
        }
    }

    private static abstract class AbstractFilterPushDownRule
    extends StoragePluginOptimizerRule {
        protected final FilterPushDownStrategy strategy;

        public AbstractFilterPushDownRule(RelOptRuleOperand operand, String description, FilterPushDownStrategy strategy) {
            super(operand, description);
            this.strategy = strategy;
        }
    }
}

