/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.base.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.math.BigDecimal;
import org.apache.drill.common.PlanStringBuilder;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

@JsonPropertyOrder(value={"type", "value"})
public class ConstantHolder
implements Comparable<ConstantHolder> {
    @JsonProperty(value="type")
    public final TypeProtos.MinorType type;
    @JsonProperty(value="value")
    public final Object value;

    @JsonCreator
    public ConstantHolder(@JsonProperty(value="type") TypeProtos.MinorType type, @JsonProperty(value="value") Object value) {
        this.type = type;
        this.value = value;
    }

    public static ConstantHolder bitValue(boolean value) {
        return new ConstantHolder(TypeProtos.MinorType.BIT, value);
    }

    public static ConstantHolder smallIntValue(int value) {
        return new ConstantHolder(TypeProtos.MinorType.SMALLINT, (short)value);
    }

    public static ConstantHolder intValue(int value) {
        return new ConstantHolder(TypeProtos.MinorType.INT, value);
    }

    public static ConstantHolder bigIntValue(long value) {
        return new ConstantHolder(TypeProtos.MinorType.BIGINT, value);
    }

    public static ConstantHolder float4Value(float value) {
        return new ConstantHolder(TypeProtos.MinorType.FLOAT4, Float.valueOf(value));
    }

    public static ConstantHolder float8Value(double value) {
        return new ConstantHolder(TypeProtos.MinorType.FLOAT8, value);
    }

    public static ConstantHolder decimalValue(BigDecimal value) {
        return new ConstantHolder(TypeProtos.MinorType.VARDECIMAL, value);
    }

    public static ConstantHolder varcharValue(String value) {
        return new ConstantHolder(TypeProtos.MinorType.VARCHAR, value);
    }

    public ConstantHolder convertTo(TypeProtos.MinorType toType) {
        if (this.type == toType) {
            return this;
        }
        switch (toType) {
            case INT: {
                return this.toInt();
            }
            case BIGINT: {
                return this.toBigInt();
            }
            case TIMESTAMP: {
                return this.toTimestamp(null);
            }
            case VARCHAR: {
                return this.toVarChar();
            }
            case FLOAT4: {
                return this.toFloat();
            }
            case FLOAT8: {
                return this.toDouble();
            }
            case VARDECIMAL: {
                return this.toDecimal();
            }
        }
        throw this.conversionError(toType);
    }

    public ConstantHolder normalize(TypeProtos.MinorType toType) {
        try {
            return this.convertTo(toType);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public ConstantHolder toInt() {
        int intValue;
        switch (this.type) {
            case SMALLINT: {
                intValue = ((Short)this.value).shortValue();
                break;
            }
            case INT: {
                return this;
            }
            case BIGINT: {
                long value = (Long)this.value;
                if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
                    throw this.conversionError(TypeProtos.MinorType.INT);
                }
                intValue = (int)value;
                break;
            }
            case VARCHAR: {
                try {
                    intValue = Integer.parseInt((String)this.value);
                    break;
                }
                catch (NumberFormatException e) {
                    throw this.conversionError(TypeProtos.MinorType.INT);
                }
            }
            case VARDECIMAL: {
                try {
                    intValue = ((BigDecimal)this.value).intValueExact();
                    break;
                }
                catch (NumberFormatException e) {
                    throw this.conversionError(TypeProtos.MinorType.INT);
                }
            }
            default: {
                throw this.conversionError(TypeProtos.MinorType.INT);
            }
        }
        return new ConstantHolder(TypeProtos.MinorType.INT, intValue);
    }

    public ConstantHolder toBigInt() {
        long longValue;
        switch (this.type) {
            case SMALLINT: {
                longValue = ((Short)this.value).shortValue();
                break;
            }
            case INT: {
                longValue = ((Integer)this.value).intValue();
                break;
            }
            case BIGINT: {
                return this;
            }
            case VARCHAR: {
                try {
                    longValue = Long.parseLong((String)this.value);
                    break;
                }
                catch (NumberFormatException e) {
                    throw this.conversionError(TypeProtos.MinorType.BIGINT);
                }
            }
            case VARDECIMAL: {
                try {
                    longValue = ((BigDecimal)this.value).longValueExact();
                    break;
                }
                catch (NumberFormatException e) {
                    throw this.conversionError(TypeProtos.MinorType.INT);
                }
            }
            default: {
                throw this.conversionError(TypeProtos.MinorType.BIGINT);
            }
        }
        return new ConstantHolder(TypeProtos.MinorType.BIGINT, longValue);
    }

    public ConstantHolder toTimestamp(String tz) {
        long longValue;
        switch (this.type) {
            case TIMESTAMP: {
                return this;
            }
            case INT: {
                longValue = ((Integer)this.value).intValue();
                break;
            }
            case BIGINT: {
                longValue = (Long)this.value;
                break;
            }
            case VARCHAR: {
                DateTimeFormatter format = ISODateTimeFormat.dateTimeNoMillis();
                if (tz != null) {
                    format = format.withZone(DateTimeZone.forID((String)tz));
                }
                try {
                    longValue = format.parseDateTime((String)this.value).getMillis();
                    break;
                }
                catch (Exception e) {
                    throw this.conversionError(TypeProtos.MinorType.TIMESTAMP);
                }
            }
            default: {
                throw this.conversionError(TypeProtos.MinorType.TIMESTAMP);
            }
        }
        return new ConstantHolder(TypeProtos.MinorType.TIMESTAMP, longValue);
    }

    public ConstantHolder toVarChar() {
        if (this.type == TypeProtos.MinorType.VARCHAR) {
            return this;
        }
        return new ConstantHolder(TypeProtos.MinorType.VARCHAR, this.value.toString());
    }

    public ConstantHolder toFloat() {
        float floatValue;
        switch (this.type) {
            case BIGINT: {
                floatValue = ((Long)this.value).longValue();
                break;
            }
            case INT: {
                floatValue = ((Integer)this.value).intValue();
                break;
            }
            case FLOAT4: {
                return this;
            }
            case VARCHAR: {
                try {
                    floatValue = Float.parseFloat((String)this.value);
                    break;
                }
                catch (Exception e) {
                    throw this.conversionError(TypeProtos.MinorType.FLOAT8);
                }
            }
            case VARDECIMAL: {
                floatValue = ((BigDecimal)this.value).floatValue();
                break;
            }
            default: {
                throw this.conversionError(TypeProtos.MinorType.FLOAT4);
            }
        }
        return new ConstantHolder(TypeProtos.MinorType.FLOAT4, Float.valueOf(floatValue));
    }

    public ConstantHolder toDouble() {
        double doubleValue;
        switch (this.type) {
            case SMALLINT: {
                doubleValue = ((Short)this.value).shortValue();
                break;
            }
            case INT: {
                doubleValue = ((Integer)this.value).intValue();
                break;
            }
            case BIGINT: {
                doubleValue = ((Long)this.value).longValue();
                break;
            }
            case FLOAT4: {
                doubleValue = ((Float)this.value).floatValue();
                break;
            }
            case FLOAT8: {
                return this;
            }
            case VARCHAR: {
                try {
                    doubleValue = Double.parseDouble((String)this.value);
                    break;
                }
                catch (Exception e) {
                    throw this.conversionError(TypeProtos.MinorType.FLOAT8);
                }
            }
            case VARDECIMAL: {
                doubleValue = ((BigDecimal)this.value).doubleValue();
                break;
            }
            default: {
                throw this.conversionError(TypeProtos.MinorType.FLOAT8);
            }
        }
        return new ConstantHolder(TypeProtos.MinorType.FLOAT8, doubleValue);
    }

    public ConstantHolder toDecimal() {
        BigDecimal decimalValue;
        switch (this.type) {
            case SMALLINT: {
                decimalValue = BigDecimal.valueOf(((Short)this.value).shortValue());
                break;
            }
            case INT: {
                decimalValue = BigDecimal.valueOf(((Integer)this.value).intValue());
                break;
            }
            case BIGINT: {
                decimalValue = BigDecimal.valueOf((Long)this.value);
                break;
            }
            case FLOAT4: {
                decimalValue = BigDecimal.valueOf(((Float)this.value).floatValue());
                break;
            }
            case FLOAT8: {
                decimalValue = BigDecimal.valueOf((Double)this.value);
                break;
            }
            case VARCHAR: {
                try {
                    decimalValue = new BigDecimal((String)this.value);
                    break;
                }
                catch (Exception e) {
                    throw this.conversionError(TypeProtos.MinorType.VARDECIMAL);
                }
            }
            case VARDECIMAL: {
                return this;
            }
            default: {
                throw this.conversionError(TypeProtos.MinorType.VARDECIMAL);
            }
        }
        return new ConstantHolder(TypeProtos.MinorType.VARDECIMAL, decimalValue);
    }

    public RuntimeException conversionError(TypeProtos.MinorType toType) {
        return new IllegalStateException(String.format("Cannot convert a constant %s of type %s to type %s", this.value.toString(), this.type.name(), toType.name()));
    }

    public String toString() {
        return new PlanStringBuilder("Constant").field("type", this.type.name()).field("value", this.value).toString();
    }

    @Override
    public int compareTo(ConstantHolder other) {
        Preconditions.checkArgument(this.type == other.type);
        switch (this.type) {
            case BIGINT: {
                return Long.compare((Long)this.value, (Long)other.value);
            }
            case BIT: {
                return Boolean.compare((Boolean)this.value, (Boolean)other.value);
            }
            case FLOAT4: {
                return Float.compare(((Float)this.value).floatValue(), ((Float)other.value).floatValue());
            }
            case FLOAT8: {
                return Double.compare((Double)this.value, (Double)other.value);
            }
            case INT: {
                return Integer.compare((Integer)this.value, (Integer)other.value);
            }
            case VARCHAR: {
                return ((String)this.value).compareTo((String)other.value);
            }
            case VARDECIMAL: {
                return ((BigDecimal)this.value).compareTo((BigDecimal)other.value);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported comparison between types %s and %s. Convert values first.", this.type.name(), other.type.name()));
    }
}

