/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.avro;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.DictBuilder;
import org.apache.drill.exec.record.metadata.MapBuilder;
import org.apache.drill.exec.record.metadata.MetadataUtils;
import org.apache.drill.exec.record.metadata.RepeatedListBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.TupleSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSchemaUtil {
    private static final Logger logger = LoggerFactory.getLogger(AvroSchemaUtil.class);
    public static final String AVRO_LOGICAL_TYPE_PROPERTY = "avro_logical_type";
    public static final String DECIMAL_LOGICAL_TYPE = "decimal";
    public static final String TIMESTAMP_MICROS_LOGICAL_TYPE = "timestamp-micros";
    public static final String TIMESTAMP_MILLIS_LOGICAL_TYPE = "timestamp-millis";
    public static final String DATE_LOGICAL_TYPE = "date";
    public static final String TIME_MICROS_LOGICAL_TYPE = "time-micros";
    public static final String TIME_MILLIS_LOGICAL_TYPE = "time-millis";
    public static final String DURATION_LOGICAL_TYPE = "duration";

    public static TupleMetadata convert(Schema schema) {
        return SchemaConverter.INSTANCE.convert(schema);
    }

    public static Schema extractSchemaFromNullable(Schema schema, String columnName) {
        if (!schema.isUnion()) {
            throw UserException.validationError().message("Expected union type, but received: %s", schema.getType()).addContext("Column", columnName).build(logger);
        }
        List unionSchemas = schema.getTypes();
        List nonNullSchemas = unionSchemas.stream().filter(unionSchema -> !Schema.Type.NULL.equals((Object)unionSchema.getType())).collect(Collectors.toList());
        if (unionSchemas.size() == 2 && nonNullSchemas.size() == 1) {
            return (Schema)nonNullSchemas.get(0);
        }
        return (Schema)AvroSchemaUtil.throwUnsupportedErrorForType("complex union", columnName);
    }

    private static <T> T throwUnsupportedErrorForType(String type, String columnName) {
        throw UserException.unsupportedError().message("'%s' type is not supported", type).addContext("Column", columnName).build(logger);
    }

    private static class SchemaConverter {
        private static final SchemaConverter INSTANCE = new SchemaConverter();

        private SchemaConverter() {
        }

        TupleMetadata convert(Schema schema) {
            HashSet<String> typeNamesUnderConstruction = new HashSet<String>();
            TupleSchema tupleSchema = new TupleSchema();
            typeNamesUnderConstruction.add(schema.getFullName());
            List fields = schema.getFields();
            fields.stream().map(field -> this.convert((Schema.Field)field, (Set<String>)typeNamesUnderConstruction)).forEach(tupleSchema::add);
            return tupleSchema;
        }

        private ColumnMetadata convert(Schema.Field field, Set<String> typeNamesUnderConstruction) {
            Schema fieldSchema = field.schema();
            return this.defineColumn(field.name(), fieldSchema, TypeProtos.DataMode.REQUIRED, typeNamesUnderConstruction);
        }

        private ColumnMetadata defineColumn(String name, Schema fieldSchema, TypeProtos.DataMode mode, Set<String> typeNamesUnderConstruction) {
            String logicalTypeName = this.getLogicalTypeName(fieldSchema);
            switch (fieldSchema.getType()) {
                case INT: {
                    switch (logicalTypeName) {
                        case "date": {
                            return this.initField(name, TypeProtos.MinorType.DATE, mode);
                        }
                        case "time-millis": {
                            return this.initField(name, TypeProtos.MinorType.TIME, mode);
                        }
                    }
                    return this.initField(name, TypeProtos.MinorType.INT, mode);
                }
                case LONG: {
                    switch (logicalTypeName) {
                        case "timestamp-micros": 
                        case "timestamp-millis": {
                            ColumnMetadata timestampColumn = this.initField(name, TypeProtos.MinorType.TIMESTAMP, mode);
                            timestampColumn.setProperty(AvroSchemaUtil.AVRO_LOGICAL_TYPE_PROPERTY, logicalTypeName);
                            return timestampColumn;
                        }
                        case "time-micros": {
                            return this.initField(name, TypeProtos.MinorType.TIME, mode);
                        }
                    }
                    return this.initField(name, TypeProtos.MinorType.BIGINT, mode);
                }
                case FLOAT: {
                    return this.initField(name, TypeProtos.MinorType.FLOAT4, mode);
                }
                case DOUBLE: {
                    return this.initField(name, TypeProtos.MinorType.FLOAT8, mode);
                }
                case FIXED: {
                    if (AvroSchemaUtil.DURATION_LOGICAL_TYPE.equals(logicalTypeName)) {
                        return this.initField(name, TypeProtos.MinorType.INTERVAL, mode);
                    }
                }
                case BYTES: {
                    if (AvroSchemaUtil.DECIMAL_LOGICAL_TYPE.equals(logicalTypeName)) {
                        LogicalTypes.Decimal decimalLogicalType = (LogicalTypes.Decimal)fieldSchema.getLogicalType();
                        TypeProtos.MajorType majorType = Types.withPrecisionAndScale(TypeProtos.MinorType.VARDECIMAL, mode, decimalLogicalType.getPrecision(), decimalLogicalType.getScale());
                        return this.initField(name, majorType);
                    }
                    return this.initField(name, TypeProtos.MinorType.VARBINARY, mode);
                }
                case BOOLEAN: {
                    return this.initField(name, TypeProtos.MinorType.BIT, mode);
                }
                case ENUM: 
                case STRING: {
                    return this.initField(name, TypeProtos.MinorType.VARCHAR, mode);
                }
                case NULL: {
                    return this.initField(name, TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL);
                }
                case UNION: {
                    Schema schema = AvroSchemaUtil.extractSchemaFromNullable(fieldSchema, name);
                    TypeProtos.DataMode nullableMode = TypeProtos.DataMode.REPEATED == mode ? TypeProtos.DataMode.REPEATED : TypeProtos.DataMode.OPTIONAL;
                    return this.defineColumn(name, schema, nullableMode, typeNamesUnderConstruction);
                }
                case RECORD: {
                    MapBuilder recordBuilder = new MapBuilder(null, name, mode);
                    String typeName = fieldSchema.getFullName();
                    if (typeNamesUnderConstruction.add(typeName)) {
                        fieldSchema.getFields().stream().map(field -> this.convert((Schema.Field)field, typeNamesUnderConstruction)).forEach(recordBuilder::addColumn);
                        typeNamesUnderConstruction.remove(typeName);
                    }
                    return recordBuilder.buildColumn();
                }
                case ARRAY: {
                    boolean hasNestedArray;
                    Schema elementSchema = fieldSchema.getElementType();
                    boolean bl = elementSchema.isUnion() ? Schema.Type.ARRAY == AvroSchemaUtil.extractSchemaFromNullable(elementSchema, name).getType() : (hasNestedArray = Schema.Type.ARRAY == elementSchema.getType());
                    if (hasNestedArray) {
                        RepeatedListBuilder builder = new RepeatedListBuilder(null, name);
                        builder.addColumn(this.defineColumn(name, elementSchema, TypeProtos.DataMode.REQUIRED, typeNamesUnderConstruction));
                        return builder.buildColumn();
                    }
                    return this.defineColumn(name, elementSchema, TypeProtos.DataMode.REPEATED, typeNamesUnderConstruction);
                }
                case MAP: {
                    DictBuilder dictBuilder = new DictBuilder(null, name, mode);
                    dictBuilder.key(TypeProtos.MinorType.VARCHAR);
                    Schema valueSchema = fieldSchema.getValueType();
                    ColumnMetadata valueColumn = this.defineColumn("value", valueSchema, TypeProtos.DataMode.REQUIRED, typeNamesUnderConstruction);
                    dictBuilder.addColumn(valueColumn);
                    return dictBuilder.buildColumn();
                }
            }
            return (ColumnMetadata)AvroSchemaUtil.throwUnsupportedErrorForType(fieldSchema.getType().getName(), name);
        }

        private String getLogicalTypeName(Schema schema) {
            String name = schema.getLogicalType() != null ? schema.getLogicalType().getName() : schema.getProp("logicalType");
            return name == null ? "" : name;
        }

        private ColumnMetadata initField(String name, TypeProtos.MinorType minorType, TypeProtos.DataMode mode) {
            TypeProtos.MajorType majorType = Types.withMode(minorType, mode);
            return this.initField(name, majorType);
        }

        private ColumnMetadata initField(String name, TypeProtos.MajorType majorType) {
            MaterializedField materializedField = MaterializedField.create(name, majorType);
            return MetadataUtils.fromField(materializedField);
        }
    }
}

