/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.avro;

import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.physical.impl.scan.v3.ManagedReader;
import org.apache.drill.exec.physical.impl.scan.v3.file.FileReaderFactory;
import org.apache.drill.exec.physical.impl.scan.v3.file.FileScanLifecycleBuilder;
import org.apache.drill.exec.physical.impl.scan.v3.file.FileSchemaNegotiator;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.avro.AvroBatchReader;
import org.apache.drill.exec.store.avro.AvroFormatConfig;
import org.apache.drill.exec.store.dfs.easy.EasyFormatPlugin;
import org.apache.drill.exec.store.dfs.easy.EasySubScan;
import org.apache.hadoop.conf.Configuration;

public class AvroFormatPlugin
extends EasyFormatPlugin<AvroFormatConfig> {
    public static final String DEFAULT_NAME = "avro";

    public AvroFormatPlugin(String name, DrillbitContext context, Configuration fsConf, StoragePluginConfig storageConfig, AvroFormatConfig formatConfig) {
        super(name, AvroFormatPlugin.easyConfig(fsConf, formatConfig), context, storageConfig, formatConfig);
    }

    private static EasyFormatPlugin.EasyFormatConfig easyConfig(Configuration fsConf, AvroFormatConfig formatConfig) {
        return EasyFormatPlugin.EasyFormatConfig.builder().readable(true).writable(false).blockSplittable(true).compressible(false).supportsProjectPushdown(true).extensions(formatConfig.getExtensions()).fsConf(fsConf).defaultName(DEFAULT_NAME).scanVersion(EasyFormatPlugin.ScanFrameworkVersion.EVF_V2).supportsLimitPushdown(true).build();
    }

    @Override
    protected void configureScan(FileScanLifecycleBuilder builder, EasySubScan scan) {
        builder.nullType(Types.optional(TypeProtos.MinorType.VARCHAR));
        builder.readerFactory(new AvroReaderFactory((AvroFormatConfig)this.formatConfig, scan));
    }

    private static class AvroReaderFactory
    extends FileReaderFactory {
        private final AvroFormatConfig config;
        private final EasySubScan scan;

        public AvroReaderFactory(AvroFormatConfig config, EasySubScan scan) {
            this.config = config;
            this.scan = scan;
        }

        @Override
        public ManagedReader newReader(FileSchemaNegotiator negotiator) throws ManagedReader.EarlyEofException {
            return new AvroBatchReader(this.config, this.scan, negotiator);
        }
    }
}

