/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.avro;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.apache.drill.exec.physical.impl.scan.v3.FixedReceiver;
import org.apache.drill.exec.physical.resultSet.RowSetLoader;
import org.apache.drill.exec.record.ColumnConverter;
import org.apache.drill.exec.record.ColumnConverterFactory;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.avro.AvroSchemaUtil;
import org.apache.drill.exec.vector.accessor.TupleWriter;
import org.apache.drill.exec.vector.accessor.ValueWriter;
import org.apache.drill.shaded.guava.com.google.common.base.Charsets;
import org.joda.time.Period;

public class AvroColumnConverterFactory
extends ColumnConverterFactory {
    public AvroColumnConverterFactory(TupleMetadata providedSchema) {
        super(providedSchema);
    }

    public List<ColumnConverter> initConverters(TupleMetadata providedSchema, TupleMetadata readerSchema, RowSetLoader rowWriter) {
        return IntStream.range(0, readerSchema.size()).mapToObj(i -> this.getConverter(providedSchema, readerSchema.metadata(i), rowWriter.column(i))).collect(Collectors.toList());
    }

    @Override
    public ColumnConverter.ScalarColumnConverter buildScalar(ColumnMetadata readerSchema, ValueWriter writer) {
        switch (readerSchema.type()) {
            case VARCHAR: {
                return new ColumnConverter.ScalarColumnConverter(value -> {
                    int length;
                    byte[] binary;
                    if (value instanceof Utf8) {
                        Utf8 utf8 = (Utf8)value;
                        binary = utf8.getBytes();
                        length = utf8.getByteLength();
                    } else {
                        binary = value.toString().getBytes(Charsets.UTF_8);
                        length = binary.length;
                    }
                    writer.setBytes(binary, length);
                });
            }
            case VARBINARY: {
                return new ColumnConverter.ScalarColumnConverter(value -> {
                    if (value instanceof ByteBuffer) {
                        ByteBuffer buf = (ByteBuffer)value;
                        writer.setBytes(buf.array(), buf.remaining());
                    } else {
                        byte[] bytes = ((GenericFixed)value).bytes();
                        writer.setBytes(bytes, bytes.length);
                    }
                });
            }
            case VARDECIMAL: {
                return new ColumnConverter.ScalarColumnConverter(value -> {
                    byte[] bytes;
                    if (value instanceof ByteBuffer) {
                        ByteBuffer decBuf = (ByteBuffer)value;
                        bytes = decBuf.array();
                    } else {
                        GenericFixed genericFixed = (GenericFixed)value;
                        bytes = genericFixed.bytes();
                    }
                    BigInteger bigInteger = bytes.length == 0 ? BigInteger.ZERO : new BigInteger(bytes);
                    BigDecimal decimalValue = new BigDecimal(bigInteger, readerSchema.scale());
                    writer.setDecimal(decimalValue);
                });
            }
            case TIMESTAMP: {
                return new ColumnConverter.ScalarColumnConverter(value -> {
                    String avroLogicalType = readerSchema.property("avro_logical_type");
                    if ("timestamp-millis".equals(avroLogicalType)) {
                        writer.setLong((Long)value);
                    } else {
                        writer.setLong((Long)value / 1000L);
                    }
                });
            }
            case DATE: {
                return new ColumnConverter.ScalarColumnConverter(value -> writer.setLong((long)((Integer)value).intValue() * 86400000L));
            }
            case TIME: {
                return new ColumnConverter.ScalarColumnConverter(value -> {
                    if (value instanceof Long) {
                        writer.setInt((int)((Long)value / 1000L));
                    } else {
                        writer.setInt((Integer)value);
                    }
                });
            }
            case INTERVAL: {
                return new ColumnConverter.ScalarColumnConverter(value -> {
                    GenericFixed genericFixed = (GenericFixed)value;
                    IntBuffer intBuf = ByteBuffer.wrap(genericFixed.bytes()).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
                    Period period = Period.months((int)intBuf.get(0)).withDays(intBuf.get(1)).withMillis(intBuf.get(2));
                    writer.setPeriod(period);
                });
            }
            case FLOAT4: {
                return new ColumnConverter.ScalarColumnConverter(value -> writer.setDouble(((Float)value).floatValue()));
            }
            case BIT: {
                return new ColumnConverter.ScalarColumnConverter(value -> writer.setBoolean((Boolean)value));
            }
        }
        return super.buildScalar(readerSchema, writer);
    }

    @Override
    protected ColumnConverter getMapConverter(TupleMetadata providedSchema, TupleMetadata readerSchema, TupleWriter tupleWriter) {
        List<ColumnConverter> converters = IntStream.range(0, readerSchema.size()).mapToObj(i -> this.getConverter(providedSchema, readerSchema.metadata(i), tupleWriter.column(i))).collect(Collectors.toList());
        return new MapColumnConverter(this, providedSchema, tupleWriter, converters);
    }

    public void buildMapMembers(GenericRecord genericRecord, TupleMetadata providedSchema, TupleWriter tupleWriter, List<ColumnConverter> converters) {
        TupleMetadata readerSchema = AvroSchemaUtil.convert(genericRecord.getSchema());
        TupleMetadata tableSchema = FixedReceiver.Builder.mergeSchemas(providedSchema, readerSchema);
        tableSchema.toMetadataList().forEach(tupleWriter::addColumn);
        IntStream.range(0, tableSchema.size()).mapToObj(i -> this.getConverter(providedSchema, readerSchema.metadata(i), tupleWriter.column(i))).forEach(converters::add);
    }

    public static class MapColumnConverter
    implements ColumnConverter {
        private final AvroColumnConverterFactory factory;
        private final TupleMetadata providedSchema;
        private final TupleWriter tupleWriter;
        private final List<ColumnConverter> converters;

        public MapColumnConverter(AvroColumnConverterFactory factory, TupleMetadata providedSchema, TupleWriter tupleWriter, List<ColumnConverter> converters) {
            this.factory = factory;
            this.providedSchema = providedSchema;
            this.tupleWriter = tupleWriter;
            this.converters = new ArrayList<ColumnConverter>(converters);
        }

        @Override
        public void convert(Object value) {
            if (value == null) {
                return;
            }
            GenericRecord genericRecord = (GenericRecord)value;
            if (this.converters.isEmpty()) {
                this.factory.buildMapMembers(genericRecord, this.providedSchema, this.tupleWriter, this.converters);
            }
            IntStream.range(0, this.converters.size()).forEach(i -> this.converters.get(i).convert(genericRecord.get(i)));
        }
    }
}

