/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.avro;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.FsInput;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.common.PlanStringBuilder;
import org.apache.drill.common.exceptions.CustomErrorContext;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.physical.impl.scan.v3.FixedReceiver;
import org.apache.drill.exec.physical.impl.scan.v3.ManagedReader;
import org.apache.drill.exec.physical.impl.scan.v3.file.FileDescrip;
import org.apache.drill.exec.physical.impl.scan.v3.file.FileSchemaNegotiator;
import org.apache.drill.exec.physical.resultSet.ResultSetLoader;
import org.apache.drill.exec.physical.resultSet.RowSetLoader;
import org.apache.drill.exec.record.ColumnConverter;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.avro.AvroColumnConverterFactory;
import org.apache.drill.exec.store.avro.AvroFormatConfig;
import org.apache.drill.exec.store.avro.AvroSchemaUtil;
import org.apache.drill.exec.store.dfs.easy.EasySubScan;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroBatchReader
implements ManagedReader {
    private static final Logger logger = LoggerFactory.getLogger(AvroBatchReader.class);
    private final Path filePath;
    private final long endPosition;
    private final DataFileReader<GenericRecord> reader;
    private final RowSetLoader loader;
    private final ColumnConverter converter;
    private final CustomErrorContext errorContext;
    private GenericRecord record;

    public AvroBatchReader(AvroFormatConfig config, EasySubScan scan, FileSchemaNegotiator negotiator) {
        this.errorContext = negotiator.parentErrorContext();
        FileDescrip file = negotiator.file();
        this.filePath = file.split().getPath();
        long startPosition = file.split().getStart();
        this.endPosition = startPosition + file.split().getLength();
        logger.debug("Processing Avro file: {}, start position: {}, end position: {}", new Object[]{this.filePath, startPosition, this.endPosition});
        this.reader = this.prepareReader(file.split(), file.fileSystem(), negotiator.userName(), negotiator.context().getFragmentContext().getQueryUserName());
        logger.debug("Avro file schema: {}", (Object)this.reader.getSchema());
        TupleMetadata readerSchema = AvroSchemaUtil.convert(this.reader.getSchema());
        logger.debug("Avro file converted schema: {}", (Object)readerSchema);
        TupleMetadata providedSchema = negotiator.providedSchema();
        TupleMetadata tableSchema = FixedReceiver.Builder.mergeSchemas(providedSchema, readerSchema);
        logger.debug("Avro file table schema: {}", (Object)tableSchema);
        negotiator.tableSchema(tableSchema, true);
        ResultSetLoader setLoader = negotiator.build();
        this.loader = setLoader.writer();
        AvroColumnConverterFactory factory = new AvroColumnConverterFactory(providedSchema);
        this.converter = factory.getRootConverter(providedSchema, readerSchema, this.loader);
    }

    @Override
    public boolean next() {
        while (!this.loader.isFull()) {
            if (this.nextLine(this.loader)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        AutoCloseables.closeSilently(new AutoCloseable[]{this.reader});
    }

    public String toString() {
        long currentPosition = -1L;
        try {
            if (this.reader != null) {
                currentPosition = this.reader.tell();
            }
        }
        catch (IOException e) {
            logger.trace("Unable to obtain Avro reader position: {}", (Object)e.getMessage(), (Object)e);
        }
        return new PlanStringBuilder(this).unquotedField("File", this.filePath.toString()).unquotedField("Position", String.valueOf(currentPosition)).toString();
    }

    private boolean nextLine(RowSetLoader rowWriter) {
        try {
            if (!this.reader.hasNext() || this.reader.pastSync(this.endPosition)) {
                return false;
            }
            this.record = (GenericRecord)this.reader.next((Object)this.record);
        }
        catch (IOException e) {
            throw UserException.dataReadError(e).addContext(e.getMessage()).addContext(this.errorContext).build(logger);
        }
        Schema schema = this.record.getSchema();
        if (Schema.Type.RECORD != schema.getType()) {
            throw UserException.dataReadError().message("Root object must be record type. Found: %s", schema.getType()).addContext(this.errorContext).build(logger);
        }
        rowWriter.start();
        this.converter.convert(this.record);
        rowWriter.save();
        return true;
    }

    private DataFileReader<GenericRecord> prepareReader(FileSplit fileSplit, FileSystem fs, String opUserName, String queryUserName) {
        try {
            UserGroupInformation ugi = ImpersonationUtil.createProxyUgi(opUserName, queryUserName);
            DataFileReader reader = (DataFileReader)ugi.doAs(() -> new DataFileReader((SeekableInput)new FsInput(fileSplit.getPath(), fs.getConf()), (DatumReader)new GenericDatumReader()));
            reader.sync(fileSplit.getStart());
            return reader;
        }
        catch (IOException | InterruptedException e) {
            throw UserException.dataReadError(e).message("Error preparing Avro reader", new Object[0]).addContext(e.getMessage()).addContext(this.errorContext).build(logger);
        }
    }
}

