/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageStrategy {
    private static final Logger logger = LoggerFactory.getLogger(StorageStrategy.class);
    public static final StorageStrategy DEFAULT = new StorageStrategy("002", false);
    public static final StorageStrategy TEMPORARY = new StorageStrategy("077", true);
    private final String umask;
    private final boolean deleteOnExit;

    @JsonCreator
    public StorageStrategy(@JsonProperty(value="umask") String umask, @JsonProperty(value="deleteOnExit") boolean deleteOnExit) {
        this.umask = this.validateUmask(umask);
        this.deleteOnExit = deleteOnExit;
    }

    public String getUmask() {
        return this.umask;
    }

    public boolean isDeleteOnExit() {
        return this.deleteOnExit;
    }

    @JsonIgnore
    public FsPermission getFolderPermission() {
        return FsPermission.getDirDefault().applyUMask(new FsPermission(this.umask));
    }

    @JsonIgnore
    public FsPermission getFilePermission() {
        return FsPermission.getFileDefault().applyUMask(new FsPermission(this.umask));
    }

    public Path createPathAndApply(FileSystem fs, Path path) throws IOException {
        List<Path> locations = this.getNonExistentLocations(fs, path);
        if (locations.isEmpty()) {
            return null;
        }
        fs.mkdirs(path);
        for (Path location : locations) {
            this.applyStrategy(fs, location, this.getFolderPermission(), this.deleteOnExit);
        }
        return locations.get(locations.size() - 1);
    }

    public Path createFileAndApply(FileSystem fs, Path file) throws IOException {
        List<Path> locations = this.getNonExistentLocations(fs, file.getParent());
        if (!fs.createNewFile(file)) {
            throw new IOException(String.format("File [%s] already exists on file system [%s].", file.toUri().getPath(), fs.getUri()));
        }
        this.applyToFile(fs, file);
        if (locations.isEmpty()) {
            return file;
        }
        for (Path location : locations) {
            this.applyStrategy(fs, location, this.getFolderPermission(), this.deleteOnExit);
        }
        return locations.get(locations.size() - 1);
    }

    public void applyToFile(FileSystem fs, Path file) throws IOException {
        this.applyStrategy(fs, file, this.getFilePermission(), this.deleteOnExit);
    }

    private String validateUmask(String umask) {
        try {
            new FsPermission(umask);
            return umask;
        }
        catch (IllegalArgumentException | NullPointerException e) {
            logger.error("Invalid umask value [{}]. Using default [{}].", new Object[]{umask, DEFAULT.getUmask(), e});
            return DEFAULT.getUmask();
        }
    }

    private List<Path> getNonExistentLocations(FileSystem fs, Path path) throws IOException {
        ArrayList<Path> locations = Lists.newArrayList();
        for (Path starting = path; starting != null && !fs.exists(starting); starting = starting.getParent()) {
            locations.add(starting);
        }
        return locations;
    }

    private void applyStrategy(FileSystem fs, Path path, FsPermission permission, boolean deleteOnExit) throws IOException {
        fs.setPermission(path, permission);
        if (deleteOnExit) {
            fs.deleteOnExit(path);
        }
    }

    public String toString() {
        return "StorageStrategy[umask=" + this.umask + ", deleteOnExist=" + this.deleteOnExit + "]";
    }
}

