/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import java.util.Iterator;
import java.util.Map;
import org.apache.drill.common.config.LogicalPlanPersistence;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.exception.StoreException;
import org.apache.drill.exec.planner.logical.StoragePlugins;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.StoragePluginStore;
import org.apache.drill.exec.store.sys.CaseInsensitivePersistentStore;
import org.apache.drill.exec.store.sys.PersistentStore;
import org.apache.drill.exec.store.sys.PersistentStoreConfig;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoragePluginStoreImpl
implements StoragePluginStore {
    private static final Logger logger = LoggerFactory.getLogger(StoragePluginStoreImpl.class);
    private final PersistentStore<StoragePluginConfig> pluginSystemTable;

    public StoragePluginStoreImpl(DrillbitContext context) {
        this.pluginSystemTable = this.initPluginsSystemTable(context, Preconditions.checkNotNull(context.getLpPersistence()));
    }

    private PersistentStore<StoragePluginConfig> initPluginsSystemTable(DrillbitContext context, LogicalPlanPersistence lpPersistence) {
        try {
            PersistentStore<StoragePluginConfig> pluginSystemTable = context.getStoreProvider().getOrCreateStore(PersistentStoreConfig.newJacksonBuilder(lpPersistence.getMapper(), StoragePluginConfig.class).name("sys.storage_plugins").build());
            Iterator<Map.Entry<String, StoragePluginConfig>> storedPlugins = pluginSystemTable.getAll();
            while (storedPlugins.hasNext()) {
                Map.Entry<String, StoragePluginConfig> entry = storedPlugins.next();
                String pluginName = entry.getKey();
                if (pluginName.equals(pluginName.toLowerCase())) continue;
                logger.debug("Replacing plugin name {} with its lower case equivalent.", (Object)pluginName);
                pluginSystemTable.delete(pluginName);
                if (pluginSystemTable.putIfAbsent(pluginName.toLowerCase(), entry.getValue())) continue;
                logger.warn("Duplicated storage plugin name [{}] is found. Duplicate is deleted from persistent storage.", (Object)pluginName);
            }
            return new CaseInsensitivePersistentStore<StoragePluginConfig>(pluginSystemTable);
        }
        catch (StoreException e) {
            throw new DrillRuntimeException("Failure while reading and loading storage plugin configuration.");
        }
    }

    @Override
    public boolean isInitialized() {
        return this.pluginSystemTable.getRange(0, 1).hasNext();
    }

    @Override
    public StoragePluginConfig get(String name) {
        return this.pluginSystemTable.get(name);
    }

    @Override
    public void put(String name, StoragePluginConfig config) {
        this.pluginSystemTable.put(name, config);
    }

    @Override
    public void delete(String name) {
        this.pluginSystemTable.delete(name);
    }

    @Override
    public Iterator<Map.Entry<String, StoragePluginConfig>> load() {
        return this.pluginSystemTable.getAll();
    }

    @Override
    public void putAll(StoragePlugins plugins) {
        for (Map.Entry<String, StoragePluginConfig> plugin : plugins) {
            this.put(plugin.getKey(), plugin.getValue());
        }
    }

    @Override
    public PersistentStore<StoragePluginConfig> getStore() {
        return this.pluginSystemTable;
    }

    @Override
    public void close() {
        try {
            this.pluginSystemTable.close();
        }
        catch (Exception e) {
            logger.warn("Error closing the storage plugin store", (Throwable)e);
        }
    }
}

