/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import java.util.Set;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.drill.exec.store.PluginRulesProvider;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableSet;

public class StoragePluginRulesSupplier {
    private final StoragePluginRulesSupplierBuilder storagePluginRulesSupplierBuilder;

    private StoragePluginRulesSupplier(StoragePluginRulesSupplierBuilder storagePluginRulesSupplierBuilder) {
        this.storagePluginRulesSupplierBuilder = storagePluginRulesSupplierBuilder;
    }

    public Set<? extends RelOptRule> getOptimizerRules() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        PluginRulesProvider rulesProvider = this.storagePluginRulesSupplierBuilder.rulesProvider();
        if (this.storagePluginRulesSupplierBuilder.supportsProjectPushdown()) {
            builder.addAll(rulesProvider.projectRules());
        }
        if (this.storagePluginRulesSupplierBuilder.supportsFilterPushdown()) {
            builder.addAll(rulesProvider.filterRules());
        }
        if (this.storagePluginRulesSupplierBuilder.supportsSortPushdown()) {
            builder.addAll(rulesProvider.sortRules());
        }
        if (this.storagePluginRulesSupplierBuilder.supportsUnionPushdown()) {
            builder.addAll(rulesProvider.unionRules());
        }
        if (this.storagePluginRulesSupplierBuilder.supportsJoinPushdown()) {
            builder.addAll(rulesProvider.joinRules());
        }
        if (this.storagePluginRulesSupplierBuilder.supportsAggregatePushdown()) {
            builder.addAll(rulesProvider.aggregateRules());
        }
        if (this.storagePluginRulesSupplierBuilder.supportsLimitPushdown()) {
            builder.addAll(rulesProvider.limitRules());
        }
        builder.add(rulesProvider.vertexRule());
        builder.add(rulesProvider.prelConverterRule());
        return builder.build();
    }

    public Convention convention() {
        return this.storagePluginRulesSupplierBuilder.convention();
    }

    public static StoragePluginRulesSupplierBuilder builder() {
        return new StoragePluginRulesSupplierBuilder();
    }

    public static class StoragePluginRulesSupplierBuilder {
        private boolean supportsProjectPushdown;
        private boolean supportsFilterPushdown;
        private boolean supportsAggregatePushdown;
        private boolean supportsSortPushdown;
        private boolean supportsUnionPushdown;
        private boolean supportsJoinPushdown;
        private boolean supportsLimitPushdown;
        private PluginRulesProvider rulesProvider;
        private Convention convention;

        public boolean supportsProjectPushdown() {
            return this.supportsProjectPushdown;
        }

        public StoragePluginRulesSupplierBuilder supportsProjectPushdown(boolean supportsProjectPushdown) {
            this.supportsProjectPushdown = supportsProjectPushdown;
            return this;
        }

        public boolean supportsFilterPushdown() {
            return this.supportsFilterPushdown;
        }

        public StoragePluginRulesSupplierBuilder supportsFilterPushdown(boolean supportsFilterPushdown) {
            this.supportsFilterPushdown = supportsFilterPushdown;
            return this;
        }

        public boolean supportsAggregatePushdown() {
            return this.supportsAggregatePushdown;
        }

        public StoragePluginRulesSupplierBuilder supportsAggregatePushdown(boolean supportsAggregatePushdown) {
            this.supportsAggregatePushdown = supportsAggregatePushdown;
            return this;
        }

        public boolean supportsSortPushdown() {
            return this.supportsSortPushdown;
        }

        public StoragePluginRulesSupplierBuilder supportsSortPushdown(boolean supportsSortPushdown) {
            this.supportsSortPushdown = supportsSortPushdown;
            return this;
        }

        public boolean supportsUnionPushdown() {
            return this.supportsUnionPushdown;
        }

        public StoragePluginRulesSupplierBuilder supportsUnionPushdown(boolean supportsUnionPushdown) {
            this.supportsUnionPushdown = supportsUnionPushdown;
            return this;
        }

        public boolean supportsJoinPushdown() {
            return this.supportsJoinPushdown;
        }

        public StoragePluginRulesSupplierBuilder supportsJoinPushdown(boolean supportsJoinPushdown) {
            this.supportsJoinPushdown = supportsJoinPushdown;
            return this;
        }

        public boolean supportsLimitPushdown() {
            return this.supportsLimitPushdown;
        }

        public StoragePluginRulesSupplierBuilder supportsLimitPushdown(boolean supportsLimitPushdown) {
            this.supportsLimitPushdown = supportsLimitPushdown;
            return this;
        }

        public PluginRulesProvider rulesProvider() {
            return this.rulesProvider;
        }

        public StoragePluginRulesSupplierBuilder rulesProvider(PluginRulesProvider rulesProvider) {
            this.rulesProvider = rulesProvider;
            return this;
        }

        public Convention convention() {
            return this.convention;
        }

        public StoragePluginRulesSupplierBuilder convention(Convention convention) {
            this.convention = convention;
            return this;
        }

        public StoragePluginRulesSupplier build() {
            return new StoragePluginRulesSupplier(this);
        }
    }
}

