/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.map.CaseInsensitiveMap;
import org.apache.drill.exec.store.PluginHandle;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

class StoragePluginMap
implements Iterable<PluginHandle>,
AutoCloseable {
    private final Map<String, PluginHandle> nameMap = CaseInsensitiveMap.newHashMap();
    private final Map<StoragePluginConfig, PluginHandle> configMap = new HashMap<StoragePluginConfig, PluginHandle>();

    StoragePluginMap() {
    }

    public synchronized PluginHandle put(PluginHandle plugin) throws StoragePluginRegistry.PluginException {
        PluginHandle oldPlugin = this.nameMap.put(plugin.name(), plugin);
        if (oldPlugin != null) {
            if (oldPlugin == plugin || oldPlugin.config().equals(plugin.config())) {
                return null;
            }
            if (oldPlugin.isIntrinsic()) {
                this.nameMap.put(oldPlugin.name(), oldPlugin);
                throw StoragePluginRegistry.PluginException.systemPluginException("replace", plugin.name());
            }
            this.configMap.remove(oldPlugin.config());
        }
        this.configMap.put(plugin.config(), plugin);
        return oldPlugin;
    }

    public synchronized PluginHandle putIfAbsent(PluginHandle plugin) {
        PluginHandle oldPlugin = this.nameMap.putIfAbsent(plugin.name(), plugin);
        if (oldPlugin != null) {
            return oldPlugin;
        }
        this.configMap.put(plugin.config(), plugin);
        return plugin;
    }

    public synchronized PluginHandle get(String name) {
        return this.nameMap.get(name);
    }

    public synchronized PluginHandle get(StoragePluginConfig config) {
        return this.configMap.get(config);
    }

    public synchronized boolean replace(PluginHandle oldPlugin, PluginHandle newPlugin) throws StoragePluginRegistry.PluginException {
        Preconditions.checkArgument(oldPlugin != null);
        Preconditions.checkArgument(newPlugin != null);
        Preconditions.checkArgument(oldPlugin.name().equalsIgnoreCase(newPlugin.name()));
        Preconditions.checkArgument(oldPlugin != newPlugin);
        if (oldPlugin.isIntrinsic()) {
            throw StoragePluginRegistry.PluginException.systemPluginException("replace", oldPlugin.name());
        }
        boolean ok = this.nameMap.replace(oldPlugin.name(), oldPlugin, newPlugin);
        if (ok) {
            this.configMap.remove(oldPlugin.config(), oldPlugin);
            this.configMap.put(newPlugin.config(), newPlugin);
        }
        return ok;
    }

    public synchronized PluginHandle remove(String name) throws StoragePluginRegistry.PluginException {
        PluginHandle plugin = this.get(name);
        if (plugin == null) {
            return null;
        }
        if (plugin.isIntrinsic()) {
            throw StoragePluginRegistry.PluginException.systemPluginException("remove", name);
        }
        this.nameMap.remove(name);
        this.configMap.remove(plugin.config(), plugin);
        return plugin;
    }

    public synchronized PluginHandle remove(String name, StoragePluginConfig oldConfig) throws StoragePluginRegistry.PluginException {
        PluginHandle oldEntry = this.nameMap.get(name);
        if (oldEntry == null || !oldEntry.config().equals(oldConfig)) {
            return null;
        }
        if (oldEntry.isIntrinsic()) {
            throw StoragePluginRegistry.PluginException.systemPluginException("remove", name);
        }
        this.nameMap.remove(oldEntry.name());
        if (this.configMap.remove(oldEntry.config()) != oldEntry) {
            throw new IllegalStateException(String.format("Config entry was modified while in the plugin cache: '%s', class %s", name, oldConfig.getClass().getName()));
        }
        return oldEntry;
    }

    @Override
    public synchronized Iterator<PluginHandle> iterator() {
        return this.nameMap.values().iterator();
    }

    public synchronized Set<String> getNames() {
        return this.nameMap.keySet();
    }

    public synchronized Collection<PluginHandle> plugins() {
        return this.nameMap.values();
    }

    public synchronized Set<StoragePluginConfig> configs() {
        return this.configMap.keySet();
    }

    @Override
    public void close() {
        this.plugins().stream().forEach(e -> e.close());
        this.configMap.clear();
        this.nameMap.clear();
    }

    public Set<String> names() {
        return this.nameMap.keySet();
    }
}

