/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import java.util.List;
import org.apache.calcite.jdbc.DynamicSchema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.exec.ops.ViewExpansionContext;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.server.options.OptionValue;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaTreeProvider
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(SchemaTreeProvider.class);
    private final DrillbitContext dContext;
    private final List<SchemaPlus> schemaTreesToClose;
    private final boolean isImpersonationEnabled;

    public SchemaTreeProvider(DrillbitContext dContext) {
        this.dContext = dContext;
        this.schemaTreesToClose = Lists.newArrayList();
        this.isImpersonationEnabled = dContext.getConfig().getBoolean("drill.exec.impersonation.enabled");
    }

    public SchemaPlus createRootSchema(final OptionManager options) {
        SchemaConfig.SchemaConfigInfoProvider schemaConfigInfoProvider = new SchemaConfig.SchemaConfigInfoProvider(){

            @Override
            public ViewExpansionContext getViewExpansionContext() {
                throw new UnsupportedOperationException("View expansion context is not supported");
            }

            @Override
            public OptionValue getOption(String optionKey) {
                return options.getOption(optionKey);
            }

            @Override
            public String getTemporaryTableName(String table) {
                throw new UnsupportedOperationException("getTemporaryTableName is not supported");
            }

            @Override
            public String getTemporaryWorkspace() {
                throw new UnsupportedOperationException("getTemporaryWorkspace is not supported");
            }

            @Override
            public SchemaPlus getRootSchema(String userName) {
                return SchemaTreeProvider.this.createRootSchema(userName, this);
            }

            @Override
            public String getQueryUserName() {
                return ImpersonationUtil.getProcessUserName();
            }

            @Override
            public UserBitShared.UserCredentials getQueryUserCredentials() {
                return UserBitShared.UserCredentials.newBuilder().setUserName(ImpersonationUtil.getProcessUserName()).build();
            }
        };
        SchemaConfig schemaConfig = SchemaConfig.newBuilder(ImpersonationUtil.getProcessUserName(), schemaConfigInfoProvider).build();
        return this.createRootSchema(schemaConfig);
    }

    public SchemaPlus createRootSchema(String userName, SchemaConfig.SchemaConfigInfoProvider provider) {
        String schemaUser = this.isImpersonationEnabled ? userName : ImpersonationUtil.getProcessUserName();
        SchemaConfig schemaConfig = SchemaConfig.newBuilder(schemaUser, provider).build();
        return this.createRootSchema(schemaConfig);
    }

    public SchemaPlus createRootSchema(SchemaConfig schemaConfig) {
        SchemaPlus rootSchema = DynamicSchema.createRootSchema(this.dContext.getStorage(), schemaConfig, this.dContext.getAliasRegistryProvider());
        this.schemaTreesToClose.add(rootSchema);
        return rootSchema;
    }

    @Override
    public void close() throws Exception {
        for (SchemaPlus sp : this.schemaTreesToClose) {
            AutoCloseables.closeWithUserException((AutoCloseable)sp.unwrap(AbstractSchema.class));
        }
    }
}

