/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import org.apache.calcite.schema.SchemaPlus;
import org.apache.drill.exec.ops.ViewExpansionContext;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.server.options.OptionValue;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.base.Strings;

public class SchemaConfig {
    private final String userName;
    private final SchemaConfigInfoProvider provider;
    private final boolean ignoreAuthErrors;

    private SchemaConfig(String userName, SchemaConfigInfoProvider provider, boolean ignoreAuthErrors) {
        this.userName = userName;
        this.provider = provider;
        this.ignoreAuthErrors = ignoreAuthErrors;
    }

    public String getTemporaryTableName(String table) {
        return this.provider.getTemporaryTableName(table);
    }

    public String getTemporaryWorkspace() {
        return this.provider.getTemporaryWorkspace();
    }

    public static Builder newBuilder(String userName, SchemaConfigInfoProvider provider) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(userName), "A valid userName is expected");
        Preconditions.checkNotNull(provider, "Non-null SchemaConfigInfoProvider is expected");
        return new Builder(userName, provider);
    }

    public String getUserName() {
        return this.userName;
    }

    public UserBitShared.UserCredentials getQueryUserCredentials() {
        return this.provider.getQueryUserCredentials();
    }

    public boolean getIgnoreAuthErrors() {
        return this.ignoreAuthErrors;
    }

    public OptionValue getOption(String optionKey) {
        return this.provider.getOption(optionKey);
    }

    public ViewExpansionContext getViewExpansionContext() {
        return this.provider.getViewExpansionContext();
    }

    public static interface SchemaConfigInfoProvider {
        public ViewExpansionContext getViewExpansionContext();

        public SchemaPlus getRootSchema(String var1);

        public String getQueryUserName();

        public UserBitShared.UserCredentials getQueryUserCredentials();

        public OptionValue getOption(String var1);

        public String getTemporaryTableName(String var1);

        public String getTemporaryWorkspace();
    }

    public static class Builder {
        final String userName;
        final SchemaConfigInfoProvider provider;
        boolean ignoreAuthErrors;

        private Builder(String userName, SchemaConfigInfoProvider provider) {
            this.userName = userName;
            this.provider = provider;
        }

        public Builder setIgnoreAuthErrors(boolean ignoreAuthErrors) {
            this.ignoreAuthErrors = ignoreAuthErrors;
            return this;
        }

        public SchemaConfig build() {
            return new SchemaConfig(this.userName, this.provider, this.ignoreAuthErrors);
        }
    }
}

