/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceInputStream
extends ByteArrayInputStream
implements Seekable,
PositionedReadable {
    static final Logger logger = LoggerFactory.getLogger(ResourceInputStream.class);

    public ResourceInputStream(byte[] bytes) {
        super(bytes);
    }

    public void readFully(long position, byte[] buffer) throws IOException {
        int l = this.read(position, buffer, 0, buffer.length);
        if (l < buffer.length) {
            throw new EOFException();
        }
    }

    public int read(long position, byte[] b, int off, int len) {
        Preconditions.checkNotNull(b);
        Preconditions.checkPositionIndexes(off, off + len, b.length);
        int start = (int)position;
        if (start >= this.count) {
            return -1;
        }
        int avail = this.count - start;
        if (len > avail) {
            len = avail;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, start, b, off, len);
        return len;
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        int l = this.read(position, buffer, offset, length);
        if (l < length) {
            throw new EOFException();
        }
    }

    public long getPos() throws IOException {
        return this.pos;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int l = this.read(this.pos, b, 0, b.length);
        this.pos += l;
        return l;
    }

    public boolean seekToNewSource(long arg0) throws IOException {
        this.seek(arg0);
        return true;
    }

    public void seek(long arg0) throws IOException {
        if ((long)this.buf.length <= arg0) {
            throw new EOFException();
        }
        this.pos = (int)arg0;
    }
}

