/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.store.PluginRulesProvider;
import org.apache.drill.exec.store.enumerable.plan.VertexDrelConverterRule;
import org.apache.drill.exec.store.plan.PluginImplementor;
import org.apache.drill.exec.store.plan.rule.PluginAggregateRule;
import org.apache.drill.exec.store.plan.rule.PluginFilterRule;
import org.apache.drill.exec.store.plan.rule.PluginIntermediatePrelConverterRule;
import org.apache.drill.exec.store.plan.rule.PluginJoinRule;
import org.apache.drill.exec.store.plan.rule.PluginLimitRule;
import org.apache.drill.exec.store.plan.rule.PluginProjectRule;
import org.apache.drill.exec.store.plan.rule.PluginSortRule;
import org.apache.drill.exec.store.plan.rule.PluginUnionRule;

public class PluginRulesProviderImpl
implements PluginRulesProvider {
    private final Supplier<PluginImplementor> implementorSupplier;
    private final PluginImplementor pluginImplementor;
    private final Convention convention;

    public PluginRulesProviderImpl(Convention convention, Supplier<PluginImplementor> implementorSupplier) {
        this.convention = convention;
        this.implementorSupplier = implementorSupplier;
        this.pluginImplementor = implementorSupplier.get();
    }

    @Override
    public List<RelOptRule> sortRules() {
        return Arrays.asList(new RelOptRule[]{new PluginSortRule((RelTrait)Convention.NONE, this.convention, this.pluginImplementor), new PluginSortRule((RelTrait)DrillRel.DRILL_LOGICAL, this.convention, this.pluginImplementor)});
    }

    @Override
    public List<RelOptRule> limitRules() {
        return Arrays.asList(new RelOptRule[]{new PluginLimitRule((RelTrait)Convention.NONE, this.convention, this.pluginImplementor), new PluginLimitRule((RelTrait)DrillRel.DRILL_LOGICAL, this.convention, this.pluginImplementor)});
    }

    @Override
    public List<RelOptRule> filterRules() {
        return Arrays.asList(new RelOptRule[]{new PluginFilterRule((RelTrait)Convention.NONE, this.convention, this.pluginImplementor), new PluginFilterRule((RelTrait)DrillRel.DRILL_LOGICAL, this.convention, this.pluginImplementor)});
    }

    @Override
    public List<RelOptRule> projectRules() {
        return Arrays.asList(new RelOptRule[]{new PluginProjectRule((RelTrait)Convention.NONE, this.convention, this.pluginImplementor), new PluginProjectRule((RelTrait)DrillRel.DRILL_LOGICAL, this.convention, this.pluginImplementor)});
    }

    @Override
    public List<RelOptRule> aggregateRules() {
        return Arrays.asList(new RelOptRule[]{new PluginAggregateRule((RelTrait)Convention.NONE, this.convention, this.pluginImplementor), new PluginAggregateRule((RelTrait)DrillRel.DRILL_LOGICAL, this.convention, this.pluginImplementor)});
    }

    @Override
    public List<RelOptRule> unionRules() {
        return Arrays.asList(new RelOptRule[]{new PluginUnionRule((RelTrait)Convention.NONE, this.convention, this.pluginImplementor), new PluginUnionRule((RelTrait)DrillRel.DRILL_LOGICAL, this.convention, this.pluginImplementor)});
    }

    @Override
    public List<RelOptRule> joinRules() {
        return Arrays.asList(new RelOptRule[]{new PluginJoinRule((RelTrait)Convention.NONE, this.convention, this.pluginImplementor), new PluginJoinRule((RelTrait)DrillRel.DRILL_LOGICAL, this.convention, this.pluginImplementor)});
    }

    @Override
    public RelOptRule vertexRule() {
        return VertexDrelConverterRule.create(this.convention);
    }

    @Override
    public RelOptRule prelConverterRule() {
        return new PluginIntermediatePrelConverterRule(this.convention, this.implementorSupplier);
    }
}

