/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.NullableBigIntHolder;
import org.apache.drill.exec.expr.holders.NullableBitHolder;
import org.apache.drill.exec.expr.holders.NullableDateHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal18Holder;
import org.apache.drill.exec.expr.holders.NullableDecimal28DenseHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal28SparseHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal38DenseHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal38SparseHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal9Holder;
import org.apache.drill.exec.expr.holders.NullableFloat4Holder;
import org.apache.drill.exec.expr.holders.NullableFloat8Holder;
import org.apache.drill.exec.expr.holders.NullableIntHolder;
import org.apache.drill.exec.expr.holders.NullableIntervalDayHolder;
import org.apache.drill.exec.expr.holders.NullableIntervalHolder;
import org.apache.drill.exec.expr.holders.NullableIntervalYearHolder;
import org.apache.drill.exec.expr.holders.NullableSmallIntHolder;
import org.apache.drill.exec.expr.holders.NullableTimeHolder;
import org.apache.drill.exec.expr.holders.NullableTimeStampHolder;
import org.apache.drill.exec.expr.holders.NullableTinyIntHolder;
import org.apache.drill.exec.expr.holders.NullableUInt1Holder;
import org.apache.drill.exec.expr.holders.NullableUInt2Holder;
import org.apache.drill.exec.expr.holders.NullableUInt4Holder;
import org.apache.drill.exec.expr.holders.NullableUInt8Holder;
import org.apache.drill.exec.expr.holders.NullableVar16CharHolder;
import org.apache.drill.exec.expr.holders.NullableVarBinaryHolder;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.expr.holders.NullableVarDecimalHolder;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.store.AbstractRecordWriter;
import org.apache.drill.exec.store.EventBasedRecordWriter;
import org.apache.drill.exec.store.RecordWriter;
import org.apache.drill.exec.store.parquet.ParquetTypeHelper;
import org.apache.drill.exec.store.parquet.decimal.DecimalValueWriter;
import org.apache.drill.exec.util.DecimalUtility;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;

public abstract class ParquetOutputRecordWriter
extends AbstractRecordWriter
implements RecordWriter {
    protected static final String LIST = "list";
    protected static final String ELEMENT = "element";
    protected static final int ZERO_IDX = 0;
    private RecordConsumer consumer;
    private MessageType schema;

    public void setUp(MessageType schema, RecordConsumer consumer) {
        this.schema = schema;
        this.consumer = consumer;
    }

    protected abstract PrimitiveType getPrimitiveType(MaterializedField var1);

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableTinyIntConverter(int fieldId, String fieldName, FieldReader reader) {
        TinyIntParquetConverter converter = new TinyIntParquetConverter(fieldId, fieldName, reader);
        return new NullableFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewTinyIntConverter(int fieldId, String fieldName, FieldReader reader) {
        TinyIntParquetConverter converter = new TinyIntParquetConverter(fieldId, fieldName, reader);
        return new RequiredFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedTinyIntConverter(int fieldId, String fieldName, FieldReader reader) {
        TinyIntParquetConverter converter = new TinyIntParquetConverter(fieldId, fieldName, reader);
        return new RepeatedFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableUInt1Converter(int fieldId, String fieldName, FieldReader reader) {
        UInt1ParquetConverter converter = new UInt1ParquetConverter(fieldId, fieldName, reader);
        return new NullableFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewUInt1Converter(int fieldId, String fieldName, FieldReader reader) {
        UInt1ParquetConverter converter = new UInt1ParquetConverter(fieldId, fieldName, reader);
        return new RequiredFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedUInt1Converter(int fieldId, String fieldName, FieldReader reader) {
        UInt1ParquetConverter converter = new UInt1ParquetConverter(fieldId, fieldName, reader);
        return new RepeatedFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableUInt2Converter(int fieldId, String fieldName, FieldReader reader) {
        UInt2ParquetConverter converter = new UInt2ParquetConverter(fieldId, fieldName, reader);
        return new NullableFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewUInt2Converter(int fieldId, String fieldName, FieldReader reader) {
        UInt2ParquetConverter converter = new UInt2ParquetConverter(fieldId, fieldName, reader);
        return new RequiredFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedUInt2Converter(int fieldId, String fieldName, FieldReader reader) {
        UInt2ParquetConverter converter = new UInt2ParquetConverter(fieldId, fieldName, reader);
        return new RepeatedFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableSmallIntConverter(int fieldId, String fieldName, FieldReader reader) {
        SmallIntParquetConverter converter = new SmallIntParquetConverter(fieldId, fieldName, reader);
        return new NullableFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewSmallIntConverter(int fieldId, String fieldName, FieldReader reader) {
        SmallIntParquetConverter converter = new SmallIntParquetConverter(fieldId, fieldName, reader);
        return new RequiredFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedSmallIntConverter(int fieldId, String fieldName, FieldReader reader) {
        SmallIntParquetConverter converter = new SmallIntParquetConverter(fieldId, fieldName, reader);
        return new RepeatedFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableIntConverter(int fieldId, String fieldName, FieldReader reader) {
        IntParquetConverter converter = new IntParquetConverter(fieldId, fieldName, reader);
        return new NullableFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewIntConverter(int fieldId, String fieldName, FieldReader reader) {
        IntParquetConverter converter = new IntParquetConverter(fieldId, fieldName, reader);
        return new RequiredFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedIntConverter(int fieldId, String fieldName, FieldReader reader) {
        IntParquetConverter converter = new IntParquetConverter(fieldId, fieldName, reader);
        return new RepeatedFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableUInt4Converter(int fieldId, String fieldName, FieldReader reader) {
        UInt4ParquetConverter converter = new UInt4ParquetConverter(fieldId, fieldName, reader);
        return new NullableFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewUInt4Converter(int fieldId, String fieldName, FieldReader reader) {
        UInt4ParquetConverter converter = new UInt4ParquetConverter(fieldId, fieldName, reader);
        return new RequiredFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedUInt4Converter(int fieldId, String fieldName, FieldReader reader) {
        UInt4ParquetConverter converter = new UInt4ParquetConverter(fieldId, fieldName, reader);
        return new RepeatedFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableFloat4Converter(int fieldId, String fieldName, FieldReader reader) {
        Float4ParquetConverter converter = new Float4ParquetConverter(fieldId, fieldName, reader);
        return new NullableFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewFloat4Converter(int fieldId, String fieldName, FieldReader reader) {
        Float4ParquetConverter converter = new Float4ParquetConverter(fieldId, fieldName, reader);
        return new RequiredFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedFloat4Converter(int fieldId, String fieldName, FieldReader reader) {
        Float4ParquetConverter converter = new Float4ParquetConverter(fieldId, fieldName, reader);
        return new RepeatedFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableTimeConverter(int fieldId, String fieldName, FieldReader reader) {
        TimeParquetConverter converter = new TimeParquetConverter(fieldId, fieldName, reader);
        return new NullableFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewTimeConverter(int fieldId, String fieldName, FieldReader reader) {
        TimeParquetConverter converter = new TimeParquetConverter(fieldId, fieldName, reader);
        return new RequiredFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedTimeConverter(int fieldId, String fieldName, FieldReader reader) {
        TimeParquetConverter converter = new TimeParquetConverter(fieldId, fieldName, reader);
        return new RepeatedFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableIntervalYearConverter(int fieldId, String fieldName, FieldReader reader) {
        IntervalYearParquetConverter converter = new IntervalYearParquetConverter(fieldId, fieldName, reader);
        return new NullableFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewIntervalYearConverter(int fieldId, String fieldName, FieldReader reader) {
        IntervalYearParquetConverter converter = new IntervalYearParquetConverter(fieldId, fieldName, reader);
        return new RequiredFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedIntervalYearConverter(int fieldId, String fieldName, FieldReader reader) {
        IntervalYearParquetConverter converter = new IntervalYearParquetConverter(fieldId, fieldName, reader);
        return new RepeatedFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableDecimal9Converter(int fieldId, String fieldName, FieldReader reader) {
        Decimal9ParquetConverter converter = new Decimal9ParquetConverter(fieldId, fieldName, reader);
        return new NullableFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewDecimal9Converter(int fieldId, String fieldName, FieldReader reader) {
        Decimal9ParquetConverter converter = new Decimal9ParquetConverter(fieldId, fieldName, reader);
        return new RequiredFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedDecimal9Converter(int fieldId, String fieldName, FieldReader reader) {
        Decimal9ParquetConverter converter = new Decimal9ParquetConverter(fieldId, fieldName, reader);
        return new RepeatedFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableBigIntConverter(int fieldId, String fieldName, FieldReader reader) {
        BigIntParquetConverter converter = new BigIntParquetConverter(fieldId, fieldName, reader);
        return new NullableFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewBigIntConverter(int fieldId, String fieldName, FieldReader reader) {
        BigIntParquetConverter converter = new BigIntParquetConverter(fieldId, fieldName, reader);
        return new RequiredFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedBigIntConverter(int fieldId, String fieldName, FieldReader reader) {
        BigIntParquetConverter converter = new BigIntParquetConverter(fieldId, fieldName, reader);
        return new RepeatedFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableUInt8Converter(int fieldId, String fieldName, FieldReader reader) {
        UInt8ParquetConverter converter = new UInt8ParquetConverter(fieldId, fieldName, reader);
        return new NullableFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewUInt8Converter(int fieldId, String fieldName, FieldReader reader) {
        UInt8ParquetConverter converter = new UInt8ParquetConverter(fieldId, fieldName, reader);
        return new RequiredFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedUInt8Converter(int fieldId, String fieldName, FieldReader reader) {
        UInt8ParquetConverter converter = new UInt8ParquetConverter(fieldId, fieldName, reader);
        return new RepeatedFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableFloat8Converter(int fieldId, String fieldName, FieldReader reader) {
        Float8ParquetConverter converter = new Float8ParquetConverter(fieldId, fieldName, reader);
        return new NullableFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewFloat8Converter(int fieldId, String fieldName, FieldReader reader) {
        Float8ParquetConverter converter = new Float8ParquetConverter(fieldId, fieldName, reader);
        return new RequiredFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedFloat8Converter(int fieldId, String fieldName, FieldReader reader) {
        Float8ParquetConverter converter = new Float8ParquetConverter(fieldId, fieldName, reader);
        return new RepeatedFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableDateConverter(int fieldId, String fieldName, FieldReader reader) {
        DateParquetConverter converter = new DateParquetConverter(fieldId, fieldName, reader);
        return new NullableFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewDateConverter(int fieldId, String fieldName, FieldReader reader) {
        DateParquetConverter converter = new DateParquetConverter(fieldId, fieldName, reader);
        return new RequiredFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedDateConverter(int fieldId, String fieldName, FieldReader reader) {
        DateParquetConverter converter = new DateParquetConverter(fieldId, fieldName, reader);
        return new RepeatedFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableTimeStampConverter(int fieldId, String fieldName, FieldReader reader) {
        TimeStampParquetConverter converter = new TimeStampParquetConverter(fieldId, fieldName, reader);
        return new NullableFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewTimeStampConverter(int fieldId, String fieldName, FieldReader reader) {
        TimeStampParquetConverter converter = new TimeStampParquetConverter(fieldId, fieldName, reader);
        return new RequiredFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedTimeStampConverter(int fieldId, String fieldName, FieldReader reader) {
        TimeStampParquetConverter converter = new TimeStampParquetConverter(fieldId, fieldName, reader);
        return new RepeatedFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableDecimal18Converter(int fieldId, String fieldName, FieldReader reader) {
        Decimal18ParquetConverter converter = new Decimal18ParquetConverter(fieldId, fieldName, reader);
        return new NullableFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewDecimal18Converter(int fieldId, String fieldName, FieldReader reader) {
        Decimal18ParquetConverter converter = new Decimal18ParquetConverter(fieldId, fieldName, reader);
        return new RequiredFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedDecimal18Converter(int fieldId, String fieldName, FieldReader reader) {
        Decimal18ParquetConverter converter = new Decimal18ParquetConverter(fieldId, fieldName, reader);
        return new RepeatedFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableIntervalDayConverter(int fieldId, String fieldName, FieldReader reader) {
        IntervalDayParquetConverter converter = new IntervalDayParquetConverter(fieldId, fieldName, reader);
        return new NullableFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewIntervalDayConverter(int fieldId, String fieldName, FieldReader reader) {
        IntervalDayParquetConverter converter = new IntervalDayParquetConverter(fieldId, fieldName, reader);
        return new RequiredFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedIntervalDayConverter(int fieldId, String fieldName, FieldReader reader) {
        IntervalDayParquetConverter converter = new IntervalDayParquetConverter(fieldId, fieldName, reader);
        return new RepeatedFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableIntervalConverter(int fieldId, String fieldName, FieldReader reader) {
        IntervalParquetConverter converter = new IntervalParquetConverter(fieldId, fieldName, reader);
        return new NullableFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewIntervalConverter(int fieldId, String fieldName, FieldReader reader) {
        IntervalParquetConverter converter = new IntervalParquetConverter(fieldId, fieldName, reader);
        return new RequiredFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedIntervalConverter(int fieldId, String fieldName, FieldReader reader) {
        IntervalParquetConverter converter = new IntervalParquetConverter(fieldId, fieldName, reader);
        return new RepeatedFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableDecimal28DenseConverter(int fieldId, String fieldName, FieldReader reader) {
        Decimal28DenseParquetConverter converter = new Decimal28DenseParquetConverter(fieldId, fieldName, reader);
        return new NullableFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewDecimal28DenseConverter(int fieldId, String fieldName, FieldReader reader) {
        Decimal28DenseParquetConverter converter = new Decimal28DenseParquetConverter(fieldId, fieldName, reader);
        return new RequiredFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedDecimal28DenseConverter(int fieldId, String fieldName, FieldReader reader) {
        Decimal28DenseParquetConverter converter = new Decimal28DenseParquetConverter(fieldId, fieldName, reader);
        return new RepeatedFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableDecimal38DenseConverter(int fieldId, String fieldName, FieldReader reader) {
        Decimal38DenseParquetConverter converter = new Decimal38DenseParquetConverter(fieldId, fieldName, reader);
        return new NullableFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewDecimal38DenseConverter(int fieldId, String fieldName, FieldReader reader) {
        Decimal38DenseParquetConverter converter = new Decimal38DenseParquetConverter(fieldId, fieldName, reader);
        return new RequiredFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedDecimal38DenseConverter(int fieldId, String fieldName, FieldReader reader) {
        Decimal38DenseParquetConverter converter = new Decimal38DenseParquetConverter(fieldId, fieldName, reader);
        return new RepeatedFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableDecimal38SparseConverter(int fieldId, String fieldName, FieldReader reader) {
        Decimal38SparseParquetConverter converter = new Decimal38SparseParquetConverter(fieldId, fieldName, reader);
        return new NullableFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewDecimal38SparseConverter(int fieldId, String fieldName, FieldReader reader) {
        Decimal38SparseParquetConverter converter = new Decimal38SparseParquetConverter(fieldId, fieldName, reader);
        return new RequiredFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedDecimal38SparseConverter(int fieldId, String fieldName, FieldReader reader) {
        Decimal38SparseParquetConverter converter = new Decimal38SparseParquetConverter(fieldId, fieldName, reader);
        return new RepeatedFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableDecimal28SparseConverter(int fieldId, String fieldName, FieldReader reader) {
        Decimal28SparseParquetConverter converter = new Decimal28SparseParquetConverter(fieldId, fieldName, reader);
        return new NullableFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewDecimal28SparseConverter(int fieldId, String fieldName, FieldReader reader) {
        Decimal28SparseParquetConverter converter = new Decimal28SparseParquetConverter(fieldId, fieldName, reader);
        return new RequiredFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedDecimal28SparseConverter(int fieldId, String fieldName, FieldReader reader) {
        Decimal28SparseParquetConverter converter = new Decimal28SparseParquetConverter(fieldId, fieldName, reader);
        return new RepeatedFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableVarBinaryConverter(int fieldId, String fieldName, FieldReader reader) {
        VarBinaryParquetConverter converter = new VarBinaryParquetConverter(fieldId, fieldName, reader);
        return new NullableFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewVarBinaryConverter(int fieldId, String fieldName, FieldReader reader) {
        VarBinaryParquetConverter converter = new VarBinaryParquetConverter(fieldId, fieldName, reader);
        return new RequiredFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedVarBinaryConverter(int fieldId, String fieldName, FieldReader reader) {
        VarBinaryParquetConverter converter = new VarBinaryParquetConverter(fieldId, fieldName, reader);
        return new RepeatedFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableVarCharConverter(int fieldId, String fieldName, FieldReader reader) {
        VarCharParquetConverter converter = new VarCharParquetConverter(fieldId, fieldName, reader);
        return new NullableFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewVarCharConverter(int fieldId, String fieldName, FieldReader reader) {
        VarCharParquetConverter converter = new VarCharParquetConverter(fieldId, fieldName, reader);
        return new RequiredFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedVarCharConverter(int fieldId, String fieldName, FieldReader reader) {
        VarCharParquetConverter converter = new VarCharParquetConverter(fieldId, fieldName, reader);
        return new RepeatedFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableVar16CharConverter(int fieldId, String fieldName, FieldReader reader) {
        Var16CharParquetConverter converter = new Var16CharParquetConverter(fieldId, fieldName, reader);
        return new NullableFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewVar16CharConverter(int fieldId, String fieldName, FieldReader reader) {
        Var16CharParquetConverter converter = new Var16CharParquetConverter(fieldId, fieldName, reader);
        return new RequiredFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedVar16CharConverter(int fieldId, String fieldName, FieldReader reader) {
        Var16CharParquetConverter converter = new Var16CharParquetConverter(fieldId, fieldName, reader);
        return new RepeatedFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableVarDecimalConverter(int fieldId, String fieldName, FieldReader reader) {
        VarDecimalParquetConverter converter = new VarDecimalParquetConverter(fieldId, fieldName, reader);
        return new NullableFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewVarDecimalConverter(int fieldId, String fieldName, FieldReader reader) {
        VarDecimalParquetConverter converter = new VarDecimalParquetConverter(fieldId, fieldName, reader);
        return new RequiredFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedVarDecimalConverter(int fieldId, String fieldName, FieldReader reader) {
        VarDecimalParquetConverter converter = new VarDecimalParquetConverter(fieldId, fieldName, reader);
        return new RepeatedFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableBitConverter(int fieldId, String fieldName, FieldReader reader) {
        BitParquetConverter converter = new BitParquetConverter(fieldId, fieldName, reader);
        return new NullableFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewBitConverter(int fieldId, String fieldName, FieldReader reader) {
        BitParquetConverter converter = new BitParquetConverter(fieldId, fieldName, reader);
        return new RequiredFieldConverter(fieldId, fieldName, reader, converter);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedBitConverter(int fieldId, String fieldName, FieldReader reader) {
        BitParquetConverter converter = new BitParquetConverter(fieldId, fieldName, reader);
        return new RepeatedFieldConverter(fieldId, fieldName, reader, converter);
    }

    public class TinyIntParquetConverter
    extends BaseFieldConverter {
        private NullableTinyIntHolder holder;

        public TinyIntParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableTinyIntHolder();
        }

        @Override
        public void read() {
            this.reader.read(this.holder);
        }

        @Override
        public void read(int i) {
            this.reader.read(i, this.holder);
        }

        @Override
        public void consume() {
            ParquetOutputRecordWriter.this.consumer.addInteger((int)this.holder.value);
        }
    }

    public class NullableFieldConverter
    extends EventBasedRecordWriter.FieldConverter {
        private BaseFieldConverter delegate;

        public NullableFieldConverter(int fieldId, String fieldName, FieldReader reader, BaseFieldConverter delegate) {
            super(fieldId, fieldName, reader);
            this.delegate = delegate;
        }

        @Override
        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.delegate.writeField();
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }

        @Override
        public void setPosition(int index) {
            this.delegate.setPosition(index);
        }

        @Override
        public void startField() throws IOException {
            this.delegate.startField();
        }

        @Override
        public void endField() throws IOException {
            this.delegate.endField();
        }
    }

    public abstract class BaseFieldConverter
    extends EventBasedRecordWriter.FieldConverter {
        public BaseFieldConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
        }

        public abstract void read();

        public abstract void read(int var1);

        public abstract void consume();

        @Override
        public void writeField() throws IOException {
            this.read();
            this.consume();
        }
    }

    public class RequiredFieldConverter
    extends EventBasedRecordWriter.FieldConverter {
        private BaseFieldConverter delegate;

        public RequiredFieldConverter(int fieldId, String fieldName, FieldReader reader, BaseFieldConverter delegate) {
            super(fieldId, fieldName, reader);
            this.delegate = delegate;
        }

        @Override
        public void writeField() throws IOException {
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.delegate.writeField();
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }

        @Override
        public void setPosition(int index) {
            this.delegate.setPosition(index);
        }

        @Override
        public void startField() throws IOException {
            this.delegate.startField();
        }

        @Override
        public void endField() throws IOException {
            this.delegate.endField();
        }
    }

    public class RepeatedFieldConverter
    extends EventBasedRecordWriter.FieldConverter {
        private BaseFieldConverter delegate;

        public RepeatedFieldConverter(int fieldId, String fieldName, FieldReader reader, BaseFieldConverter delegate) {
            super(fieldId, fieldName, reader);
            this.delegate = delegate;
        }

        @Override
        public void writeField() throws IOException {
            if (this.reader.size() == 0) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            for (int i = 0; i < this.reader.size(); ++i) {
                this.delegate.read(i);
                this.delegate.consume();
            }
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }

        @Override
        public void writeListField() {
            if (this.reader.size() == 0) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(ParquetOutputRecordWriter.LIST, 0);
            for (int i = 0; i < this.reader.size(); ++i) {
                ParquetOutputRecordWriter.this.consumer.startGroup();
                ParquetOutputRecordWriter.this.consumer.startField(ParquetOutputRecordWriter.ELEMENT, 0);
                this.delegate.read(i);
                this.delegate.consume();
                ParquetOutputRecordWriter.this.consumer.endField(ParquetOutputRecordWriter.ELEMENT, 0);
                ParquetOutputRecordWriter.this.consumer.endGroup();
            }
            ParquetOutputRecordWriter.this.consumer.endField(ParquetOutputRecordWriter.LIST, 0);
        }

        @Override
        public void setPosition(int index) {
            this.delegate.setPosition(index);
        }

        @Override
        public void startField() throws IOException {
            this.delegate.startField();
        }

        @Override
        public void endField() throws IOException {
            this.delegate.endField();
        }
    }

    public class UInt1ParquetConverter
    extends BaseFieldConverter {
        private NullableUInt1Holder holder;

        public UInt1ParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableUInt1Holder();
        }

        @Override
        public void read() {
            this.reader.read(this.holder);
        }

        @Override
        public void read(int i) {
            this.reader.read(i, this.holder);
        }

        @Override
        public void consume() {
            ParquetOutputRecordWriter.this.consumer.addInteger((int)this.holder.value);
        }
    }

    public class UInt2ParquetConverter
    extends BaseFieldConverter {
        private NullableUInt2Holder holder;

        public UInt2ParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableUInt2Holder();
        }

        @Override
        public void read() {
            this.reader.read(this.holder);
        }

        @Override
        public void read(int i) {
            this.reader.read(i, this.holder);
        }

        @Override
        public void consume() {
            ParquetOutputRecordWriter.this.consumer.addInteger((int)this.holder.value);
        }
    }

    public class SmallIntParquetConverter
    extends BaseFieldConverter {
        private NullableSmallIntHolder holder;

        public SmallIntParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableSmallIntHolder();
        }

        @Override
        public void read() {
            this.reader.read(this.holder);
        }

        @Override
        public void read(int i) {
            this.reader.read(i, this.holder);
        }

        @Override
        public void consume() {
            ParquetOutputRecordWriter.this.consumer.addInteger((int)this.holder.value);
        }
    }

    public class IntParquetConverter
    extends BaseFieldConverter {
        private NullableIntHolder holder;

        public IntParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableIntHolder();
        }

        @Override
        public void read() {
            this.reader.read(this.holder);
        }

        @Override
        public void read(int i) {
            this.reader.read(i, this.holder);
        }

        @Override
        public void consume() {
            ParquetOutputRecordWriter.this.consumer.addInteger(this.holder.value);
        }
    }

    public class UInt4ParquetConverter
    extends BaseFieldConverter {
        private NullableUInt4Holder holder;

        public UInt4ParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableUInt4Holder();
        }

        @Override
        public void read() {
            this.reader.read(this.holder);
        }

        @Override
        public void read(int i) {
            this.reader.read(i, this.holder);
        }

        @Override
        public void consume() {
            ParquetOutputRecordWriter.this.consumer.addInteger(this.holder.value);
        }
    }

    public class Float4ParquetConverter
    extends BaseFieldConverter {
        private NullableFloat4Holder holder;

        public Float4ParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableFloat4Holder();
        }

        @Override
        public void read() {
            this.reader.read(this.holder);
        }

        @Override
        public void read(int i) {
            this.reader.read(i, this.holder);
        }

        @Override
        public void consume() {
            ParquetOutputRecordWriter.this.consumer.addFloat(this.holder.value);
        }
    }

    public class TimeParquetConverter
    extends BaseFieldConverter {
        private NullableTimeHolder holder;

        public TimeParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableTimeHolder();
        }

        @Override
        public void read() {
            this.reader.read(this.holder);
        }

        @Override
        public void read(int i) {
            this.reader.read(i, this.holder);
        }

        @Override
        public void consume() {
            ParquetOutputRecordWriter.this.consumer.addInteger(this.holder.value);
        }
    }

    public class IntervalYearParquetConverter
    extends BaseFieldConverter {
        private NullableIntervalYearHolder holder;
        private final byte[] output;

        public IntervalYearParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableIntervalYearHolder();
            this.output = new byte[12];
        }

        @Override
        public void read() {
            this.reader.read(this.holder);
        }

        @Override
        public void read(int i) {
            this.reader.read(i, this.holder);
        }

        @Override
        public void consume() {
            IntervalUtility.intToLEByteArray(this.holder.value, this.output, 0);
            Arrays.fill(this.output, 4, 8, (byte)0);
            Arrays.fill(this.output, 8, 12, (byte)0);
            ParquetOutputRecordWriter.this.consumer.addBinary(Binary.fromByteArray((byte[])this.output));
        }
    }

    public class Decimal9ParquetConverter
    extends BaseFieldConverter {
        private NullableDecimal9Holder holder;

        public Decimal9ParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableDecimal9Holder();
        }

        @Override
        public void read() {
            this.reader.read(this.holder);
        }

        @Override
        public void read(int i) {
            this.reader.read(i, this.holder);
        }

        @Override
        public void consume() {
            ParquetOutputRecordWriter.this.consumer.addInteger(this.holder.value);
        }
    }

    public class BigIntParquetConverter
    extends BaseFieldConverter {
        private NullableBigIntHolder holder;

        public BigIntParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableBigIntHolder();
        }

        @Override
        public void read() {
            this.reader.read(this.holder);
        }

        @Override
        public void read(int i) {
            this.reader.read(i, this.holder);
        }

        @Override
        public void consume() {
            ParquetOutputRecordWriter.this.consumer.addLong(this.holder.value);
        }
    }

    public class UInt8ParquetConverter
    extends BaseFieldConverter {
        private NullableUInt8Holder holder;

        public UInt8ParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableUInt8Holder();
        }

        @Override
        public void read() {
            this.reader.read(this.holder);
        }

        @Override
        public void read(int i) {
            this.reader.read(i, this.holder);
        }

        @Override
        public void consume() {
            ParquetOutputRecordWriter.this.consumer.addLong(this.holder.value);
        }
    }

    public class Float8ParquetConverter
    extends BaseFieldConverter {
        private NullableFloat8Holder holder;

        public Float8ParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableFloat8Holder();
        }

        @Override
        public void read() {
            this.reader.read(this.holder);
        }

        @Override
        public void read(int i) {
            this.reader.read(i, this.holder);
        }

        @Override
        public void consume() {
            ParquetOutputRecordWriter.this.consumer.addDouble(this.holder.value);
        }
    }

    public class DateParquetConverter
    extends BaseFieldConverter {
        private NullableDateHolder holder;

        public DateParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableDateHolder();
        }

        @Override
        public void read() {
            this.reader.read(this.holder);
        }

        @Override
        public void read(int i) {
            this.reader.read(i, this.holder);
        }

        @Override
        public void consume() {
            ParquetOutputRecordWriter.this.consumer.addInteger((int)(this.holder.value / 86400000L));
        }
    }

    public class TimeStampParquetConverter
    extends BaseFieldConverter {
        private NullableTimeStampHolder holder;

        public TimeStampParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableTimeStampHolder();
        }

        @Override
        public void read() {
            this.reader.read(this.holder);
        }

        @Override
        public void read(int i) {
            this.reader.read(i, this.holder);
        }

        @Override
        public void consume() {
            ParquetOutputRecordWriter.this.consumer.addLong(this.holder.value);
        }
    }

    public class Decimal18ParquetConverter
    extends BaseFieldConverter {
        private NullableDecimal18Holder holder;

        public Decimal18ParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableDecimal18Holder();
        }

        @Override
        public void read() {
            this.reader.read(this.holder);
        }

        @Override
        public void read(int i) {
            this.reader.read(i, this.holder);
        }

        @Override
        public void consume() {
            ParquetOutputRecordWriter.this.consumer.addLong(this.holder.value);
        }
    }

    public class IntervalDayParquetConverter
    extends BaseFieldConverter {
        private NullableIntervalDayHolder holder;
        private final byte[] output;

        public IntervalDayParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableIntervalDayHolder();
            this.output = new byte[12];
        }

        @Override
        public void read() {
            this.reader.read(this.holder);
        }

        @Override
        public void read(int i) {
            this.reader.read(i, this.holder);
        }

        @Override
        public void consume() {
            Arrays.fill(this.output, 0, 4, (byte)0);
            IntervalUtility.intToLEByteArray(this.holder.days, this.output, 4);
            IntervalUtility.intToLEByteArray(this.holder.milliseconds, this.output, 8);
            ParquetOutputRecordWriter.this.consumer.addBinary(Binary.fromByteArray((byte[])this.output));
        }
    }

    public class IntervalParquetConverter
    extends BaseFieldConverter {
        private NullableIntervalHolder holder;
        private final byte[] output;

        public IntervalParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableIntervalHolder();
            this.output = new byte[12];
        }

        @Override
        public void read() {
            this.reader.read(this.holder);
        }

        @Override
        public void read(int i) {
            this.reader.read(i, this.holder);
        }

        @Override
        public void consume() {
            IntervalUtility.intToLEByteArray(this.holder.months, this.output, 0);
            IntervalUtility.intToLEByteArray(this.holder.days, this.output, 4);
            IntervalUtility.intToLEByteArray(this.holder.milliseconds, this.output, 8);
            ParquetOutputRecordWriter.this.consumer.addBinary(Binary.fromByteArray((byte[])this.output));
        }
    }

    public class Decimal28DenseParquetConverter
    extends BaseFieldConverter {
        private NullableDecimal28DenseHolder holder;

        public Decimal28DenseParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableDecimal28DenseHolder();
        }

        @Override
        public void read() {
            this.reader.read(this.holder);
        }

        @Override
        public void read(int i) {
            this.reader.read(i, this.holder);
        }

        @Override
        public void consume() {
        }
    }

    public class Decimal38DenseParquetConverter
    extends BaseFieldConverter {
        private NullableDecimal38DenseHolder holder;

        public Decimal38DenseParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableDecimal38DenseHolder();
        }

        @Override
        public void read() {
            this.reader.read(this.holder);
        }

        @Override
        public void read(int i) {
            this.reader.read(i, this.holder);
        }

        @Override
        public void consume() {
        }
    }

    public class Decimal38SparseParquetConverter
    extends BaseFieldConverter {
        private NullableDecimal38SparseHolder holder;

        public Decimal38SparseParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableDecimal38SparseHolder();
        }

        @Override
        public void read() {
            this.reader.read(this.holder);
        }

        @Override
        public void read(int i) {
            this.reader.read(i, this.holder);
        }

        @Override
        public void consume() {
            byte[] bytes = DecimalUtility.getBigDecimalFromSparse(this.holder.buffer, this.holder.start, 6, this.holder.scale).unscaledValue().toByteArray();
            byte[] output = new byte[ParquetTypeHelper.getLengthForMinorType(TypeProtos.MinorType.DECIMAL38SPARSE)];
            if (NullableDecimal38SparseHolder.getSign(this.holder.start, this.holder.buffer)) {
                Arrays.fill(output, 0, output.length - bytes.length, (byte)-1);
            } else {
                Arrays.fill(output, 0, output.length - bytes.length, (byte)0);
            }
            System.arraycopy(bytes, 0, output, output.length - bytes.length, bytes.length);
            ParquetOutputRecordWriter.this.consumer.addBinary(Binary.fromByteArray((byte[])output));
        }
    }

    public class Decimal28SparseParquetConverter
    extends BaseFieldConverter {
        private NullableDecimal28SparseHolder holder;

        public Decimal28SparseParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableDecimal28SparseHolder();
        }

        @Override
        public void read() {
            this.reader.read(this.holder);
        }

        @Override
        public void read(int i) {
            this.reader.read(i, this.holder);
        }

        @Override
        public void consume() {
            byte[] bytes = DecimalUtility.getBigDecimalFromSparse(this.holder.buffer, this.holder.start, 5, this.holder.scale).unscaledValue().toByteArray();
            byte[] output = new byte[ParquetTypeHelper.getLengthForMinorType(TypeProtos.MinorType.DECIMAL28SPARSE)];
            if (NullableDecimal28SparseHolder.getSign(this.holder.start, this.holder.buffer)) {
                Arrays.fill(output, 0, output.length - bytes.length, (byte)-1);
            } else {
                Arrays.fill(output, 0, output.length - bytes.length, (byte)0);
            }
            System.arraycopy(bytes, 0, output, output.length - bytes.length, bytes.length);
            ParquetOutputRecordWriter.this.consumer.addBinary(Binary.fromByteArray((byte[])output));
        }
    }

    public class VarBinaryParquetConverter
    extends BaseFieldConverter {
        private NullableVarBinaryHolder holder;

        public VarBinaryParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableVarBinaryHolder();
        }

        @Override
        public void read() {
            this.reader.read(this.holder);
        }

        @Override
        public void read(int i) {
            this.reader.read(i, this.holder);
        }

        @Override
        public void consume() {
            ParquetOutputRecordWriter.this.consumer.addBinary(Binary.fromByteBuffer((ByteBuffer)this.holder.buffer.nioBuffer(this.holder.start, this.holder.end - this.holder.start)));
        }
    }

    public class VarCharParquetConverter
    extends BaseFieldConverter {
        private NullableVarCharHolder holder;

        public VarCharParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableVarCharHolder();
        }

        @Override
        public void read() {
            this.reader.read(this.holder);
        }

        @Override
        public void read(int i) {
            this.reader.read(i, this.holder);
        }

        @Override
        public void consume() {
            ParquetOutputRecordWriter.this.consumer.addBinary(Binary.fromByteBuffer((ByteBuffer)this.holder.buffer.nioBuffer(this.holder.start, this.holder.end - this.holder.start)));
        }
    }

    public class Var16CharParquetConverter
    extends BaseFieldConverter {
        private NullableVar16CharHolder holder;

        public Var16CharParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableVar16CharHolder();
        }

        @Override
        public void read() {
            this.reader.read(this.holder);
        }

        @Override
        public void read(int i) {
            this.reader.read(i, this.holder);
        }

        @Override
        public void consume() {
            ParquetOutputRecordWriter.this.consumer.addBinary(Binary.fromByteBuffer((ByteBuffer)this.holder.buffer.nioBuffer(this.holder.start, this.holder.end - this.holder.start)));
        }
    }

    public class VarDecimalParquetConverter
    extends BaseFieldConverter {
        private NullableVarDecimalHolder holder;
        private final DecimalValueWriter decimalValueWriter;

        public VarDecimalParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableVarDecimalHolder();
            this.decimalValueWriter = DecimalValueWriter.getDecimalValueWriterForType(ParquetOutputRecordWriter.this.getPrimitiveType(reader.getField()).getPrimitiveTypeName());
        }

        @Override
        public void read() {
            this.reader.read(this.holder);
        }

        @Override
        public void read(int i) {
            this.reader.read(i, this.holder);
        }

        @Override
        public void consume() {
            this.decimalValueWriter.writeValue(ParquetOutputRecordWriter.this.consumer, this.holder.buffer, this.holder.start, this.holder.end, this.reader.getField().getPrecision());
        }
    }

    public class BitParquetConverter
    extends BaseFieldConverter {
        private NullableBitHolder holder;

        public BitParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableBitHolder();
        }

        @Override
        public void read() {
            this.reader.read(this.holder);
        }

        @Override
        public void read(int i) {
            this.reader.read(i, this.holder);
        }

        @Override
        public void consume() {
            ParquetOutputRecordWriter.this.consumer.addBoolean(this.holder.value == 1);
        }
    }

    private static class IntervalUtility {
        private IntervalUtility() {
        }

        private static void intToLEByteArray(int value, byte[] output, int outputIndex) {
            int shiftOrder = 0;
            for (int i = outputIndex; i < outputIndex + 4; ++i) {
                output[i] = (byte)(value >> shiftOrder);
                shiftOrder += 8;
            }
        }
    }
}

