/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import java.util.HashMap;
import java.util.Map;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.resultSet.RowSetLoader;
import org.apache.drill.exec.record.metadata.MetadataUtils;
import org.apache.drill.exec.record.metadata.PrimitiveColumnMetadata;
import org.apache.drill.exec.vector.accessor.ScalarWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImplicitColumnUtils {
    private static final Logger logger = LoggerFactory.getLogger(ImplicitColumnUtils.class);

    public static class ImplicitColumn {
        private final String fieldName;
        private final TypeProtos.MinorType dataType;
        private final int columnIndex;
        private final ScalarWriter writer;
        private Object value;

        public ImplicitColumn(String fieldName, TypeProtos.MinorType dataType, RowSetLoader rowWriter) {
            this.dataType = dataType;
            this.fieldName = fieldName;
            this.columnIndex = this.addImplicitColumnToSchema(this.fieldName, this.dataType, rowWriter);
            this.writer = rowWriter.scalar(this.columnIndex);
        }

        public ImplicitColumn(String fieldName, TypeProtos.MinorType dataType, RowSetLoader rowWriter, Object value) {
            this.dataType = dataType;
            this.fieldName = fieldName;
            this.columnIndex = this.addImplicitColumnToSchema(this.fieldName, this.dataType, rowWriter);
            this.writer = rowWriter.scalar(this.columnIndex);
            this.value = value;
        }

        private int addImplicitColumnToSchema(String fieldName, TypeProtos.MinorType type, RowSetLoader rowWriter) {
            PrimitiveColumnMetadata colSchema = MetadataUtils.newScalar(fieldName, type, TypeProtos.DataMode.OPTIONAL);
            colSchema.setBooleanProperty("drill.special", true);
            return rowWriter.addColumn(colSchema);
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public TypeProtos.MinorType getDataType() {
            return this.dataType;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object v) {
            this.value = v;
        }

        public ScalarWriter getWriter() {
            return this.writer;
        }
    }

    public static class ImplicitColumns {
        private final Map<String, ImplicitColumn> implicitColumns = new HashMap<String, ImplicitColumn>();
        private final RowSetLoader rowWriter;

        public ImplicitColumns(RowSetLoader rowWriter) {
            this.rowWriter = rowWriter;
        }

        public void addImplicitColumn(String fieldName, TypeProtos.MinorType type) {
            this.implicitColumns.put(fieldName, new ImplicitColumn(fieldName, type, this.rowWriter));
        }

        public ImplicitColumn getColumn(String fieldName) {
            return this.implicitColumns.get(fieldName);
        }

        public void writeImplicitColumns() {
            block8: for (Map.Entry<String, ImplicitColumn> columnEntry : this.implicitColumns.entrySet()) {
                ImplicitColumn column = columnEntry.getValue();
                ScalarWriter writer = column.writer;
                TypeProtos.MinorType dataType = column.dataType;
                Object value = column.value;
                switch (dataType) {
                    case INT: {
                        writer.setInt((Integer)value);
                        continue block8;
                    }
                    case BIGINT: {
                        writer.setLong((Long)value);
                        continue block8;
                    }
                    case FLOAT4: {
                        writer.setFloat(((Float)value).floatValue());
                        continue block8;
                    }
                    case FLOAT8: {
                        writer.setDouble((Double)value);
                        continue block8;
                    }
                    case VARCHAR: {
                        writer.setString((String)value);
                        continue block8;
                    }
                    case BIT: {
                        writer.setBoolean((Boolean)value);
                        continue block8;
                    }
                }
                logger.warn("{} types are not implemented as implicit fields.", (Object)dataType);
            }
        }
    }
}

