/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.planner.logical.StoragePlugins;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.ConnectorLocator;
import org.apache.drill.exec.store.PluginBootstrapLoader;
import org.apache.drill.exec.store.PluginBootstrapLoaderImpl;
import org.apache.drill.exec.store.PluginRegistryContext;
import org.apache.drill.exec.store.PrivatePlugin;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.SystemPlugin;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.drill.shaded.guava.com.google.common.base.Joiner;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassicConnectorLocator
implements ConnectorLocator {
    private static final Logger logger = LoggerFactory.getLogger(ClassicConnectorLocator.class);
    private final PluginRegistryContext context;
    private final Map<Class<? extends StoragePluginConfig>, Constructor<? extends StoragePlugin>> availablePlugins = new IdentityHashMap<Class<? extends StoragePluginConfig>, Constructor<? extends StoragePlugin>>();
    private PluginBootstrapLoader bootstrapLoader;

    public ClassicConnectorLocator(PluginRegistryContext context) {
        this.context = Preconditions.checkNotNull(context);
        this.bootstrapLoader = new PluginBootstrapLoaderImpl(context);
    }

    @Override
    public void init() {
        Set<Class<StoragePlugin>> pluginClasses = this.context.classpathScan().getImplementations(StoragePlugin.class);
        String lineBrokenList = pluginClasses.size() == 0 ? "" : "\n\t- " + Joiner.on("\n\t- ").join(pluginClasses);
        logger.debug("Found {} storage plugin configuration classes: {}.", (Object)pluginClasses.size(), (Object)lineBrokenList);
        for (Class clazz : pluginClasses) {
            if (clazz.isAnnotationPresent(SystemPlugin.class) || clazz.isAnnotationPresent(PrivatePlugin.class)) continue;
            this.registerPlugin(clazz);
        }
        DrillConfig config = this.context.config();
        if (config.hasPath("drill.exec.storage.private_connectors")) {
            List list = config.getStringList("drill.exec.storage.private_connectors");
            for (String privateName : list) {
                this.registerPrivatePlugin(privateName);
            }
        }
    }

    private void registerPrivatePlugin(String pluginName) {
        Class<?> pluginClass;
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            pluginClass = cl.loadClass(pluginName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Private plugin class not found: " + pluginName, e);
        }
        if (!StoragePlugin.class.isAssignableFrom(pluginClass)) {
            throw new IllegalArgumentException("Private plugin class does not extend StoragePlugin: " + pluginName);
        }
        if (!this.registerPlugin(pluginClass)) {
            throw new IllegalArgumentException("Private plugin class not valid, see logs: " + pluginName);
        }
    }

    private boolean registerPlugin(Class<? extends StoragePlugin> plugin) {
        Map<Class<? extends StoragePluginConfig>, Constructor<? extends StoragePlugin>> ctors = ClassicConnectorLocator.constuctorsFor(plugin);
        if (ctors.isEmpty()) {
            logger.debug("Skipping registration of StoragePlugin {} as it doesn't have a constructor with the parameters of (StoragePluginConfig, Config)", (Object)plugin.getCanonicalName());
            return false;
        }
        for (Map.Entry<Class<? extends StoragePluginConfig>, Constructor<? extends StoragePlugin>> ctor : ctors.entrySet()) {
            if (this.availablePlugins.containsKey(ctor.getKey())) {
                logger.warn(String.format("Two storage plugins cannot use the same config class. Found conflict %s and %s both use %s. Only the first added to registry.", this.availablePlugins.get(ctor.getKey()).getDeclaringClass().getName(), ctor.getValue().getDeclaringClass().getName(), ctor.getKey().getName()));
                continue;
            }
            this.availablePlugins.put(ctor.getKey(), ctor.getValue());
        }
        return true;
    }

    public static Map<Class<? extends StoragePluginConfig>, Constructor<? extends StoragePlugin>> constuctorsFor(Class<? extends StoragePlugin> plugin) {
        IdentityHashMap<Class<? extends StoragePluginConfig>, Constructor<? extends StoragePlugin>> ctors = new IdentityHashMap<Class<? extends StoragePluginConfig>, Constructor<? extends StoragePlugin>>();
        for (Constructor<?> c : plugin.getConstructors()) {
            Class<?>[] params = c.getParameterTypes();
            if (params.length != 3 || !StoragePluginConfig.class.isAssignableFrom(params[0]) || params[1] != DrillbitContext.class || params[2] != String.class) {
                logger.debug("Skipping StoragePlugin constructor {} for plugin class {} since it doesn't implement a constructor(StoragePluginConfig, DrillbitContext, String)", c, plugin);
                continue;
            }
            Class<?> configClass = params[0];
            ctors.put(configClass, c);
        }
        return ctors;
    }

    @Override
    @VisibleForTesting
    public Set<Class<? extends StoragePluginConfig>> configClasses() {
        return this.availablePlugins.keySet();
    }

    @Override
    public StoragePlugin get(String name) {
        return null;
    }

    public List<StoragePlugin> intrinsicPlugins() {
        return null;
    }

    @Override
    public StoragePlugins bootstrapPlugins() throws IOException {
        return this.bootstrapLoader.bootstrapPlugins();
    }

    @Override
    public StoragePlugins updatedPlugins() {
        return this.bootstrapLoader.updatedPlugins();
    }

    @Override
    public void onUpgrade() {
        this.bootstrapLoader.onUpgrade();
        this.bootstrapLoader = null;
    }

    @Override
    public StoragePlugin create(String name, StoragePluginConfig pluginConfig) throws ExecutionSetupException {
        Constructor<? extends StoragePlugin> constructor = this.availablePlugins.get(pluginConfig.getClass());
        if (constructor == null) {
            throw new ExecutionSetupException(String.format("Failure finding StoragePlugin constructor for config %s", pluginConfig.getClass().getName()));
        }
        try {
            StoragePlugin plugin = constructor.newInstance(pluginConfig, this.context.drillbitContext(), name);
            return plugin;
        }
        catch (ReflectiveOperationException e) {
            ReflectiveOperationException t;
            Throwable throwable = t = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e;
            if (t instanceof ExecutionSetupException) {
                throw (ExecutionSetupException)((Object)t);
            }
            throw new ExecutionSetupException(String.format("Failure setting up new storage plugin configuration for config %s", pluginConfig.getClass().getSimpleName()), t);
        }
    }

    @Override
    public boolean storable() {
        return true;
    }

    @Override
    public Class<? extends StoragePlugin> connectorClassFor(Class<? extends StoragePluginConfig> configClass) {
        Constructor<? extends StoragePlugin> constructor = this.availablePlugins.get(configClass);
        return constructor == null ? null : constructor.getDeclaringClass();
    }

    @Override
    public void close() {
    }
}

