/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.calcite.linq4j.tree.DefaultExpression;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.SchemaVersion;
import org.apache.calcite.schema.Table;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.dotdrill.View;
import org.apache.drill.exec.planner.logical.CreateTableEntry;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.logical.ModifyTableEntry;
import org.apache.drill.exec.record.metadata.schema.SchemaProvider;
import org.apache.drill.exec.record.metadata.schema.SchemaProviderFactory;
import org.apache.drill.exec.store.PartitionNotFoundException;
import org.apache.drill.exec.store.SchemaPartitionExplorer;
import org.apache.drill.exec.store.StorageStrategy;
import org.apache.drill.exec.store.table.function.TableParamDef;
import org.apache.drill.exec.store.table.function.TableSignature;
import org.apache.drill.exec.store.table.function.WithOptionsTableMacro;
import org.apache.drill.shaded.guava.com.google.common.base.Joiner;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSchema
implements Schema,
SchemaPartitionExplorer,
AutoCloseable {
    static final Logger logger = LoggerFactory.getLogger(AbstractSchema.class);
    private static final Expression EXPRESSION = new DefaultExpression(Object.class);
    private static final String SCHEMA_PARAMETER_NAME = "schema";
    private static final TableParamDef SCHEMA_PARAMETER = TableParamDef.optional("schema", String.class, (drillTable, value) -> {
        SchemaProvider schemaProvider;
        if (value == null) {
            return;
        }
        try {
            schemaProvider = SchemaProviderFactory.create(String.valueOf(value));
            schemaProvider.read();
        }
        catch (IOException | IllegalArgumentException e) {
            throw UserException.validationError(e).message(e.getMessage(), new Object[0]).addContext("Schema parameter value [%s]", value).build(logger);
        }
        drillTable.getMetadataProviderManager().setSchemaProvider(schemaProvider);
    });
    public static final String SCHEMA_SEPARATOR = ".";
    protected final List<String> schemaPath;
    protected final String name;

    public AbstractSchema(List<String> parentSchemaPath, String name) {
        name = name == null ? null : name.toLowerCase();
        this.schemaPath = new ArrayList<String>();
        this.schemaPath.addAll(parentSchemaPath);
        this.schemaPath.add(name);
        this.name = name;
    }

    @Override
    public Iterable<String> getSubPartitions(String table, List<String> partitionColumns, List<String> partitionValues) throws PartitionNotFoundException {
        throw new UnsupportedOperationException(String.format("Schema of type: %s does not support retrieving sub-partition information.", this.getClass().getSimpleName()));
    }

    public String getName() {
        return this.name;
    }

    public List<String> getSchemaPath() {
        return this.schemaPath;
    }

    public String getFullSchemaName() {
        return Joiner.on(SCHEMA_SEPARATOR).join(this.schemaPath);
    }

    public final String toString() {
        return this.getFullSchemaName();
    }

    public abstract String getTypeName();

    public Schema getDefaultSchema() {
        return this;
    }

    public boolean createView(View view) throws IOException {
        throw UserException.unsupportedError().message("Creating new view is not supported in schema [%s]", this.getSchemaPath()).build(logger);
    }

    public void dropView(String viewName) throws IOException {
        throw UserException.unsupportedError().message("Dropping a view is supported in schema [%s]", this.getSchemaPath()).build(logger);
    }

    public CreateTableEntry createNewTable(String tableName, List<String> partitionColumns, StorageStrategy storageStrategy) {
        throw UserException.unsupportedError().message("Creating new tables is not supported in schema [%s]", this.getSchemaPath()).build(logger);
    }

    public ModifyTableEntry modifyTable(String tableName) {
        throw UserException.unsupportedError().message("Modifying tables is not supported in schema [%s]", this.getSchemaPath()).build(logger);
    }

    public CreateTableEntry createNewTable(String tableName, List<String> partitionColumns) {
        return this.createNewTable(tableName, partitionColumns, StorageStrategy.DEFAULT);
    }

    public CreateTableEntry createStatsTable(String tableName) {
        throw UserException.unsupportedError().message("Statistics tables are not supported in schema [%s]", this.getSchemaPath()).build(logger);
    }

    public CreateTableEntry appendToStatsTable(String tableName) {
        throw UserException.unsupportedError().message("Statistics tables are not supported in schema [%s]", this.getSchemaPath()).build(logger);
    }

    public Table getStatsTable(String tableName) {
        throw UserException.unsupportedError().message("Statistics tables are not supported in schema [%s]", this.getSchemaPath()).build(logger);
    }

    public boolean showInInformationSchema() {
        return true;
    }

    public Collection<Function> getFunctions(String name) {
        List<TableParamDef> parameters = this.getFunctionParameters();
        TableSignature signature = TableSignature.of(name, parameters);
        WithOptionsTableMacro function = new WithOptionsTableMacro(signature, arguments -> {
            Table table = this.getTable(name);
            if (table instanceof DrillTable) {
                return this.applyFunctionParameters((DrillTable)table, parameters, (List<Object>)arguments);
            }
            if (table == null) {
                return null;
            }
            throw new DrillRuntimeException(String.format("Table [%s] is not of Drill table instance. Given instance is of [%s].", name, table.getClass().getName()));
        });
        return Collections.singletonList(function);
    }

    public List<TableParamDef> getFunctionParameters() {
        return Collections.singletonList(SCHEMA_PARAMETER);
    }

    public DrillTable applyFunctionParameters(DrillTable drillTable, List<TableParamDef> paramDefs, List<Object> values) {
        IntStream.range(0, paramDefs.size()).forEach(i -> ((TableParamDef)paramDefs.get(i)).apply(drillTable, values.get(i)));
        return drillTable;
    }

    protected Map<String, RelProtoDataType> getTypeMap() {
        return ImmutableMap.of();
    }

    public Set<String> getTypeNames() {
        return this.getTypeMap().keySet();
    }

    public RelProtoDataType getType(String name) {
        return this.getTypeMap().get(name);
    }

    public Set<String> getFunctionNames() {
        return Collections.emptySet();
    }

    public Schema getSubSchema(String name) {
        return null;
    }

    public Set<String> getSubSchemaNames() {
        return Collections.emptySet();
    }

    public boolean isMutable() {
        return false;
    }

    public Table getTable(String name) {
        return null;
    }

    public Set<String> getTableNames() {
        return Collections.emptySet();
    }

    public Expression getExpression(SchemaPlus parentSchema, String name) {
        return EXPRESSION;
    }

    @Override
    public void close() throws Exception {
    }

    public Schema snapshot(SchemaVersion version) {
        return this;
    }

    public void dropTable(String tableName) {
        throw UserException.unsupportedError().message("Dropping tables is not supported in schema [%s]", this.getSchemaPath()).build(logger);
    }

    public List<Pair<String, ? extends Table>> getTablesByNames(Set<String> tableNames) {
        return tableNames.stream().map(tableName -> Pair.of((Object)tableName, (Object)this.getTable((String)tableName))).filter(pair -> Objects.nonNull(pair.getValue())).collect(Collectors.toList());
    }

    public Collection<Map.Entry<String, Schema.TableType>> getTableNamesAndTypes() {
        return this.getTablesByNames(this.getTableNames()).stream().map(nameAndTable -> Pair.of((Object)((String)nameAndTable.getKey()), (Object)((Table)nameAndTable.getValue()).getJdbcTableType())).collect(Collectors.toList());
    }

    public boolean areTableNamesCaseSensitive() {
        return true;
    }

    public String getUser(String impersonated, String notImpersonated) {
        return notImpersonated;
    }

    public boolean needToImpersonateReadingData() {
        return false;
    }
}

