/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest.profile;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.drill.exec.server.rest.profile.SimpleDurationFormat;

public class TableBuilder {
    private static final String NO_BGCOLOR = "";
    private final NumberFormat format = NumberFormat.getInstance(Locale.US);
    private final DateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
    private final DecimalFormat dec = new DecimalFormat("0.00");
    private final DecimalFormat intformat = new DecimalFormat("#,###");
    private StringBuilder sb = new StringBuilder();
    private int w = 0;
    private int width;

    public TableBuilder(String[] columns, String[] columnTooltip) {
        this(columns, columnTooltip, false);
    }

    public TableBuilder(String[] columns, String[] columnTooltip, boolean isSortable) {
        this.width = columns.length;
        this.format.setMaximumFractionDigits(3);
        this.sb.append("<table class=\"table table-bordered text-right" + (isSortable ? " sortable" : NO_BGCOLOR) + "\">\n<thead><tr>");
        for (int i = 0; i < columns.length; ++i) {
            String tooltip;
            String cn = columns[i];
            String ctt = NO_BGCOLOR;
            if (columnTooltip != null && (tooltip = columnTooltip[i]) != null) {
                ctt = " title=\"" + tooltip + "\"";
            }
            this.sb.append("<th" + ctt + ">" + cn + "</th>");
        }
        this.sb.append("</tr></thead>\n<tbody>\n");
    }

    public void appendCell(String s) {
        this.appendCell(s, NO_BGCOLOR, null);
    }

    public void appendCell(String s, String backgroundColor) {
        this.appendCell(s, backgroundColor, null);
    }

    public void appendCell(String s, Map<String, String> kvPairs) {
        this.appendCell(s, NO_BGCOLOR, kvPairs);
    }

    public void appendCell(String s, String rowBackgroundColor, Map<String, String> kvPairs) {
        if (this.w == 0) {
            this.sb.append("<tr" + (rowBackgroundColor == null || rowBackgroundColor == NO_BGCOLOR ? NO_BGCOLOR : " style=\"background-color:" + rowBackgroundColor + "\"") + ">");
        }
        StringBuilder tdElemSB = new StringBuilder("<td");
        if (kvPairs != null) {
            for (String attributeName : kvPairs.keySet()) {
                String attributeText = " " + attributeName + "=\"" + kvPairs.get(attributeName) + "\"";
                tdElemSB.append(attributeText);
            }
        }
        tdElemSB.append(">").append(s).append("</td>");
        this.sb.append((CharSequence)tdElemSB);
        if (++this.w >= this.width) {
            this.sb.append("</tr>\n");
            this.w = 0;
        }
    }

    public void appendRepeated(String s, int n) {
        this.appendRepeated(s, n, null);
    }

    public void appendRepeated(String s, int n, Map<String, String> attributeMap) {
        for (int i = 0; i < n; ++i) {
            this.appendCell(s, attributeMap);
        }
    }

    public void appendTime(long d) {
        this.appendTime(d, null);
    }

    public void appendTime(long d, Map<String, String> attributeMap) {
        if (attributeMap == null) {
            attributeMap = new HashMap<String, String>();
        }
        attributeMap.put("data-order", String.valueOf(d));
        this.appendCell(this.dateFormat.format(d), null, attributeMap);
    }

    public void appendMillis(long p) {
        this.appendMillis(p, null);
    }

    public void appendMillis(long p, Map<String, String> attributeMap) {
        if (attributeMap == null) {
            attributeMap = new HashMap<String, String>();
        }
        attributeMap.put("data-order", String.valueOf(p));
        this.appendCell(new SimpleDurationFormat(0L, p).compact(), NO_BGCOLOR, attributeMap);
    }

    public void appendNanos(long p) {
        this.appendNanos(p, null);
    }

    public void appendNanos(long p, Map<String, String> attributeMap) {
        this.appendMillis(Math.round((double)p / 1000.0 / 1000.0), attributeMap);
    }

    public void appendPercent(double percentAsFraction) {
        this.appendCell(this.dec.format(100.0 * percentAsFraction).concat("%"), NO_BGCOLOR, null);
    }

    public void appendPercent(double percentAsFraction, Map<String, String> attributeMap) {
        this.appendCell(this.dec.format(100.0 * percentAsFraction).concat("%"), NO_BGCOLOR, attributeMap);
    }

    public void appendFormattedNumber(Number n) {
        this.appendCell(this.format.format(n), NO_BGCOLOR, null);
    }

    public void appendFormattedNumber(Number n, Map<String, String> attributeMap) {
        this.appendCell(this.format.format(n), NO_BGCOLOR, attributeMap);
    }

    public void appendFormattedInteger(long n) {
        this.appendCell(this.intformat.format(n), NO_BGCOLOR, null);
    }

    public void appendFormattedInteger(long n, Map<String, String> attributeMap) {
        this.appendCell(this.intformat.format(n), NO_BGCOLOR, attributeMap);
    }

    public void appendInteger(long l, Map<String, String> attributeMap) {
        this.appendCell(Long.toString(l), NO_BGCOLOR, attributeMap);
    }

    public void appendBytes(long l) {
        this.appendBytes(l, null);
    }

    public void appendBytes(long l, Map<String, String> attributeMap) {
        if (attributeMap == null) {
            attributeMap = new HashMap<String, String>();
        }
        attributeMap.put("data-order", String.valueOf(l));
        this.appendCell(this.bytePrint(l), NO_BGCOLOR, attributeMap);
    }

    private String bytePrint(long size) {
        double t = (double)size / Math.pow(1024.0, 4.0);
        if (t > 1.0) {
            return this.dec.format(t).concat("TB");
        }
        double g = (double)size / Math.pow(1024.0, 3.0);
        if (g > 1.0) {
            return this.dec.format(g).concat("GB");
        }
        double m = (double)size / Math.pow(1024.0, 2.0);
        if (m > 1.0) {
            return this.intformat.format(m).concat("MB");
        }
        double k = size / 1024L;
        if (k >= 1.0) {
            return this.intformat.format(k).concat("KB");
        }
        return "-";
    }

    public String build() {
        String rv = this.sb.append("\n</tbody>\n</table>").toString();
        this.sb = null;
        return rv;
    }
}

