/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest.profile;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.util.JacksonUtils;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.helper.QueryIdHelper;
import org.apache.drill.exec.server.options.OptionList;
import org.apache.drill.exec.server.options.OptionValue;
import org.apache.drill.exec.server.rest.WebServer;
import org.apache.drill.exec.server.rest.WebUtils;
import org.apache.drill.exec.server.rest.profile.Comparators;
import org.apache.drill.exec.server.rest.profile.FragmentWrapper;
import org.apache.drill.exec.server.rest.profile.OperatorPathBuilder;
import org.apache.drill.exec.server.rest.profile.OperatorWrapper;
import org.apache.drill.exec.server.rest.profile.ProfileUtil;
import org.apache.drill.exec.server.rest.profile.SimpleDurationFormat;
import org.apache.drill.exec.server.rest.profile.TableBuilder;
import org.apache.drill.shaded.guava.com.google.common.base.CaseFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileWrapper {
    private static final String ESTIMATED_LABEL = " (Estimated)";
    private static final String NOT_AVAILABLE_LABEL = "Not Available";
    private static final Logger logger = LoggerFactory.getLogger(ProfileWrapper.class);
    private static final ObjectMapper mapper = JacksonUtils.createObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private final UserBitShared.QueryProfile profile;
    private final String id;
    private final List<FragmentWrapper> fragmentProfiles;
    private final List<OperatorWrapper> operatorProfiles;
    private final Map<String, Long> majorFragmentTallyMap;
    private final long majorFragmentTallyTotal;
    private final OptionList options;
    private final boolean onlyImpersonationEnabled;
    private Map<String, String> physicalOperatorMap;
    private final String noProgressWarningThreshold;
    private final int defaultAutoLimit;
    private final boolean showEstimatedRows;
    private final String csrfToken;

    /*
     * WARNING - void declaration
     */
    public ProfileWrapper(UserBitShared.QueryProfile profile, DrillConfig drillConfig, HttpServletRequest request) {
        void var10_14;
        this.profile = profile;
        this.id = profile.hasQueryId() ? profile.getQueryId() : QueryIdHelper.getQueryId(profile.getId());
        this.defaultAutoLimit = drillConfig.getInt("drill.exec.http.web.client.resultset.autolimit.rows");
        String profileTextPlan = profile.hasPlan() ? profile.getPlan() : "";
        this.generateOpMap(profileTextPlan);
        this.csrfToken = WebUtils.getCsrfTokenFromHttpRequest(request);
        ArrayList<FragmentWrapper> fragmentProfiles = new ArrayList<FragmentWrapper>();
        ArrayList<UserBitShared.MajorFragmentProfile> majors = new ArrayList<UserBitShared.MajorFragmentProfile>(profile.getFragmentProfileList());
        Collections.sort(majors, Comparators.majorId);
        for (UserBitShared.MajorFragmentProfile major : majors) {
            fragmentProfiles.add(new FragmentWrapper(major, profile.getStart(), drillConfig));
        }
        this.fragmentProfiles = fragmentProfiles;
        this.majorFragmentTallyMap = new HashMap<String, Long>(majors.size());
        this.majorFragmentTallyTotal = this.tallyMajorFragmentCost(majors);
        ArrayList<OperatorWrapper> ows = new ArrayList<OperatorWrapper>();
        HashMap opmap = new HashMap();
        Collections.sort(majors, Comparators.majorId);
        for (UserBitShared.MajorFragmentProfile majorFragmentProfile : majors) {
            ArrayList<UserBitShared.MinorFragmentProfile> minors = new ArrayList<UserBitShared.MinorFragmentProfile>(majorFragmentProfile.getMinorFragmentProfileList());
            Collections.sort(minors, Comparators.minorId);
            for (UserBitShared.MinorFragmentProfile minor : minors) {
                String fragmentHostName = minor.getEndpoint().getAddress();
                ArrayList<UserBitShared.OperatorProfile> ops = new ArrayList<UserBitShared.OperatorProfile>(minor.getOperatorProfileList());
                Collections.sort(ops, Comparators.operatorId);
                for (UserBitShared.OperatorProfile op : ops) {
                    ImmutablePair ip = new ImmutablePair((Object)majorFragmentProfile.getMajorFragmentId(), (Object)op.getOperatorId());
                    if (!opmap.containsKey(ip)) {
                        ArrayList l = new ArrayList();
                        opmap.put(ip, l);
                    }
                    ((List)opmap.get(ip)).add(new ImmutablePair((Object)new ImmutablePair((Object)op, (Object)minor.getMinorFragmentId()), (Object)fragmentHostName));
                }
            }
        }
        ArrayList keys = new ArrayList(opmap.keySet());
        Collections.sort(keys);
        for (ImmutablePair ip : keys) {
            ows.add(new OperatorWrapper((Integer)ip.getLeft(), (List)opmap.get(ip), this.physicalOperatorMap, drillConfig));
        }
        this.operatorProfiles = ows;
        try {
            OptionList optionList = (OptionList)mapper.readValue(profile.getOptionsJson(), OptionList.class);
        }
        catch (Exception e) {
            logger.error("Unable to deserialize query options", (Throwable)e);
            OptionList optionList = new OptionList();
        }
        this.options = var10_14;
        this.onlyImpersonationEnabled = WebServer.isOnlyImpersonationEnabled(drillConfig);
        this.noProgressWarningThreshold = String.valueOf(drillConfig.getInt("drill.exec.http.profile.warning.progress.threshold"));
        this.showEstimatedRows = drillConfig.getBoolean("drill.exec.http.profile.statistics.estimated_rows.show");
    }

    private long tallyMajorFragmentCost(List<UserBitShared.MajorFragmentProfile> majorFragments) {
        long globalProcessNanos = 0L;
        for (UserBitShared.MajorFragmentProfile majorFP : majorFragments) {
            String majorFragmentId = new OperatorPathBuilder().setMajor(majorFP).build();
            long processNanos = 0L;
            for (UserBitShared.MinorFragmentProfile minorFP : majorFP.getMinorFragmentProfileList()) {
                for (UserBitShared.OperatorProfile op : minorFP.getOperatorProfileList()) {
                    processNanos += op.getProcessNanos();
                }
            }
            this.majorFragmentTallyMap.put(majorFragmentId, processNanos);
            globalProcessNanos += processNanos;
        }
        return globalProcessNanos;
    }

    public boolean hasAutoLimit() {
        return this.profile.hasAutoLimit();
    }

    public int getAutoLimit() {
        return this.profile.getAutoLimit();
    }

    public int getDefaultAutoLimit() {
        return this.defaultAutoLimit;
    }

    public boolean hasError() {
        return this.profile.hasError() && this.profile.getError() != null;
    }

    public UserBitShared.QueryProfile getProfile() {
        return this.profile;
    }

    public String getProfileDuration() {
        return new SimpleDurationFormat(this.profile.getStart(), this.profile.getEnd()).verbose();
    }

    public String getQueryId() {
        return this.id;
    }

    public String getQueryStateDisplayName() {
        return ProfileUtil.getQueryStateDisplayName(this.profile.getState());
    }

    public String getPlanningDuration() {
        if (this.profile.getPlanEnd() > 0L) {
            return new SimpleDurationFormat(this.profile.getStart(), this.profile.getPlanEnd()).verbose();
        }
        if (this.profile.getFragmentProfileCount() > 0) {
            long estimatedPlanEnd = Long.MAX_VALUE;
            UserBitShared.MajorFragmentProfile majorFrag0 = this.profile.getFragmentProfile(0);
            for (UserBitShared.MinorFragmentProfile fragmentWrapper : majorFrag0.getMinorFragmentProfileList()) {
                long minorFragmentStart = fragmentWrapper.getStartTime();
                if (minorFragmentStart <= 0L || minorFragmentStart >= estimatedPlanEnd) continue;
                estimatedPlanEnd = minorFragmentStart;
            }
            return new SimpleDurationFormat(this.profile.getStart(), estimatedPlanEnd).verbose() + ESTIMATED_LABEL;
        }
        return NOT_AVAILABLE_LABEL;
    }

    public String getQueuedDuration() {
        if (this.profile.getState() == UserBitShared.QueryResult.QueryState.ENQUEUED) {
            return new SimpleDurationFormat(this.profile.getPlanEnd(), System.currentTimeMillis()).verbose();
        }
        if (this.profile.getQueueWaitEnd() > 0L) {
            return new SimpleDurationFormat(this.profile.getPlanEnd(), this.profile.getQueueWaitEnd()).verbose();
        }
        return NOT_AVAILABLE_LABEL;
    }

    public String getExecutionDuration() {
        if (this.profile.getState() == UserBitShared.QueryResult.QueryState.PREPARING || this.profile.getState() == UserBitShared.QueryResult.QueryState.PLANNING || this.profile.getState() == UserBitShared.QueryResult.QueryState.STARTING || this.profile.getState() == UserBitShared.QueryResult.QueryState.ENQUEUED) {
            return NOT_AVAILABLE_LABEL;
        }
        long queryEndTime = this.profile.getState() == UserBitShared.QueryResult.QueryState.RUNNING ? System.currentTimeMillis() : this.profile.getEnd();
        if (this.profile.getQueueWaitEnd() > 0L) {
            return new SimpleDurationFormat(this.profile.getQueueWaitEnd(), queryEndTime).verbose();
        }
        if (this.profile.getPlanEnd() > 0L) {
            return new SimpleDurationFormat(this.profile.getPlanEnd(), queryEndTime).verbose();
        }
        if (this.profile.getFragmentProfileCount() > 0) {
            long estimatedPlanEnd = Long.MAX_VALUE;
            UserBitShared.MajorFragmentProfile majorFrag0 = this.profile.getFragmentProfile(0);
            for (UserBitShared.MinorFragmentProfile fragmentWrapper : majorFrag0.getMinorFragmentProfileList()) {
                long minorFragmentStart = fragmentWrapper.getStartTime();
                if (minorFragmentStart <= 0L || minorFragmentStart >= estimatedPlanEnd) continue;
                estimatedPlanEnd = minorFragmentStart;
            }
            return new SimpleDurationFormat(estimatedPlanEnd, queryEndTime).verbose() + ESTIMATED_LABEL;
        }
        return NOT_AVAILABLE_LABEL;
    }

    public String getNoProgressWarningThreshold() {
        return this.noProgressWarningThreshold;
    }

    public List<FragmentWrapper> getFragmentProfiles() {
        return this.fragmentProfiles;
    }

    public String getFragmentsOverview() {
        TableBuilder tb;
        if (this.profile.getState() == UserBitShared.QueryResult.QueryState.STARTING || this.profile.getState() == UserBitShared.QueryResult.QueryState.RUNNING) {
            tb = new TableBuilder(FragmentWrapper.ACTIVE_FRAGMENT_OVERVIEW_COLUMNS, FragmentWrapper.ACTIVE_FRAGMENT_OVERVIEW_COLUMNS_TOOLTIP);
            for (FragmentWrapper fw : this.fragmentProfiles) {
                fw.addSummary(tb);
            }
        } else {
            tb = new TableBuilder(FragmentWrapper.COMPLETED_FRAGMENT_OVERVIEW_COLUMNS, FragmentWrapper.COMPLETED_FRAGMENT_OVERVIEW_COLUMNS_TOOLTIP);
            for (FragmentWrapper fw : this.fragmentProfiles) {
                fw.addFinalSummary(tb);
            }
        }
        return tb.build();
    }

    public List<OperatorWrapper> getOperatorProfiles() {
        return this.operatorProfiles;
    }

    public String getOperatorsOverview() {
        TableBuilder tb = new TableBuilder(OperatorWrapper.OPERATORS_OVERVIEW_COLUMNS, OperatorWrapper.OPERATORS_OVERVIEW_COLUMNS_TOOLTIP);
        for (OperatorWrapper ow : this.operatorProfiles) {
            ow.addSummary(tb, this.majorFragmentTallyMap, this.majorFragmentTallyTotal);
        }
        return tb.build();
    }

    public Map<String, String> getOptions() {
        return this.getOptions(o -> true);
    }

    public Map<String, String> getSessionOptions() {
        return this.getOptions(o -> OptionValue.OptionScope.SESSION == o.getScope());
    }

    public Map<String, String> getQueryOptions() {
        return this.getOptions(o -> OptionValue.OptionScope.QUERY == o.getScope());
    }

    private Map<String, String> getOptions(Predicate<OptionValue> filter) {
        return this.options.stream().filter(filter).collect(Collectors.toMap(OptionValue::getName, o -> String.valueOf(o.getValue()), (o, n) -> n, TreeMap::new));
    }

    public boolean isOnlyImpersonationEnabled() {
        return this.onlyImpersonationEnabled;
    }

    private void generateOpMap(String plan) {
        String[] operatorLine;
        this.physicalOperatorMap = new HashMap<String, String>();
        if (plan.isEmpty()) {
            return;
        }
        for (String line : operatorLine = plan.split("\\n")) {
            String[] lineToken = line.split("\\s+", 3);
            if (lineToken.length < 2) continue;
            String operatorPath = lineToken[0].trim().replaceFirst("-", "-xx-");
            String extractedOperatorName = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, lineToken[1].split("\\(", 2)[0].trim());
            this.physicalOperatorMap.put(operatorPath, extractedOperatorName);
        }
    }

    public boolean showEstimatedRows() {
        return this.showEstimatedRows;
    }

    public String getCsrfToken() {
        return this.csrfToken;
    }
}

